/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetResult;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class RoutingContext {
    private final RemotingConnection connection;
    private final String clientID;
    private final String username;
    private TargetResult result;

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public String getRouter() {
        return this.connection.getTransportConnection().getRouter();
    }

    public Connection getTransportConnection() {
        return this.connection.getTransportConnection();
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUsername() {
        return this.username;
    }

    public Target getTarget() {
        return this.result.getTarget();
    }

    public TargetResult getResult() {
        return this.result;
    }

    public void setResult(TargetResult result) {
        this.result = result;
    }

    public RoutingContext(RemotingConnection connection, String clientID, String username) {
        this.connection = connection;
        this.clientID = clientID;
        this.username = username;
    }
}

