/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.Preconditions;
import org.apache.activemq.artemis.utils.UUID;

public class DuplicateIDEncoding
implements EncodingSupport {
    public SimpleString address;
    public byte[] duplID;

    public DuplicateIDEncoding(SimpleString address, byte[] duplID) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)duplID);
        this.address = address;
        this.duplID = duplID;
    }

    public DuplicateIDEncoding() {
    }

    public void decode(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        int size = buffer.readInt();
        this.duplID = new byte[size];
        buffer.readBytes(this.duplID);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeInt(this.duplID.length);
        buffer.writeBytes(this.duplID);
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.address) + 4 + this.duplID.length;
    }

    public String toString() {
        String bridgeRepresentation = null;
        if (this.address != null && this.address.toString().startsWith("BRIDGE") && this.duplID.length == 24) {
            try {
                ByteBuffer buff = ByteBuffer.wrap(this.duplID);
                byte[] bytesUUID = new byte[16];
                buff.get(bytesUUID);
                UUID uuid = new UUID(1, bytesUUID);
                long id = buff.getLong();
                bridgeRepresentation = "nodeUUID=" + uuid.toString() + " messageID=" + id;
            }
            catch (Throwable ignored) {
                bridgeRepresentation = null;
            }
        }
        if (bridgeRepresentation != null) {
            return "DuplicateIDEncoding [address=" + String.valueOf(this.address) + ", duplID=" + ByteUtil.bytesToHex((byte[])this.duplID, (int)2) + " / " + bridgeRepresentation + "]";
        }
        return "DuplicateIDEncoding [address=" + String.valueOf(this.address) + ", duplID=" + ByteUtil.bytesToHex((byte[])this.duplID, (int)2) + "]";
    }
}

