/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.CanWriteFileFilter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CanWriteFileFilterTest
extends BaseFilterTest {
    private static final String WRITABLE = "writable.txt";
    private static final String READONLY = "readonly.txt";
    private static File testDir;
    private static File writableFile;
    private static FileSelectInfo writableFileInfo;
    private static File readOnlyFile;
    private static FileSelectInfo readOnlyFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterAll
    public static void afterClass() throws IOException {
        writableFileInfo = null;
        CanWriteFileFilterTest.delete(writableFile);
        writableFile = null;
        readOnlyFileInfo = null;
        CanWriteFileFilterTest.delete(readOnlyFile);
        readOnlyFile = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        IOUtils.close((Closeable)zipFileObj);
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeAll
    public static void beforeClass() throws IOException {
        testDir = CanWriteFileFilterTest.getTestDir(CanWriteFileFilterTest.class.getName());
        writableFile = new File(testDir, WRITABLE);
        writableFileInfo = CanWriteFileFilterTest.createFileSelectInfo(writableFile);
        FileUtils.touch((File)writableFile);
        readOnlyFile = new File(testDir, READONLY);
        readOnlyFileInfo = CanWriteFileFilterTest.createFileSelectInfo(readOnlyFile);
        FileUtils.touch((File)readOnlyFile);
        readOnlyFile.setReadable(true);
        readOnlyFile.setWritable(false);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = CanWriteFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(CanWriteFileFilterTest.getTempDir(), CanWriteFileFilterTest.class.getName() + ".zip");
        CanWriteFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = CanWriteFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptCannotWrite() throws FileSystemException {
        Assertions.assertFalse((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(writableFileInfo));
        Assertions.assertTrue((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(readOnlyFileInfo));
        Assertions.assertFalse((boolean)CanWriteFileFilter.CANNOT_WRITE.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptCanWrite() throws FileSystemException {
        Assertions.assertTrue((boolean)CanWriteFileFilter.CAN_WRITE.accept(writableFileInfo));
        Assertions.assertFalse((boolean)CanWriteFileFilter.CAN_WRITE.accept(readOnlyFileInfo));
        Assertions.assertTrue((boolean)CanWriteFileFilter.CAN_WRITE.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanWriteFileFilter.CAN_WRITE));
        Assertions.assertTrue((files == null || files.length == 0 ? 1 : 0) != 0);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(CanWriteFileFilter.CANNOT_WRITE));
        this.assertContains(files, READONLY, WRITABLE);
        Assertions.assertEquals((int)2, (int)files.length);
    }
}

