/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsSiteCompressionMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.testing.MojoRule;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CommonsSiteCompressionMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";
    @Rule
    public final MojoRule rule = new MojoRule(){

        protected void after() {
        }

        protected void before() throws Throwable {
        }
    };
    protected CommonsSiteCompressionMojo mojo;

    @Before
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    public void testCompressSiteDirNonExistentFailure() throws Exception {
        File testPom = new File("src/test/resources/mojos/compress-site/compress-site-failure.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsSiteCompressionMojo)this.rule.lookupMojo("compress-site", testPom);
        try {
            this.mojo.execute();
        }
        catch (MojoFailureException e) {
            Assert.assertEquals((Object)"\"mvn site\" was not run before this goal, or a siteDirectory did not exist.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCompressSiteSuccess() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        testingDirectory.mkdir();
        File testPom = new File("src/test/resources/mojos/compress-site/compress-site.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsSiteCompressionMojo)this.rule.lookupMojo("compress-site", testPom);
        this.mojo.execute();
        File siteZip = new File("target/testing-commons-release-plugin/site.zip");
        TestCase.assertTrue((boolean)siteZip.exists());
    }

    @Test
    public void testDisabled() throws Exception {
        File testPom = new File("src/test/resources/mojos/compress-site/compress-site-disabled.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsSiteCompressionMojo)this.rule.lookupMojo("compress-site", testPom);
        this.mojo.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }
}

