/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import org.apache.commons.exec.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilTest {
    @Test
    public void testDefaultStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString());
    }

    @Test
    public void testErroneousTemplate() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        Assertions.assertEquals((Object)"This is a FOO & ${}} test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${}} test", vars, (boolean)true).toString());
    }

    @Test
    public void testIncompleteSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        Assertions.assertEquals((Object)"This is a FOO & ${bar} test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        try {
            StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString();
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNoStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a FOO & BAR test", vars, (boolean)true).toString());
    }
}

