/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.datasources.AbstractConnectionFactory;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.PooledConnectionManager;
import org.apache.commons.dbcp2.datasources.UserPassKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

final class KeyedCPDSConnectionFactory
extends AbstractConnectionFactory
implements KeyedPooledObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool;

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, Duration validationQueryTimeoutDuration, boolean rollbackAfterValidation) {
        super(cpds, validationQuery, validationQueryTimeoutDuration, rollbackAfterValidation);
    }

    public void activateObject(UserPassKey ignored, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void closePool(String userName) throws SQLException {
        try {
            this.pool.clear((Object)new UserPassKey(userName));
        }
        catch (Exception ex) {
            throw new SQLException("Error closing connection pool", ex);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo pci = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (pci == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject((Object)pci.getUserPassKey(), (Object)pci);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this.pool.invalidateObject((Object)pci.getUserPassKey(), (Object)pci);
                }
                catch (Exception e3) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
                    e3.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject((Object)info.getUserPassKey(), (Object)info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    public void destroyObject(UserPassKey ignored, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        PooledConnection pooledConnection = ((PooledConnectionAndInfo)pooledObject.getObject()).getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey key = info.getUserPassKey();
        try {
            this.pool.invalidateObject((Object)key, (Object)info);
            this.pool.clear((Object)key);
        }
        catch (Exception ex) {
            throw new SQLException("Error invalidating connection", ex);
        }
    }

    public synchronized PooledObject<PooledConnectionAndInfo> makeObject(UserPassKey userPassKey) throws SQLException {
        PooledConnection pooledConnection = null;
        String userName = userPassKey.getUserName();
        String password = userPassKey.getPassword();
        pooledConnection = userName == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(userName, password);
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        PooledConnectionAndInfo pci = new PooledConnectionAndInfo(pooledConnection, userPassKey);
        this.pcMap.put(pooledConnection, pci);
        return new DefaultPooledObject((Object)pci);
    }

    public void passivateObject(UserPassKey ignored, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void setPassword(char[] password) {
    }

    @Override
    public void setPassword(String password) {
    }

    public void setPool(KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool) {
        this.pool = pool;
    }

    public boolean validateObject(UserPassKey ignored, PooledObject<PooledConnectionAndInfo> pooledObject) {
        return super.validateObject(pooledObject);
    }
}

