/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.query.SQLTemplate;

public class FrontBaseTemplateAction
extends SQLTemplateAction {
    public FrontBaseTemplateAction(SQLTemplate query, DataNode dataNode) {
        super(query, dataNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(Connection connection, OperationObserver callback, SQLStatement compiled, Collection<Number> updateCounts) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        boolean iteratedResult = callback.isIteratedResult();
        PreparedStatement statement = connection.prepareStatement(compiled.getSql());
        try {
            ResultSet generatedKeysResultSet;
            this.bind(statement, compiled.getBindings());
            boolean isResultSet = statement.execute();
            if (this.query.isReturnGeneratedKeys() && (generatedKeysResultSet = statement.getGeneratedKeys()) != null) {
                this.processSelectResult(compiled, connection, statement, generatedKeysResultSet, callback, t1);
            }
            boolean firstIteration = true;
            while (true) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    isResultSet = statement.getMoreResults();
                }
                if (isResultSet) {
                    ResultSet resultSet = statement.getResultSet();
                    if (resultSet == null) continue;
                    try {
                        this.processSelectResult(compiled, connection, statement, resultSet, callback, t1);
                    }
                    finally {
                        if (!iteratedResult) {
                            resultSet.close();
                        }
                    }
                    if (!iteratedResult) continue;
                    break;
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                updateCounts.add(updateCount);
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
            }
        }
        finally {
            if (!iteratedResult) {
                statement.close();
            }
        }
    }
}

