/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Provide access to TensorFlow Serving model servers to run inference with
 * TensorFlow saved models remotely
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface TensorFlowServingEndpointBuilderFactory {

    /**
     * Builder for endpoint for the TensorFlow Serving component.
     */
    public interface TensorFlowServingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTensorFlowServingEndpointBuilder advanced() {
            return (AdvancedTensorFlowServingEndpointBuilder) this;
        }

        /**
         * Required servable name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelName the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder modelName(String modelName) {
            doSetProperty("modelName", modelName);
            return this;
        }
        /**
         * Optional choice of which version of the model to use. Use this
         * specific version number.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder modelVersion(Long modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
        /**
         * Optional choice of which version of the model to use. Use this
         * specific version number.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder modelVersion(String modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
        /**
         * Optional choice of which version of the model to use. Use the version
         * associated with the given label.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelVersionLabel the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder modelVersionLabel(String modelVersionLabel) {
            doSetProperty("modelVersionLabel", modelVersionLabel);
            return this;
        }
        /**
         * A named signature to evaluate. If unspecified, the default signature
         * will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param signatureName the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder signatureName(String signatureName) {
            doSetProperty("signatureName", signatureName);
            return this;
        }
        /**
         * The target URI of the client. See:
         * https://grpc.github.io/grpc-java/javadoc/io/grpc/Grpc.html#newChannelBuilder%28java.lang.String,io.grpc.ChannelCredentials%29.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: localhost:8500
         * Group: common
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder target(String target) {
            doSetProperty("target", target);
            return this;
        }
        /**
         * The credentials of the client.
         * 
         * The option is a: <code>io.grpc.ChannelCredentials</code> type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder credentials(io.grpc.ChannelCredentials credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * The credentials of the client.
         * 
         * The option will be converted to a
         * <code>io.grpc.ChannelCredentials</code> type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the TensorFlow Serving component.
     */
    public interface AdvancedTensorFlowServingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default TensorFlowServingEndpointBuilder basic() {
            return (TensorFlowServingEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTensorFlowServingEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTensorFlowServingEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface TensorFlowServingBuilders {
        /**
         * TensorFlow Serving (camel-tensorflow-serving)
         * Provide access to TensorFlow Serving model servers to run inference
         * with TensorFlow saved models remotely
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-tensorflow-serving
         * 
         * @return the dsl builder for the headers' name.
         */
        default TensorFlowServingHeaderNameBuilder tensorflowServing() {
            return TensorFlowServingHeaderNameBuilder.INSTANCE;
        }
        /**
         * TensorFlow Serving (camel-tensorflow-serving)
         * Provide access to TensorFlow Serving model servers to run inference
         * with TensorFlow saved models remotely
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-tensorflow-serving
         * 
         * Syntax: <code>tensorflow-serving:api</code>
         * 
         * Path parameter: api (required)
         * The TensorFlow Serving API
         * There are 5 enums and the value can be one of: model-status,
         * model-metadata, classify, regress, predict
         * 
         * @param path api
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder tensorflowServing(String path) {
            return TensorFlowServingEndpointBuilderFactory.endpointBuilder("tensorflow-serving", path);
        }
        /**
         * TensorFlow Serving (camel-tensorflow-serving)
         * Provide access to TensorFlow Serving model servers to run inference
         * with TensorFlow saved models remotely
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-tensorflow-serving
         * 
         * Syntax: <code>tensorflow-serving:api</code>
         * 
         * Path parameter: api (required)
         * The TensorFlow Serving API
         * There are 5 enums and the value can be one of: model-status,
         * model-metadata, classify, regress, predict
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path api
         * @return the dsl builder
         */
        default TensorFlowServingEndpointBuilder tensorflowServing(String componentName, String path) {
            return TensorFlowServingEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the TensorFlow Serving component.
     */
    public static class TensorFlowServingHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final TensorFlowServingHeaderNameBuilder INSTANCE = new TensorFlowServingHeaderNameBuilder();

        /**
         * The target of the client. See:
         * https://grpc.github.io/grpc-java/javadoc/io/grpc/Grpc.html#newChannelBuilder%28java.lang.String,io.grpc.ChannelCredentials%29.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TensorFlowServingTarget}.
         */
        public String tensorFlowServingTarget() {
            return "CamelTensorFlowServingTarget";
        }
        /**
         * The credentials of the client.
         * 
         * The option is a: {@code io.grpc.ChannelCredentials} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TensorFlowServingCredentials}.
         */
        public String tensorFlowServingCredentials() {
            return "CamelTensorFlowServingCredentials";
        }
        /**
         * Required servable name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TensorFlowServingModelName}.
         */
        public String tensorFlowServingModelName() {
            return "CamelTensorFlowServingModelName";
        }
        /**
         * Optional choice of which version of the model to use. Use this
         * specific version number.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TensorFlowServingModelVersion}.
         */
        public String tensorFlowServingModelVersion() {
            return "CamelTensorFlowServingModelVersion";
        }
        /**
         * Optional choice of which version of the model to use. Use the version
         * associated with the given label.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * TensorFlowServingModelVersionLabel}.
         */
        public String tensorFlowServingModelVersionLabel() {
            return "CamelTensorFlowServingModelVersionLabel";
        }
        /**
         * A named signature to evaluate. If unspecified, the default signature
         * will be used.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * TensorFlowServingSignatureName}.
         */
        public String tensorFlowServingSignatureName() {
            return "CamelTensorFlowServingSignatureName";
        }
    }
    static TensorFlowServingEndpointBuilder endpointBuilder(String componentName, String path) {
        class TensorFlowServingEndpointBuilderImpl extends AbstractEndpointBuilder implements TensorFlowServingEndpointBuilder, AdvancedTensorFlowServingEndpointBuilder {
            public TensorFlowServingEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new TensorFlowServingEndpointBuilderImpl(path);
    }
}