/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.jdbc.core.ADBColumn;
import org.apache.asterix.jdbc.core.ADBConnection;
import org.apache.asterix.jdbc.core.ADBDatatype;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBProtocolBase;
import org.apache.asterix.jdbc.core.ADBResultSet;
import org.apache.asterix.jdbc.core.ADBResultSetMetaData;
import org.apache.asterix.jdbc.core.ADBRowStore;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.core.JsonParser;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;

public class ADBStatement
extends ADBWrapperSupport
implements Statement {
    static final List<Class<?>> SET_OBJECT_ATOMIC_EXTRA = Arrays.asList(SqlCalendarDate.class, SqlCalendarTime.class, SqlCalendarTimestamp.class);
    static final List<Class<?>> SET_OBJECT_NON_ATOMIC = Arrays.asList(Object[].class, Collection.class, Map.class);
    static final Map<Class<?>, AbstractValueSerializer> SERIALIZER_MAP = ADBStatement.createSerializerMap();
    protected final ADBConnection connection;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean closeOnCompletion;
    protected int queryTimeoutSeconds;
    protected long maxRows;
    private volatile UUID executionId;
    protected int updateCount = -1;
    protected List<ADBProtocolBase.QueryServiceResponse.Message> warnings;
    protected final ConcurrentLinkedQueue<ADBResultSet> resultSetsWithResources;
    protected final ConcurrentLinkedQueue<WeakReference<ADBResultSet>> resultSetsWithoutResources;
    protected ADBProtocolBase.SubmitStatementOptions executeStmtOptions;
    protected ADBProtocolBase.QueryServiceResponse executeResponse;
    protected ADBResultSet executeResultSet;

    public ADBStatement(ADBConnection connection) {
        this.connection = Objects.requireNonNull(connection);
        this.resultSetsWithResources = new ConcurrentLinkedQueue();
        this.resultSetsWithoutResources = new ConcurrentLinkedQueue();
        this.resetExecutionId();
    }

    @Override
    public void close() throws SQLException {
        this.closeImpl(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl(boolean closeResultSets, boolean notifyConnection) throws SQLException {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        try {
            if (closeResultSets) {
                this.closeRegisteredResultSets();
            }
        }
        finally {
            if (notifyConnection) {
                this.connection.deregisterStatement(this);
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw this.getErrorReporter().errorObjectClosed(Statement.class);
        }
    }

    @Override
    public ADBResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        return this.executeQueryImpl(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ADBResultSet executeQueryImpl(String sql, List<?> args) throws SQLException {
        try {
            ADBProtocolBase.SubmitStatementOptions stmtOptions = this.createSubmitStatementOptions();
            stmtOptions.executionId = this.executionId;
            stmtOptions.forceReadOnly = true;
            ADBProtocolBase.QueryServiceResponse response = this.connection.protocol.submitStatement(sql, args, stmtOptions);
            boolean isQuery = this.connection.protocol.isStatementCategory(response, ADBProtocolBase.QueryServiceResponse.StatementCategory.QUERY);
            if (!isQuery) {
                throw this.getErrorReporter().errorInvalidStatementCategory();
            }
            this.warnings = this.connection.protocol.getWarningIfExists(response);
            this.updateCount = -1;
            ADBResultSet aDBResultSet = this.fetchResultSet(response, stmtOptions);
            return aDBResultSet;
        }
        finally {
            this.resetExecutionId();
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkClosed();
        return this.executeUpdateImpl(sql, null);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        return this.executeUpdateImpl(sql, null);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeLargeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdateImpl(String sql, List<Object> args) throws SQLException {
        try {
            ADBProtocolBase.SubmitStatementOptions stmtOptions = this.createSubmitStatementOptions();
            stmtOptions.executionId = this.executionId;
            ADBProtocolBase.QueryServiceResponse response = this.connection.protocol.submitStatement(sql, args, stmtOptions);
            boolean isQuery = this.connection.protocol.isStatementCategory(response, ADBProtocolBase.QueryServiceResponse.StatementCategory.QUERY);
            if (isQuery) {
                throw this.getErrorReporter().errorInvalidStatementCategory();
            }
            this.warnings = this.connection.protocol.getWarningIfExists(response);
            int n = this.updateCount = this.connection.protocol.getUpdateCount(response);
            return n;
        }
        finally {
            this.resetExecutionId();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        return this.executeImpl(sql, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "execute");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "execute");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "execute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeImpl(String sql, List<Object> args) throws SQLException {
        try {
            ADBProtocolBase.SubmitStatementOptions stmtOptions = this.createSubmitStatementOptions();
            stmtOptions.executionId = this.executionId;
            ADBProtocolBase.QueryServiceResponse response = this.connection.protocol.submitStatement(sql, args, stmtOptions);
            this.warnings = this.connection.protocol.getWarningIfExists(response);
            this.executeStmtOptions = stmtOptions;
            boolean isQuery = this.connection.protocol.isStatementCategory(response, ADBProtocolBase.QueryServiceResponse.StatementCategory.QUERY);
            if (isQuery) {
                this.updateCount = -1;
                this.executeResponse = response;
                boolean bl = true;
                return bl;
            }
            this.updateCount = this.connection.protocol.getUpdateCount(response);
            this.executeResponse = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.resetExecutionId();
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        this.connection.protocol.cancelRunningStatement(this.executionId);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int timeoutSeconds) throws SQLException {
        this.checkClosed();
        if (timeoutSeconds < 0) {
            throw this.getErrorReporter().errorParameterValueNotSupported("timeoutSeconds");
        }
        this.queryTimeoutSeconds = timeoutSeconds;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    private void resetExecutionId() {
        this.executionId = UUID.randomUUID();
    }

    protected ADBProtocolBase.SubmitStatementOptions createSubmitStatementOptions() {
        ADBProtocolBase.SubmitStatementOptions stmtOptions = this.connection.protocol.createSubmitStatementOptions();
        stmtOptions.dataverseName = this.connection.getDataverseCanonicalName();
        stmtOptions.sqlCompatMode = this.connection.sqlCompatMode;
        stmtOptions.timeoutSeconds = this.queryTimeoutSeconds;
        return stmtOptions;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeLargeBatch");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "executeBatch");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "addBatch");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "clearBatch");
    }

    @Override
    public ADBResultSet getResultSet() throws SQLException {
        ADBResultSet rs;
        this.checkClosed();
        ADBProtocolBase.QueryServiceResponse response = this.executeResponse;
        if (response == null) {
            return null;
        }
        this.executeResultSet = rs = this.fetchResultSet(response, this.executeStmtOptions);
        this.executeResponse = null;
        this.executeStmtOptions = null;
        return rs;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        ADBResultSet rs = this.executeResultSet;
        this.executeResultSet = null;
        if (rs != null && current != 2) {
            rs.closeImpl(true);
        }
        return false;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        return this.createEmptyResultSet();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    protected ADBResultSet fetchResultSet(ADBProtocolBase.QueryServiceResponse execResponse, ADBProtocolBase.SubmitStatementOptions stmtOptions) throws SQLException {
        List<ADBColumn> columns = this.connection.protocol.getColumns(execResponse);
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINE, "result schema " + columns);
        }
        if (this.connection.protocol.isExplainOnly(execResponse)) {
            AbstractValueSerializer stringSer = ADBStatement.getADMFormatSerializer(String.class);
            ArrayNode explainResult = this.connection.protocol.fetchExplainOnlyResult(execResponse, stringSer::serializeToString);
            return this.createSystemResultSet(columns, explainResult);
        }
        JsonParser rowParser = this.connection.protocol.fetchResult(execResponse, stmtOptions);
        return this.createResultSetImpl(columns, rowParser, true, this.maxRows);
    }

    protected ADBResultSet createSystemResultSet(List<ADBColumn> columns, ArrayNode values) {
        JsonParser rowParser = this.connection.protocol.getDriverContext().getGenericObjectReader().treeAsTokens(values);
        return this.createResultSetImpl(columns, rowParser, false, 0L);
    }

    protected ADBResultSet createEmptyResultSet() {
        ArrayNode empty = (ArrayNode)this.connection.protocol.getDriverContext().getGenericObjectReader().createArrayNode();
        return this.createSystemResultSet(Collections.emptyList(), empty);
    }

    protected ADBResultSet createResultSetImpl(List<ADBColumn> columns, JsonParser rowParser, boolean rowParserOwnsResources, long maxRows) {
        ADBResultSetMetaData metadata = new ADBResultSetMetaData(this, columns);
        ADBResultSet rs = new ADBResultSet(metadata, rowParser, rowParserOwnsResources, maxRows);
        this.registerResultSet(rs);
        return rs;
    }

    protected void registerResultSet(ADBResultSet rs) {
        if (rs.rowParserOwnsResources) {
            this.resultSetsWithResources.add(rs);
        } else {
            this.resultSetsWithoutResources.removeIf(ADBStatement::isEmptyReference);
            this.resultSetsWithoutResources.add(new WeakReference<ADBResultSet>(rs));
        }
    }

    protected void deregisterResultSet(ADBResultSet rs) {
        block5: {
            if (rs.rowParserOwnsResources) {
                this.resultSetsWithResources.remove(rs);
            } else {
                this.resultSetsWithoutResources.removeIf(ref -> {
                    ADBResultSet refrs = (ADBResultSet)ref.get();
                    return refrs == null || refrs == rs;
                });
            }
            if (this.closeOnCompletion && this.resultSetsWithResources.isEmpty() && this.resultSetsWithoutResources.isEmpty()) {
                try {
                    this.closeImpl(false, true);
                }
                catch (SQLException e) {
                    if (!this.getLogger().isLoggable(Level.FINE)) break block5;
                    this.getLogger().log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }

    protected void closeRegisteredResultSets() throws SQLException {
        SQLException err = null;
        try {
            this.closedRegisteredResultSetsImpl(this.resultSetsWithResources, Function.identity());
        }
        catch (SQLException e) {
            err = e;
        }
        try {
            this.closedRegisteredResultSetsImpl(this.resultSetsWithoutResources, Reference::get);
        }
        catch (SQLException e) {
            if (err != null) {
                e.addSuppressed(err);
            }
            err = e;
        }
        if (err != null) {
            throw err;
        }
    }

    protected <T> void closedRegisteredResultSetsImpl(Queue<T> queue, Function<T, ADBResultSet> rsAccessor) throws SQLException {
        T item;
        SQLException err = null;
        while ((item = queue.poll()) != null) {
            ADBResultSet rs = rsAccessor.apply(item);
            if (rs == null) continue;
            try {
                rs.closeImpl(false);
            }
            catch (SQLException e) {
                if (err != null) {
                    e.addSuppressed(err);
                }
                err = e;
            }
        }
        if (err != null) {
            throw err;
        }
    }

    private static boolean isEmptyReference(Reference<ADBResultSet> ref) {
        return ref.get() == null;
    }

    @Override
    public void setLargeMaxRows(long maxRows) throws SQLException {
        this.checkClosed();
        if (maxRows < 0L) {
            throw this.getErrorReporter().errorParameterValueNotSupported("maxRows");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.setLargeMaxRows(maxRows);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "setCursorName");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw this.getErrorReporter().errorParameterValueNotSupported("direction");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw this.getErrorReporter().errorParameterNotSupported("rows");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        throw this.getErrorReporter().errorMethodNotSupported(Statement.class, "setMaxFieldSize");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings != null ? this.connection.protocol.createSQLWarning(this.warnings) : null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.connection.getErrorReporter();
    }

    protected Logger getLogger() {
        return this.connection.getLogger();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    ADBStatement getResultSetStatement(ADBResultSet rs) {
        return rs.metadata.statement;
    }

    protected static void configureADMFormatSerialization(SimpleModule serdeModule) {
        serdeModule.setSerializerModifier(ADBStatement.createADMFormatSerializerModifier());
    }

    protected static AbstractValueSerializer getADMFormatSerializer(Class<?> cls) {
        return SERIALIZER_MAP.get(cls);
    }

    protected static BeanSerializerModifier createADMFormatSerializerModifier() {
        return new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                AnnotatedElement cls = beanDesc.getClassInfo().getAnnotated();
                if (ADBStatement.isSetObjectCompatible(cls)) {
                    AbstractValueSerializer ser = ADBStatement.getADMFormatSerializer(cls);
                    return ser != null ? ser : super.modifySerializer(config, beanDesc, serializer);
                }
                return null;
            }
        };
    }

    protected static boolean isSetObjectCompatible(Class<?> cls) {
        if (ADBRowStore.OBJECT_ACCESSORS_ATOMIC.containsKey(cls) || SET_OBJECT_ATOMIC_EXTRA.contains(cls)) {
            return true;
        }
        for (Class<?> aClass : SET_OBJECT_NON_ATOMIC) {
            if (!aClass.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    protected static Map<Class<?>, AbstractValueSerializer> createSerializerMap() {
        HashMap serializerMap = new HashMap();
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createGenericSerializer(Byte.class, ADBDatatype.TINYINT));
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createGenericSerializer(Short.class, ADBDatatype.SMALLINT));
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createGenericSerializer(Integer.class, ADBDatatype.INTEGER));
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createGenericSerializer(UUID.class, ADBDatatype.UUID));
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createFloatSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createDoubleSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createBigDecimalSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createStringSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlDateSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlDateWithCalendarSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createLocalDateSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlTimeSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlCalendarTimeSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createLocalTimeSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlTimestampSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createSqlCalendarTimestampSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createLocalDateTimeSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createPeriodSerializer());
        ADBStatement.registerSerializer(serializerMap, ADBStatement.createDurationSerializer());
        return serializerMap;
    }

    protected static void registerSerializer(Map<Class<?>, AbstractValueSerializer> map, AbstractValueSerializer serializer) {
        map.put(serializer.getJavaType(), serializer);
    }

    protected static ATaggedValueSerializer createGenericSerializer(Class<?> javaType, ADBDatatype ADBDatatype2) {
        return new ATaggedValueSerializer((Class)javaType, ADBDatatype2){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                out.append(value);
            }
        };
    }

    protected static AbstractValueSerializer createStringSerializer() {
        return new AbstractValueSerializer((Class)String.class){

            @Override
            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(this.serializeToString(value));
            }

            @Override
            protected String serializeToString(Object value) {
                return ':' + String.valueOf(value);
            }
        };
    }

    protected static ATaggedValueSerializer createFloatSerializer() {
        return new ATaggedValueSerializer((Class)Float.class, ADBDatatype.FLOAT){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                int bits = Float.floatToIntBits(((Float)value).floatValue());
                out.append((long)bits);
            }
        };
    }

    protected static ATaggedValueSerializer createDoubleSerializer() {
        return new ATaggedValueSerializer((Class)Double.class, ADBDatatype.DOUBLE){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long bits = Double.doubleToLongBits((Double)value);
                out.append(bits);
            }
        };
    }

    protected static ATaggedValueSerializer createBigDecimalSerializer() {
        return new ATaggedValueSerializer((Class)BigDecimal.class, ADBDatatype.DOUBLE){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long bits = Double.doubleToLongBits(((BigDecimal)value).doubleValue());
                out.append(bits);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlDateSerializer() {
        return new ATaggedValueSerializer((Class)Date.class, ADBDatatype.DATE){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long millis = ((Date)value).getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, TimeZone.getDefault());
                long days = TimeUnit.MILLISECONDS.toDays(millisAdjusted);
                out.append(days);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlDateWithCalendarSerializer() {
        return new ATaggedValueSerializer((Class)SqlCalendarDate.class, ADBDatatype.DATE){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                SqlCalendarDate dateWithCalendar = (SqlCalendarDate)value;
                long millis = dateWithCalendar.date.getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, dateWithCalendar.timeZone);
                long days = TimeUnit.MILLISECONDS.toDays(millisAdjusted);
                out.append(days);
            }
        };
    }

    protected static ATaggedValueSerializer createLocalDateSerializer() {
        return new ATaggedValueSerializer((Class)LocalDate.class, ADBDatatype.DATE){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long days = ((LocalDate)value).toEpochDay();
                out.append(days);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlTimeSerializer() {
        return new ATaggedValueSerializer((Class)Time.class, ADBDatatype.TIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long millis = ((Time)value).getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, TimeZone.getDefault());
                long timeMillis = millisAdjusted - TimeUnit.DAYS.toMillis(TimeUnit.MILLISECONDS.toDays(millisAdjusted));
                out.append(timeMillis);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlCalendarTimeSerializer() {
        return new ATaggedValueSerializer((Class)SqlCalendarTime.class, ADBDatatype.TIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                SqlCalendarTime timeWithCalendar = (SqlCalendarTime)value;
                long millis = timeWithCalendar.time.getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, timeWithCalendar.timeZone);
                long timeMillis = millisAdjusted - TimeUnit.DAYS.toMillis(TimeUnit.MILLISECONDS.toDays(millisAdjusted));
                out.append(timeMillis);
            }
        };
    }

    protected static ATaggedValueSerializer createLocalTimeSerializer() {
        return new ATaggedValueSerializer((Class)LocalTime.class, ADBDatatype.TIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long nanos = ((LocalTime)value).toNanoOfDay();
                long timeMillis = TimeUnit.NANOSECONDS.toMillis(nanos);
                out.append(timeMillis);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlTimestampSerializer() {
        return new ATaggedValueSerializer((Class)Timestamp.class, ADBDatatype.DATETIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long millis = ((Timestamp)value).getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, TimeZone.getDefault());
                out.append(millisAdjusted);
            }
        };
    }

    protected static ATaggedValueSerializer createSqlCalendarTimestampSerializer() {
        return new ATaggedValueSerializer((Class)SqlCalendarTimestamp.class, ADBDatatype.DATETIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                SqlCalendarTimestamp timestampWithCalendar = (SqlCalendarTimestamp)value;
                long millis = timestampWithCalendar.timestamp.getTime();
                long millisAdjusted = this.getDatetimeChrononAdjusted(millis, timestampWithCalendar.timeZone);
                out.append(millisAdjusted);
            }
        };
    }

    protected static ATaggedValueSerializer createLocalDateTimeSerializer() {
        return new ATaggedValueSerializer((Class)LocalDateTime.class, ADBDatatype.DATETIME){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long millis = ((LocalDateTime)value).atZone(TZ_UTC).toInstant().toEpochMilli();
                out.append(millis);
            }
        };
    }

    protected static ATaggedValueSerializer createPeriodSerializer() {
        return new ATaggedValueSerializer((Class)Period.class, ADBDatatype.YEARMONTHDURATION){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long months = ((Period)value).toTotalMonths();
                out.append(months);
            }
        };
    }

    protected static ATaggedValueSerializer createDurationSerializer() {
        return new ATaggedValueSerializer((Class)Duration.class, ADBDatatype.DAYTIMEDURATION){

            @Override
            protected void serializeNonTaggedValue(Object value, StringBuilder out) {
                long millis = ((Duration)value).toMillis();
                out.append(millis);
            }
        };
    }

    protected static abstract class AbstractValueSerializer
    extends JsonSerializer<Object> {
        protected final Class<?> javaType;

        protected AbstractValueSerializer(Class<?> javaType) {
            this.javaType = Objects.requireNonNull(javaType);
        }

        protected Class<?> getJavaType() {
            return this.javaType;
        }

        abstract String serializeToString(Object var1);
    }

    protected static abstract class ATaggedValueSerializer
    extends AbstractValueSerializer {
        protected static ZoneId TZ_UTC = ZoneId.of("UTC");
        protected final ADBDatatype adbType;

        protected ATaggedValueSerializer(Class<?> javaType, ADBDatatype adbType) {
            super(javaType);
            this.adbType = Objects.requireNonNull(adbType);
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(this.serializeToString(value));
        }

        @Override
        protected final String serializeToString(Object value) {
            StringBuilder textBuilder = new StringBuilder(64);
            ATaggedValueSerializer.printByteAsHex(this.adbType.getTypeTag(), textBuilder);
            textBuilder.append(':');
            this.serializeNonTaggedValue(value, textBuilder);
            return textBuilder.toString();
        }

        protected abstract void serializeNonTaggedValue(Object var1, StringBuilder var2);

        private static void printByteAsHex(byte b, StringBuilder out) {
            out.append(ATaggedValueSerializer.hex(b >>> 4 & 0xF));
            out.append(ATaggedValueSerializer.hex(b & 0xF));
        }

        private static char hex(int i) {
            return (char)(i + (i < 10 ? 48 : 55));
        }

        protected long getDatetimeChrononAdjusted(long datetimeChrononInMillis, TimeZone tz) {
            int tzOffset = tz.getOffset(datetimeChrononInMillis);
            return datetimeChrononInMillis + (long)tzOffset;
        }
    }

    protected static final class SqlCalendarDate
    extends AbstractSqlCalendarDateTime {
        final Date date;

        SqlCalendarDate(Date date, TimeZone timeZone) {
            super(timeZone);
            this.date = date;
        }
    }

    protected static final class SqlCalendarTime
    extends AbstractSqlCalendarDateTime {
        final Time time;

        SqlCalendarTime(Time time, TimeZone timeZone) {
            super(timeZone);
            this.time = time;
        }
    }

    protected static final class SqlCalendarTimestamp
    extends AbstractSqlCalendarDateTime {
        final Timestamp timestamp;

        SqlCalendarTimestamp(Timestamp timestamp, TimeZone timeZone) {
            super(timeZone);
            this.timestamp = timestamp;
        }
    }

    protected static abstract class AbstractSqlCalendarDateTime {
        final TimeZone timeZone;

        AbstractSqlCalendarDateTime(TimeZone timeZone) {
            this.timeZone = timeZone;
        }
    }
}

