/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestoreFromClusterSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clusterIdentifier;
    private String snapshotIdentifier;
    private String snapshotClusterIdentifier;
    private Integer port;
    private String availabilityZone;
    private Boolean allowVersionUpgrade;
    private String clusterSubnetGroupName;
    private Boolean publiclyAccessible;
    private String ownerAccount;
    private String hsmClientCertificateIdentifier;
    private String hsmConfigurationIdentifier;
    private String elasticIp;
    private String clusterParameterGroupName;
    private ListWithAutoConstructFlag<String> clusterSecurityGroups;
    private ListWithAutoConstructFlag<String> vpcSecurityGroupIds;
    private String preferredMaintenanceWindow;
    private Integer automatedSnapshotRetentionPeriod;

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public RestoreFromClusterSnapshotRequest withClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
        return this;
    }

    public String getSnapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public void setSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
    }

    public RestoreFromClusterSnapshotRequest withSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
        return this;
    }

    public String getSnapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
        this.snapshotClusterIdentifier = snapshotClusterIdentifier;
    }

    public RestoreFromClusterSnapshotRequest withSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
        this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RestoreFromClusterSnapshotRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public RestoreFromClusterSnapshotRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public RestoreFromClusterSnapshotRequest withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
        return this;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public RestoreFromClusterSnapshotRequest withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public RestoreFromClusterSnapshotRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
        return this;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public void setOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public RestoreFromClusterSnapshotRequest withOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
        return this;
    }

    public String getHsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
    }

    public RestoreFromClusterSnapshotRequest withHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
        this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        return this;
    }

    public String getHsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
    }

    public RestoreFromClusterSnapshotRequest withHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        return this;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public RestoreFromClusterSnapshotRequest withElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
        return this;
    }

    public String getClusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public void setClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
    }

    public RestoreFromClusterSnapshotRequest withClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
        return this;
    }

    public List<String> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new ListWithAutoConstructFlag();
            this.clusterSecurityGroups.setAutoConstruct(true);
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
        clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
        this.clusterSecurityGroups = clusterSecurityGroupsCopy;
    }

    public RestoreFromClusterSnapshotRequest withClusterSecurityGroups(String ... clusterSecurityGroups) {
        if (this.getClusterSecurityGroups() == null) {
            this.setClusterSecurityGroups(new ArrayList<String>(clusterSecurityGroups.length));
        }
        for (String value : clusterSecurityGroups) {
            this.getClusterSecurityGroups().add(value);
        }
        return this;
    }

    public RestoreFromClusterSnapshotRequest withClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
            clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
            this.clusterSecurityGroups = clusterSecurityGroupsCopy;
        }
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new ListWithAutoConstructFlag();
            this.vpcSecurityGroupIds.setAutoConstruct(true);
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
        vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
        this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
    }

    public RestoreFromClusterSnapshotRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.getVpcSecurityGroupIds() == null) {
            this.setVpcSecurityGroupIds(new ArrayList<String>(vpcSecurityGroupIds.length));
        }
        for (String value : vpcSecurityGroupIds) {
            this.getVpcSecurityGroupIds().add(value);
        }
        return this;
    }

    public RestoreFromClusterSnapshotRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
            vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
            this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
        }
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public RestoreFromClusterSnapshotRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public RestoreFromClusterSnapshotRequest withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: " + this.getClusterIdentifier() + ",");
        }
        if (this.getSnapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: " + this.getSnapshotIdentifier() + ",");
        }
        if (this.getSnapshotClusterIdentifier() != null) {
            sb.append("SnapshotClusterIdentifier: " + this.getSnapshotClusterIdentifier() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.isAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: " + this.isAllowVersionUpgrade() + ",");
        }
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: " + this.getClusterSubnetGroupName() + ",");
        }
        if (this.isPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.isPubliclyAccessible() + ",");
        }
        if (this.getOwnerAccount() != null) {
            sb.append("OwnerAccount: " + this.getOwnerAccount() + ",");
        }
        if (this.getHsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: " + this.getHsmClientCertificateIdentifier() + ",");
        }
        if (this.getHsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: " + this.getHsmConfigurationIdentifier() + ",");
        }
        if (this.getElasticIp() != null) {
            sb.append("ElasticIp: " + this.getElasticIp() + ",");
        }
        if (this.getClusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: " + this.getClusterParameterGroupName() + ",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: " + this.getClusterSecurityGroups() + ",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: " + this.getVpcSecurityGroupIds() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: " + this.getAutomatedSnapshotRetentionPeriod());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotIdentifier() == null ? 0 : this.getSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotClusterIdentifier() == null ? 0 : this.getSnapshotClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.isAllowVersionUpgrade() == null ? 0 : this.isAllowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isPubliclyAccessible() == null ? 0 : this.isPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAccount() == null ? 0 : this.getOwnerAccount().hashCode());
        hashCode = 31 * hashCode + (this.getHsmClientCertificateIdentifier() == null ? 0 : this.getHsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getHsmConfigurationIdentifier() == null ? 0 : this.getHsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIp() == null ? 0 : this.getElasticIp().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroupName() == null ? 0 : this.getClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : this.getClusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : this.getVpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getSnapshotIdentifier() == null ^ this.getSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotIdentifier() != null && !other.getSnapshotIdentifier().equals(this.getSnapshotIdentifier())) {
            return false;
        }
        if (other.getSnapshotClusterIdentifier() == null ^ this.getSnapshotClusterIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotClusterIdentifier() != null && !other.getSnapshotClusterIdentifier().equals(this.getSnapshotClusterIdentifier())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.isAllowVersionUpgrade() == null ^ this.isAllowVersionUpgrade() == null) {
            return false;
        }
        if (other.isAllowVersionUpgrade() != null && !other.isAllowVersionUpgrade().equals(this.isAllowVersionUpgrade())) {
            return false;
        }
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.isPubliclyAccessible() == null ^ this.isPubliclyAccessible() == null) {
            return false;
        }
        if (other.isPubliclyAccessible() != null && !other.isPubliclyAccessible().equals(this.isPubliclyAccessible())) {
            return false;
        }
        if (other.getOwnerAccount() == null ^ this.getOwnerAccount() == null) {
            return false;
        }
        if (other.getOwnerAccount() != null && !other.getOwnerAccount().equals(this.getOwnerAccount())) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() == null ^ this.getHsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.getHsmClientCertificateIdentifier() != null && !other.getHsmClientCertificateIdentifier().equals(this.getHsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() == null ^ this.getHsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() != null && !other.getHsmConfigurationIdentifier().equals(this.getHsmConfigurationIdentifier())) {
            return false;
        }
        if (other.getElasticIp() == null ^ this.getElasticIp() == null) {
            return false;
        }
        if (other.getElasticIp() != null && !other.getElasticIp().equals(this.getElasticIp())) {
            return false;
        }
        if (other.getClusterParameterGroupName() == null ^ this.getClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getClusterParameterGroupName() != null && !other.getClusterParameterGroupName().equals(this.getClusterParameterGroupName())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !other.getClusterSecurityGroups().equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !other.getVpcSecurityGroupIds().equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        return other.getAutomatedSnapshotRetentionPeriod() == null || other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod());
    }
}

