/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.multipart;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MultipartInputStream
extends FilterInputStream {
    private InputStream input;
    private byte[] boundary;
    private byte[] storedBuffer;
    private int storedBufferPosition;
    private boolean fakeEof;
    private boolean realEof;
    private boolean bufferEnd;
    private int[] lastTable = new int[256];

    public MultipartInputStream(InputStream input, byte[] boundary) {
        super(input);
        this.input = input;
        this.boundary = boundary;
        this.computeLastTable();
    }

    public void skipBoundary() throws IOException {
        byte[] buffer = new byte[256];
        while (this.read(buffer) != -1) {
        }
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int bytesReaded = -1;
        if (!this.checkEndOfFile()) {
            byte[] newBuffer;
            int position;
            int bufferLength = Math.max(this.boundary.length * 3, length + this.boundary.length);
            if (bufferLength >= (position = this.cleanStoredBuffer(newBuffer = new byte[bufferLength], 0, bufferLength))) {
                position += this.readBuffer(newBuffer, position, bufferLength - position);
            }
            if (this.realEof && position == 0) {
                return -1;
            }
            bytesReaded = this.getBytesReaded(buffer, newBuffer, offset, position, length);
        }
        return bytesReaded != 0 ? bytesReaded : -1;
    }

    private int readBuffer(byte[] buffer, int offset, int length) throws IOException {
        int count = 0;
        int read = 0;
        do {
            if ((read = this.input.read(buffer, offset + count, length - count)) <= 0) continue;
            count += read;
        } while (read > 0 && count < length);
        if (read < 0) {
            this.realEof = true;
        }
        return count;
    }

    private boolean checkEndOfFile() {
        if (this.fakeEof) {
            this.fakeEof = false;
            return true;
        }
        if (this.realEof && this.storedBuffer == null) {
            return true;
        }
        if (this.realEof && !this.bufferEnd) {
            this.bufferEnd = true;
        }
        return false;
    }

    private int getBytesReaded(byte[] buffer, byte[] newBuffer, int offSet, int position, int length) {
        int bytesReaded;
        int boundaryPosition = this.locateBoundary(newBuffer, this.boundary.length - 1, position);
        if (length < boundaryPosition || boundaryPosition == -1) {
            bytesReaded = Math.min(length, position);
            this.createStoredBuffer(newBuffer, bytesReaded, position);
        } else {
            bytesReaded = boundaryPosition;
            this.createStoredBuffer(newBuffer, bytesReaded + this.boundary.length, position);
            if (bytesReaded == 0) {
                return -1;
            }
            this.fakeEof = true;
        }
        System.arraycopy(newBuffer, 0, buffer, offSet, bytesReaded);
        return bytesReaded;
    }

    private void createStoredBuffer(byte[] buffer, int start, int end) {
        int length = end - start;
        if (length > 0) {
            if (this.bufferEnd && this.storedBuffer != null) {
                this.storedBufferPosition -= length;
            } else {
                int bufferLength = this.storedBuffer == null ? 0 : this.storedBuffer.length - this.storedBufferPosition;
                byte[] newBuffer = new byte[length + bufferLength];
                System.arraycopy(buffer, start, newBuffer, 0, length);
                if (this.storedBuffer != null) {
                    System.arraycopy(this.storedBuffer, this.storedBufferPosition, newBuffer, length, bufferLength);
                }
                this.storedBuffer = newBuffer;
                this.storedBufferPosition = 0;
            }
        }
    }

    private int cleanStoredBuffer(byte[] buffer, int offset, int length) {
        int i = 0;
        if (this.storedBuffer != null) {
            for (i = 0; i < length && this.storedBufferPosition < this.storedBuffer.length; ++i) {
                buffer[offset + i] = this.storedBuffer[this.storedBufferPosition++];
            }
            if (this.storedBufferPosition >= this.storedBuffer.length) {
                this.storedBuffer = null;
                this.storedBufferPosition = 0;
            }
        }
        return i;
    }

    private void computeLastTable() {
        Arrays.fill(this.lastTable, this.boundary.length);
        for (int i = 0; i < this.boundary.length - 1; ++i) {
            this.lastTable[this.boundary[i] & 0xFF] = this.boundary.length - i - 1;
        }
    }

    private int locateBoundary(byte[] bytes, int start, int end) {
        int position = -1;
        if (end > this.boundary.length) {
            int j = 0;
            int k = 0;
            for (int i = start; i < end; i += this.lastTable[bytes[i] & 0xFF]) {
                k = i;
                for (j = this.boundary.length - 1; j >= 0 && this.boundary[j] == bytes[k]; --j) {
                    --k;
                }
                if (j != -1) continue;
                position = k + 1;
            }
        }
        return position;
    }
}

