/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanExpression
extends BinaryExpression
implements Negatable {
    public BooleanExpression(Expression p1, int operator, Expression p2) {
        super(p1, operator, p2);
    }

    @Override
    public String getExpressionName() {
        return Token.tokens[this.getOperator()] + "-expression";
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e == this) {
            XPathException err0 = TypeChecker.ebvError(this.operand0, visitor.getConfiguration().getTypeHierarchy());
            if (err0 != null) {
                err0.setLocator(this);
                throw err0;
            }
            XPathException err1 = TypeChecker.ebvError(this.operand1, visitor.getConfiguration().getTypeHierarchy());
            if (err1 != null) {
                err1.setLocator(this);
                throw err1;
            }
            if (this.operand0 instanceof Literal && !(((Literal)this.operand0).getValue() instanceof BooleanValue)) {
                this.operand0 = Literal.makeLiteral(BooleanValue.get(this.operand0.effectiveBooleanValue(visitor.makeDynamicContext())), this.getContainer());
            }
            if (this.operand1 instanceof Literal && !(((Literal)this.operand1).getValue() instanceof BooleanValue)) {
                this.operand1 = Literal.makeLiteral(BooleanValue.get(this.operand1.effectiveBooleanValue(visitor.makeDynamicContext())), this.getContainer());
            }
        }
        return e;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression op1;
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        boolean forStreaming = visitor.isOptimizeForStreaming();
        this.operand0 = ExpressionTool.unsortedIfHomogeneous(this.operand0, forStreaming);
        this.operand1 = ExpressionTool.unsortedIfHomogeneous(this.operand1, forStreaming);
        Expression op0 = BooleanFn.rewriteEffectiveBooleanValue(this.operand0, visitor, contextItemType);
        if (op0 != null) {
            this.operand0 = op0;
        }
        if ((op1 = BooleanFn.rewriteEffectiveBooleanValue(this.operand1, visitor, contextItemType)) != null) {
            this.operand1 = op1;
        }
        return this;
    }

    protected Expression forceToBoolean(Expression in, TypeHierarchy th) {
        if (in.getItemType() == BuiltInAtomicType.BOOLEAN && in.getCardinality() == 16384) {
            return in;
        }
        return SystemFunctionCall.makeSystemFunction("boolean", new Expression[]{in});
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.operand0, OperandRole.INSPECT), new Operand(this.operand1, OperandRole.INSPECT));
    }

    @Override
    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    @Override
    public abstract Expression negate();

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public abstract boolean effectiveBooleanValue(XPathContext var1) throws XPathException;

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static void listAndComponents(Expression exp, List<Expression> list) {
        if (exp instanceof BooleanExpression && ((BooleanExpression)exp).getOperator() == 10) {
            for (Operand o : exp.operands()) {
                BooleanExpression.listAndComponents(o.getExpression(), list);
            }
        } else {
            list.add(exp);
        }
    }
}

