/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Project;
import org.apache.airavata.registry.core.experiment.catalog.model.ProjectUser;
import org.apache.airavata.registry.core.experiment.catalog.model.ProjectUserPK;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUserResource
extends AbstractExpCatResource {
    private String projectId;
    private String userName;
    private static final Logger logger = LoggerFactory.getLogger(ProjectUserResource.class);

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            ProjectUserPK projectUserPK = new ProjectUserPK();
            projectUserPK.setProjectId(this.projectId);
            projectUserPK.setUserName(this.userName);
            ProjectUser existingPrUser = (ProjectUser)em.find(ProjectUser.class, (Object)projectUserPK);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ProjectUser prUser = new ProjectUser();
            prUser.setProjectId(this.projectId);
            prUser.setUserName(this.userName);
            Project project = (Project)em.find(Project.class, (Object)this.projectId);
            prUser.setProject(project);
            if (existingPrUser != null) {
                existingPrUser.setProjectId(this.projectId);
                existingPrUser.setUserName(this.userName);
                existingPrUser.setProject(project);
                em.merge((Object)existingPrUser);
            } else {
                em.persist((Object)prUser);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

