/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.sample;

import java.util.ArrayList;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.util.ExperimentModelUtil;
import org.apache.airavata.orchestrator.cpi.OrchestratorService;
import org.apache.thrift.TException;

public class OrchestratorClientSample {
    private static OrchestratorService.Client orchestratorClient;
    private static int NUM_CONCURRENT_REQUESTS;
    private static final String DEFAULT_USER = "default.registry.user";
    private static final String DEFAULT_USER_PASSWORD = "default.registry.password";
    private static final String DEFAULT_GATEWAY = "default.registry.gateway";
    private static String sysUser;
    private static String sysUserPwd;
    private static String gateway;

    public static void storeExperimentDetail() {
        for (int i = 0; i < NUM_CONCURRENT_REQUESTS; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
                    InputDataObjectType input = new InputDataObjectType();
                    input.setName("echo_input");
                    input.setType(DataType.STRING);
                    input.setValue("echo_output=Hello World");
                    exInputs.add(input);
                    ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
                    OutputDataObjectType output = new OutputDataObjectType();
                    output.setName("echo_output");
                    output.setType(DataType.STRING);
                    output.setValue("");
                    exOut.add(output);
                    ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)OrchestratorClientSample.DEFAULT_GATEWAY, (String)"default", (String)"admin", (String)"echoExperiment", (String)"SimpleEcho2", (String)"SimpleEcho2", exInputs);
                    simpleExperiment.setExperimentOutputs(exOut);
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"trestles.sdsc.edu", (int)1, (int)1, (int)1, (String)"normal", (int)0, (int)0);
                    scheduling.setResourceHostId("gsissh-trestles");
                    UserConfigurationDataModel userConfigurationDataModel = new UserConfigurationDataModel();
                    userConfigurationDataModel.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationDataModel);
                    String expId = null;
                    try {
                        orchestratorClient.launchExperiment(expId, "airavataToken");
                    }
                    catch (TException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        NUM_CONCURRENT_REQUESTS = 1;
    }
}

