/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.QueryFilter;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.spec.AbstractCollectionSpec;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QuerySpec
extends AbstractCollectionSpec<QueryRequest> {
    private KeyAttribute hashKey;
    private RangeKeyCondition rangeKeyCondition;
    private Collection<QueryFilter> queryFilters;
    private String filterExpression;
    private String projectionExpression;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;
    private Collection<KeyAttribute> exclusiveStartKey;

    public QuerySpec() {
        super(new QueryRequest());
    }

    public KeyAttribute getHashKey() {
        return this.hashKey;
    }

    public QuerySpec withHashKey(KeyAttribute hashKey) {
        this.hashKey = hashKey;
        return this;
    }

    public QuerySpec withHashKey(String hashKeyName, Object hashKeyValue) {
        this.hashKey = new KeyAttribute(hashKeyName, hashKeyValue);
        return this;
    }

    public RangeKeyCondition getRangeKeyCondition() {
        return this.rangeKeyCondition;
    }

    public QuerySpec withRangeKeyCondition(RangeKeyCondition rangeKeyCondition) {
        this.rangeKeyCondition = rangeKeyCondition;
        return this;
    }

    public QuerySpec withAttributesToGet(String ... attributes) {
        ((QueryRequest)this.getRequest()).withAttributesToGet(Arrays.asList(attributes));
        return this;
    }

    public List<String> getAttributesToGet() {
        return ((QueryRequest)this.getRequest()).getAttributesToGet();
    }

    public QuerySpec withConditionalOperator(ConditionalOperator op) {
        ((QueryRequest)this.getRequest()).withConditionalOperator(op);
        return this;
    }

    public String getConditionalOperator() {
        return ((QueryRequest)this.getRequest()).getConditionalOperator();
    }

    public QuerySpec withConsistentRead(boolean consistentRead) {
        ((QueryRequest)this.getRequest()).setConsistentRead(consistentRead);
        return this;
    }

    public boolean isConsistentRead() {
        return ((QueryRequest)this.getRequest()).isConsistentRead();
    }

    public QuerySpec withQueryFilters(QueryFilter ... queryFilters) {
        if (queryFilters == null) {
            this.queryFilters = null;
        } else {
            HashSet<String> names = new HashSet<String>();
            for (QueryFilter e : queryFilters) {
                names.add(e.getAttribute());
            }
            if (names.size() != queryFilters.length) {
                throw new IllegalArgumentException("attribute names must not duplicate in the list of query filters");
            }
            this.queryFilters = Arrays.asList(queryFilters);
        }
        return this;
    }

    public Collection<QueryFilter> getQueryFilters() {
        return this.queryFilters;
    }

    public QuerySpec withFilterExpression(String expression) {
        this.filterExpression = expression;
        return this;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public QuerySpec withProjectionExpression(String expression) {
        this.projectionExpression = expression;
        return this;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public QuerySpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new HashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public QuerySpec withValueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(valueMap));
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((QueryRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public QuerySpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        ((QueryRequest)this.getRequest()).setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public QuerySpec withScanIndexForward(boolean scanIndexForward) {
        ((QueryRequest)this.getRequest()).withScanIndexForward(scanIndexForward);
        return this;
    }

    public boolean isScanIndexForward() {
        return ((QueryRequest)this.getRequest()).isScanIndexForward();
    }

    public QuerySpec withSelect(Select select) {
        ((QueryRequest)this.getRequest()).withSelect(select);
        return this;
    }

    public String getSelect() {
        return ((QueryRequest)this.getRequest()).getSelect();
    }

    public Collection<KeyAttribute> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public QuerySpec withExclusiveStartKey(KeyAttribute ... exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : Arrays.asList(exclusiveStartKey);
        return this;
    }

    public QuerySpec withExclusiveStartKey(PrimaryKey exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : exclusiveStartKey.getComponents();
        return this;
    }

    public QuerySpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    public QuerySpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    public QuerySpec withMaxResultSize(Integer maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public QuerySpec withMaxResultSize(int maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public QuerySpec withMaxPageSize(Integer maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public QuerySpec withMaxPageSize(int maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public QuerySpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public QuerySpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

