/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.opsworks.AWSOpsWorksAsync;
import com.amazonaws.services.opsworks.AWSOpsWorksClient;
import com.amazonaws.services.opsworks.model.AssignVolumeRequest;
import com.amazonaws.services.opsworks.model.AssociateElasticIpRequest;
import com.amazonaws.services.opsworks.model.AttachElasticLoadBalancerRequest;
import com.amazonaws.services.opsworks.model.CloneStackRequest;
import com.amazonaws.services.opsworks.model.CloneStackResult;
import com.amazonaws.services.opsworks.model.CreateAppRequest;
import com.amazonaws.services.opsworks.model.CreateAppResult;
import com.amazonaws.services.opsworks.model.CreateDeploymentRequest;
import com.amazonaws.services.opsworks.model.CreateDeploymentResult;
import com.amazonaws.services.opsworks.model.CreateInstanceRequest;
import com.amazonaws.services.opsworks.model.CreateInstanceResult;
import com.amazonaws.services.opsworks.model.CreateLayerRequest;
import com.amazonaws.services.opsworks.model.CreateLayerResult;
import com.amazonaws.services.opsworks.model.CreateStackRequest;
import com.amazonaws.services.opsworks.model.CreateStackResult;
import com.amazonaws.services.opsworks.model.CreateUserProfileRequest;
import com.amazonaws.services.opsworks.model.CreateUserProfileResult;
import com.amazonaws.services.opsworks.model.DeleteAppRequest;
import com.amazonaws.services.opsworks.model.DeleteInstanceRequest;
import com.amazonaws.services.opsworks.model.DeleteLayerRequest;
import com.amazonaws.services.opsworks.model.DeleteStackRequest;
import com.amazonaws.services.opsworks.model.DeleteUserProfileRequest;
import com.amazonaws.services.opsworks.model.DeregisterElasticIpRequest;
import com.amazonaws.services.opsworks.model.DeregisterRdsDbInstanceRequest;
import com.amazonaws.services.opsworks.model.DeregisterVolumeRequest;
import com.amazonaws.services.opsworks.model.DescribeAppsRequest;
import com.amazonaws.services.opsworks.model.DescribeAppsResult;
import com.amazonaws.services.opsworks.model.DescribeCommandsRequest;
import com.amazonaws.services.opsworks.model.DescribeCommandsResult;
import com.amazonaws.services.opsworks.model.DescribeDeploymentsRequest;
import com.amazonaws.services.opsworks.model.DescribeDeploymentsResult;
import com.amazonaws.services.opsworks.model.DescribeElasticIpsRequest;
import com.amazonaws.services.opsworks.model.DescribeElasticIpsResult;
import com.amazonaws.services.opsworks.model.DescribeElasticLoadBalancersRequest;
import com.amazonaws.services.opsworks.model.DescribeElasticLoadBalancersResult;
import com.amazonaws.services.opsworks.model.DescribeInstancesRequest;
import com.amazonaws.services.opsworks.model.DescribeInstancesResult;
import com.amazonaws.services.opsworks.model.DescribeLayersRequest;
import com.amazonaws.services.opsworks.model.DescribeLayersResult;
import com.amazonaws.services.opsworks.model.DescribeLoadBasedAutoScalingRequest;
import com.amazonaws.services.opsworks.model.DescribeLoadBasedAutoScalingResult;
import com.amazonaws.services.opsworks.model.DescribeMyUserProfileRequest;
import com.amazonaws.services.opsworks.model.DescribeMyUserProfileResult;
import com.amazonaws.services.opsworks.model.DescribePermissionsRequest;
import com.amazonaws.services.opsworks.model.DescribePermissionsResult;
import com.amazonaws.services.opsworks.model.DescribeRaidArraysRequest;
import com.amazonaws.services.opsworks.model.DescribeRaidArraysResult;
import com.amazonaws.services.opsworks.model.DescribeRdsDbInstancesRequest;
import com.amazonaws.services.opsworks.model.DescribeRdsDbInstancesResult;
import com.amazonaws.services.opsworks.model.DescribeServiceErrorsRequest;
import com.amazonaws.services.opsworks.model.DescribeServiceErrorsResult;
import com.amazonaws.services.opsworks.model.DescribeStackSummaryRequest;
import com.amazonaws.services.opsworks.model.DescribeStackSummaryResult;
import com.amazonaws.services.opsworks.model.DescribeStacksRequest;
import com.amazonaws.services.opsworks.model.DescribeStacksResult;
import com.amazonaws.services.opsworks.model.DescribeTimeBasedAutoScalingRequest;
import com.amazonaws.services.opsworks.model.DescribeTimeBasedAutoScalingResult;
import com.amazonaws.services.opsworks.model.DescribeUserProfilesRequest;
import com.amazonaws.services.opsworks.model.DescribeUserProfilesResult;
import com.amazonaws.services.opsworks.model.DescribeVolumesRequest;
import com.amazonaws.services.opsworks.model.DescribeVolumesResult;
import com.amazonaws.services.opsworks.model.DetachElasticLoadBalancerRequest;
import com.amazonaws.services.opsworks.model.DisassociateElasticIpRequest;
import com.amazonaws.services.opsworks.model.GetHostnameSuggestionRequest;
import com.amazonaws.services.opsworks.model.GetHostnameSuggestionResult;
import com.amazonaws.services.opsworks.model.RebootInstanceRequest;
import com.amazonaws.services.opsworks.model.RegisterElasticIpRequest;
import com.amazonaws.services.opsworks.model.RegisterElasticIpResult;
import com.amazonaws.services.opsworks.model.RegisterRdsDbInstanceRequest;
import com.amazonaws.services.opsworks.model.RegisterVolumeRequest;
import com.amazonaws.services.opsworks.model.RegisterVolumeResult;
import com.amazonaws.services.opsworks.model.SetLoadBasedAutoScalingRequest;
import com.amazonaws.services.opsworks.model.SetPermissionRequest;
import com.amazonaws.services.opsworks.model.SetTimeBasedAutoScalingRequest;
import com.amazonaws.services.opsworks.model.StartInstanceRequest;
import com.amazonaws.services.opsworks.model.StartStackRequest;
import com.amazonaws.services.opsworks.model.StopInstanceRequest;
import com.amazonaws.services.opsworks.model.StopStackRequest;
import com.amazonaws.services.opsworks.model.UnassignVolumeRequest;
import com.amazonaws.services.opsworks.model.UpdateAppRequest;
import com.amazonaws.services.opsworks.model.UpdateElasticIpRequest;
import com.amazonaws.services.opsworks.model.UpdateInstanceRequest;
import com.amazonaws.services.opsworks.model.UpdateLayerRequest;
import com.amazonaws.services.opsworks.model.UpdateMyUserProfileRequest;
import com.amazonaws.services.opsworks.model.UpdateRdsDbInstanceRequest;
import com.amazonaws.services.opsworks.model.UpdateStackRequest;
import com.amazonaws.services.opsworks.model.UpdateUserProfileRequest;
import com.amazonaws.services.opsworks.model.UpdateVolumeRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSOpsWorksAsyncClient
extends AWSOpsWorksClient
implements AWSOpsWorksAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSOpsWorksAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSOpsWorksAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSOpsWorksAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSOpsWorksAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSOpsWorksAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSOpsWorksAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSOpsWorksAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSOpsWorksAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSOpsWorksAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deregisterRdsDbInstanceAsync(final DeregisterRdsDbInstanceRequest deregisterRdsDbInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deregisterRdsDbInstance(deregisterRdsDbInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterRdsDbInstanceAsync(final DeregisterRdsDbInstanceRequest deregisterRdsDbInstanceRequest, final AsyncHandler<DeregisterRdsDbInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deregisterRdsDbInstance(deregisterRdsDbInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deregisterRdsDbInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> registerRdsDbInstanceAsync(final RegisterRdsDbInstanceRequest registerRdsDbInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.registerRdsDbInstance(registerRdsDbInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> registerRdsDbInstanceAsync(final RegisterRdsDbInstanceRequest registerRdsDbInstanceRequest, final AsyncHandler<RegisterRdsDbInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.registerRdsDbInstance(registerRdsDbInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerRdsDbInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateMyUserProfileAsync(final UpdateMyUserProfileRequest updateMyUserProfileRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateMyUserProfile(updateMyUserProfileRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateMyUserProfileAsync(final UpdateMyUserProfileRequest updateMyUserProfileRequest, final AsyncHandler<UpdateMyUserProfileRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateMyUserProfile(updateMyUserProfileRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateMyUserProfileRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterVolumeAsync(final DeregisterVolumeRequest deregisterVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deregisterVolume(deregisterVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterVolumeAsync(final DeregisterVolumeRequest deregisterVolumeRequest, final AsyncHandler<DeregisterVolumeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deregisterVolume(deregisterVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deregisterVolumeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setPermissionAsync(final SetPermissionRequest setPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.setPermission(setPermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setPermissionAsync(final SetPermissionRequest setPermissionRequest, final AsyncHandler<SetPermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.setPermission(setPermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setPermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeInstancesResult> describeInstancesAsync(final DescribeInstancesRequest describeInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstancesResult>(){

            @Override
            public DescribeInstancesResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeInstances(describeInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstancesResult> describeInstancesAsync(final DescribeInstancesRequest describeInstancesRequest, final AsyncHandler<DescribeInstancesRequest, DescribeInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstancesResult>(){

            @Override
            public DescribeInstancesResult call() throws Exception {
                DescribeInstancesResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeInstances(describeInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribePermissionsResult> describePermissionsAsync(final DescribePermissionsRequest describePermissionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePermissionsResult>(){

            @Override
            public DescribePermissionsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describePermissions(describePermissionsRequest);
            }
        });
    }

    @Override
    public Future<DescribePermissionsResult> describePermissionsAsync(final DescribePermissionsRequest describePermissionsRequest, final AsyncHandler<DescribePermissionsRequest, DescribePermissionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePermissionsResult>(){

            @Override
            public DescribePermissionsResult call() throws Exception {
                DescribePermissionsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describePermissions(describePermissionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describePermissionsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteInstanceAsync(final DeleteInstanceRequest deleteInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deleteInstance(deleteInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteInstanceAsync(final DeleteInstanceRequest deleteInstanceRequest, final AsyncHandler<DeleteInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deleteInstance(deleteInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CloneStackResult> cloneStackAsync(final CloneStackRequest cloneStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CloneStackResult>(){

            @Override
            public CloneStackResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.cloneStack(cloneStackRequest);
            }
        });
    }

    @Override
    public Future<CloneStackResult> cloneStackAsync(final CloneStackRequest cloneStackRequest, final AsyncHandler<CloneStackRequest, CloneStackResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CloneStackResult>(){

            @Override
            public CloneStackResult call() throws Exception {
                CloneStackResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.cloneStack(cloneStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)cloneStackRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> detachElasticLoadBalancerAsync(final DetachElasticLoadBalancerRequest detachElasticLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.detachElasticLoadBalancer(detachElasticLoadBalancerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachElasticLoadBalancerAsync(final DetachElasticLoadBalancerRequest detachElasticLoadBalancerRequest, final AsyncHandler<DetachElasticLoadBalancerRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.detachElasticLoadBalancer(detachElasticLoadBalancerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)detachElasticLoadBalancerRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopInstanceAsync(final StopInstanceRequest stopInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.stopInstance(stopInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopInstanceAsync(final StopInstanceRequest stopInstanceRequest, final AsyncHandler<StopInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.stopInstance(stopInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)stopInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAppAsync(final UpdateAppRequest updateAppRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateApp(updateAppRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAppAsync(final UpdateAppRequest updateAppRequest, final AsyncHandler<UpdateAppRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateApp(updateAppRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateAppRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeRdsDbInstancesResult> describeRdsDbInstancesAsync(final DescribeRdsDbInstancesRequest describeRdsDbInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRdsDbInstancesResult>(){

            @Override
            public DescribeRdsDbInstancesResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeRdsDbInstances(describeRdsDbInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeRdsDbInstancesResult> describeRdsDbInstancesAsync(final DescribeRdsDbInstancesRequest describeRdsDbInstancesRequest, final AsyncHandler<DescribeRdsDbInstancesRequest, DescribeRdsDbInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRdsDbInstancesResult>(){

            @Override
            public DescribeRdsDbInstancesResult call() throws Exception {
                DescribeRdsDbInstancesResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeRdsDbInstances(describeRdsDbInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeRdsDbInstancesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCommandsResult> describeCommandsAsync(final DescribeCommandsRequest describeCommandsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCommandsResult>(){

            @Override
            public DescribeCommandsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeCommands(describeCommandsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCommandsResult> describeCommandsAsync(final DescribeCommandsRequest describeCommandsRequest, final AsyncHandler<DescribeCommandsRequest, DescribeCommandsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCommandsResult>(){

            @Override
            public DescribeCommandsResult call() throws Exception {
                DescribeCommandsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeCommands(describeCommandsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeCommandsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> associateElasticIpAsync(final AssociateElasticIpRequest associateElasticIpRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.associateElasticIp(associateElasticIpRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> associateElasticIpAsync(final AssociateElasticIpRequest associateElasticIpRequest, final AsyncHandler<AssociateElasticIpRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.associateElasticIp(associateElasticIpRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)associateElasticIpRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unassignVolumeAsync(final UnassignVolumeRequest unassignVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.unassignVolume(unassignVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> unassignVolumeAsync(final UnassignVolumeRequest unassignVolumeRequest, final AsyncHandler<UnassignVolumeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.unassignVolume(unassignVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)unassignVolumeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeRaidArraysResult> describeRaidArraysAsync(final DescribeRaidArraysRequest describeRaidArraysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRaidArraysResult>(){

            @Override
            public DescribeRaidArraysResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeRaidArrays(describeRaidArraysRequest);
            }
        });
    }

    @Override
    public Future<DescribeRaidArraysResult> describeRaidArraysAsync(final DescribeRaidArraysRequest describeRaidArraysRequest, final AsyncHandler<DescribeRaidArraysRequest, DescribeRaidArraysResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRaidArraysResult>(){

            @Override
            public DescribeRaidArraysResult call() throws Exception {
                DescribeRaidArraysResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeRaidArrays(describeRaidArraysRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeRaidArraysRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHostnameSuggestionResult> getHostnameSuggestionAsync(final GetHostnameSuggestionRequest getHostnameSuggestionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostnameSuggestionResult>(){

            @Override
            public GetHostnameSuggestionResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.getHostnameSuggestion(getHostnameSuggestionRequest);
            }
        });
    }

    @Override
    public Future<GetHostnameSuggestionResult> getHostnameSuggestionAsync(final GetHostnameSuggestionRequest getHostnameSuggestionRequest, final AsyncHandler<GetHostnameSuggestionRequest, GetHostnameSuggestionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostnameSuggestionResult>(){

            @Override
            public GetHostnameSuggestionResult call() throws Exception {
                GetHostnameSuggestionResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.getHostnameSuggestion(getHostnameSuggestionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHostnameSuggestionRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setLoadBasedAutoScalingAsync(final SetLoadBasedAutoScalingRequest setLoadBasedAutoScalingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.setLoadBasedAutoScaling(setLoadBasedAutoScalingRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setLoadBasedAutoScalingAsync(final SetLoadBasedAutoScalingRequest setLoadBasedAutoScalingRequest, final AsyncHandler<SetLoadBasedAutoScalingRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.setLoadBasedAutoScaling(setLoadBasedAutoScalingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setLoadBasedAutoScalingRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest describeVolumesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeVolumes(describeVolumesRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest describeVolumesRequest, final AsyncHandler<DescribeVolumesRequest, DescribeVolumesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                DescribeVolumesResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeVolumes(describeVolumesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeVolumesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> assignVolumeAsync(final AssignVolumeRequest assignVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.assignVolume(assignVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> assignVolumeAsync(final AssignVolumeRequest assignVolumeRequest, final AsyncHandler<AssignVolumeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.assignVolume(assignVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)assignVolumeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeServiceErrorsResult> describeServiceErrorsAsync(final DescribeServiceErrorsRequest describeServiceErrorsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServiceErrorsResult>(){

            @Override
            public DescribeServiceErrorsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeServiceErrors(describeServiceErrorsRequest);
            }
        });
    }

    @Override
    public Future<DescribeServiceErrorsResult> describeServiceErrorsAsync(final DescribeServiceErrorsRequest describeServiceErrorsRequest, final AsyncHandler<DescribeServiceErrorsRequest, DescribeServiceErrorsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServiceErrorsResult>(){

            @Override
            public DescribeServiceErrorsResult call() throws Exception {
                DescribeServiceErrorsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeServiceErrors(describeServiceErrorsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeServiceErrorsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateLayerAsync(final UpdateLayerRequest updateLayerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateLayer(updateLayerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateLayerAsync(final UpdateLayerRequest updateLayerRequest, final AsyncHandler<UpdateLayerRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateLayer(updateLayerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateLayerRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateElasticIpAsync(final UpdateElasticIpRequest updateElasticIpRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateElasticIp(updateElasticIpRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateElasticIpAsync(final UpdateElasticIpRequest updateElasticIpRequest, final AsyncHandler<UpdateElasticIpRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateElasticIp(updateElasticIpRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateElasticIpRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startInstanceAsync(final StartInstanceRequest startInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.startInstance(startInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startInstanceAsync(final StartInstanceRequest startInstanceRequest, final AsyncHandler<StartInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.startInstance(startInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateLayerResult> createLayerAsync(final CreateLayerRequest createLayerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateLayerResult>(){

            @Override
            public CreateLayerResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createLayer(createLayerRequest);
            }
        });
    }

    @Override
    public Future<CreateLayerResult> createLayerAsync(final CreateLayerRequest createLayerRequest, final AsyncHandler<CreateLayerRequest, CreateLayerResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateLayerResult>(){

            @Override
            public CreateLayerResult call() throws Exception {
                CreateLayerResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createLayer(createLayerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createLayerRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> disassociateElasticIpAsync(final DisassociateElasticIpRequest disassociateElasticIpRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.disassociateElasticIp(disassociateElasticIpRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disassociateElasticIpAsync(final DisassociateElasticIpRequest disassociateElasticIpRequest, final AsyncHandler<DisassociateElasticIpRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.disassociateElasticIp(disassociateElasticIpRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disassociateElasticIpRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest deleteStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deleteStack(deleteStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest deleteStackRequest, final AsyncHandler<DeleteStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deleteStack(deleteStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startStackAsync(final StartStackRequest startStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.startStack(startStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startStackAsync(final StartStackRequest startStackRequest, final AsyncHandler<StartStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.startStack(startStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<RegisterVolumeResult> registerVolumeAsync(final RegisterVolumeRequest registerVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterVolumeResult>(){

            @Override
            public RegisterVolumeResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.registerVolume(registerVolumeRequest);
            }
        });
    }

    @Override
    public Future<RegisterVolumeResult> registerVolumeAsync(final RegisterVolumeRequest registerVolumeRequest, final AsyncHandler<RegisterVolumeRequest, RegisterVolumeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterVolumeResult>(){

            @Override
            public RegisterVolumeResult call() throws Exception {
                RegisterVolumeResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.registerVolume(registerVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerVolumeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateRdsDbInstanceAsync(final UpdateRdsDbInstanceRequest updateRdsDbInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateRdsDbInstance(updateRdsDbInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateRdsDbInstanceAsync(final UpdateRdsDbInstanceRequest updateRdsDbInstanceRequest, final AsyncHandler<UpdateRdsDbInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateRdsDbInstance(updateRdsDbInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateRdsDbInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateUserProfileAsync(final UpdateUserProfileRequest updateUserProfileRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateUserProfile(updateUserProfileRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateUserProfileAsync(final UpdateUserProfileRequest updateUserProfileRequest, final AsyncHandler<UpdateUserProfileRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateUserProfile(updateUserProfileRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateUserProfileRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> rebootInstanceAsync(final RebootInstanceRequest rebootInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.rebootInstance(rebootInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> rebootInstanceAsync(final RebootInstanceRequest rebootInstanceRequest, final AsyncHandler<RebootInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.rebootInstance(rebootInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rebootInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest createStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createStack(createStackRequest);
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest createStackRequest, final AsyncHandler<CreateStackRequest, CreateStackResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                CreateStackResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createStack(createStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createStackRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateInstanceResult> createInstanceAsync(final CreateInstanceRequest createInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInstanceResult>(){

            @Override
            public CreateInstanceResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createInstance(createInstanceRequest);
            }
        });
    }

    @Override
    public Future<CreateInstanceResult> createInstanceAsync(final CreateInstanceRequest createInstanceRequest, final AsyncHandler<CreateInstanceRequest, CreateInstanceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInstanceResult>(){

            @Override
            public CreateInstanceResult call() throws Exception {
                CreateInstanceResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createInstance(createInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createInstanceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteAppAsync(final DeleteAppRequest deleteAppRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deleteApp(deleteAppRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAppAsync(final DeleteAppRequest deleteAppRequest, final AsyncHandler<DeleteAppRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deleteApp(deleteAppRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteAppRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterElasticIpAsync(final DeregisterElasticIpRequest deregisterElasticIpRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deregisterElasticIp(deregisterElasticIpRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterElasticIpAsync(final DeregisterElasticIpRequest deregisterElasticIpRequest, final AsyncHandler<DeregisterElasticIpRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deregisterElasticIp(deregisterElasticIpRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deregisterElasticIpRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> attachElasticLoadBalancerAsync(final AttachElasticLoadBalancerRequest attachElasticLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.attachElasticLoadBalancer(attachElasticLoadBalancerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> attachElasticLoadBalancerAsync(final AttachElasticLoadBalancerRequest attachElasticLoadBalancerRequest, final AsyncHandler<AttachElasticLoadBalancerRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.attachElasticLoadBalancer(attachElasticLoadBalancerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)attachElasticLoadBalancerRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateStackAsync(final UpdateStackRequest updateStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateStack(updateStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateStackAsync(final UpdateStackRequest updateStackRequest, final AsyncHandler<UpdateStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateStack(updateStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateUserProfileResult> createUserProfileAsync(final CreateUserProfileRequest createUserProfileRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateUserProfileResult>(){

            @Override
            public CreateUserProfileResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createUserProfile(createUserProfileRequest);
            }
        });
    }

    @Override
    public Future<CreateUserProfileResult> createUserProfileAsync(final CreateUserProfileRequest createUserProfileRequest, final AsyncHandler<CreateUserProfileRequest, CreateUserProfileResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateUserProfileResult>(){

            @Override
            public CreateUserProfileResult call() throws Exception {
                CreateUserProfileResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createUserProfile(createUserProfileRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createUserProfileRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLayersResult> describeLayersAsync(final DescribeLayersRequest describeLayersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLayersResult>(){

            @Override
            public DescribeLayersResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeLayers(describeLayersRequest);
            }
        });
    }

    @Override
    public Future<DescribeLayersResult> describeLayersAsync(final DescribeLayersRequest describeLayersRequest, final AsyncHandler<DescribeLayersRequest, DescribeLayersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLayersResult>(){

            @Override
            public DescribeLayersResult call() throws Exception {
                DescribeLayersResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeLayers(describeLayersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeLayersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBasedAutoScalingResult> describeLoadBasedAutoScalingAsync(final DescribeLoadBasedAutoScalingRequest describeLoadBasedAutoScalingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLoadBasedAutoScalingResult>(){

            @Override
            public DescribeLoadBasedAutoScalingResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeLoadBasedAutoScaling(describeLoadBasedAutoScalingRequest);
            }
        });
    }

    @Override
    public Future<DescribeLoadBasedAutoScalingResult> describeLoadBasedAutoScalingAsync(final DescribeLoadBasedAutoScalingRequest describeLoadBasedAutoScalingRequest, final AsyncHandler<DescribeLoadBasedAutoScalingRequest, DescribeLoadBasedAutoScalingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLoadBasedAutoScalingResult>(){

            @Override
            public DescribeLoadBasedAutoScalingResult call() throws Exception {
                DescribeLoadBasedAutoScalingResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeLoadBasedAutoScaling(describeLoadBasedAutoScalingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeLoadBasedAutoScalingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeElasticLoadBalancersResult> describeElasticLoadBalancersAsync(final DescribeElasticLoadBalancersRequest describeElasticLoadBalancersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeElasticLoadBalancersResult>(){

            @Override
            public DescribeElasticLoadBalancersResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeElasticLoadBalancers(describeElasticLoadBalancersRequest);
            }
        });
    }

    @Override
    public Future<DescribeElasticLoadBalancersResult> describeElasticLoadBalancersAsync(final DescribeElasticLoadBalancersRequest describeElasticLoadBalancersRequest, final AsyncHandler<DescribeElasticLoadBalancersRequest, DescribeElasticLoadBalancersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeElasticLoadBalancersResult>(){

            @Override
            public DescribeElasticLoadBalancersResult call() throws Exception {
                DescribeElasticLoadBalancersResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeElasticLoadBalancers(describeElasticLoadBalancersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeElasticLoadBalancersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteLayerAsync(final DeleteLayerRequest deleteLayerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deleteLayer(deleteLayerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLayerAsync(final DeleteLayerRequest deleteLayerRequest, final AsyncHandler<DeleteLayerRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deleteLayer(deleteLayerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteLayerRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMyUserProfileResult> describeMyUserProfileAsync(final DescribeMyUserProfileRequest describeMyUserProfileRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMyUserProfileResult>(){

            @Override
            public DescribeMyUserProfileResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeMyUserProfile(describeMyUserProfileRequest);
            }
        });
    }

    @Override
    public Future<DescribeMyUserProfileResult> describeMyUserProfileAsync(final DescribeMyUserProfileRequest describeMyUserProfileRequest, final AsyncHandler<DescribeMyUserProfileRequest, DescribeMyUserProfileResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMyUserProfileResult>(){

            @Override
            public DescribeMyUserProfileResult call() throws Exception {
                DescribeMyUserProfileResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeMyUserProfile(describeMyUserProfileRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeMyUserProfileRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setTimeBasedAutoScalingAsync(final SetTimeBasedAutoScalingRequest setTimeBasedAutoScalingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.setTimeBasedAutoScaling(setTimeBasedAutoScalingRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setTimeBasedAutoScalingAsync(final SetTimeBasedAutoScalingRequest setTimeBasedAutoScalingRequest, final AsyncHandler<SetTimeBasedAutoScalingRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.setTimeBasedAutoScaling(setTimeBasedAutoScalingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setTimeBasedAutoScalingRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateAppResult> createAppAsync(final CreateAppRequest createAppRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAppResult>(){

            @Override
            public CreateAppResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createApp(createAppRequest);
            }
        });
    }

    @Override
    public Future<CreateAppResult> createAppAsync(final CreateAppRequest createAppRequest, final AsyncHandler<CreateAppRequest, CreateAppResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAppResult>(){

            @Override
            public CreateAppResult call() throws Exception {
                CreateAppResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createApp(createAppRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createAppRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateVolumeAsync(final UpdateVolumeRequest updateVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateVolume(updateVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateVolumeAsync(final UpdateVolumeRequest updateVolumeRequest, final AsyncHandler<UpdateVolumeRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateVolume(updateVolumeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateVolumeRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteUserProfileAsync(final DeleteUserProfileRequest deleteUserProfileRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.deleteUserProfile(deleteUserProfileRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteUserProfileAsync(final DeleteUserProfileRequest deleteUserProfileRequest, final AsyncHandler<DeleteUserProfileRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.deleteUserProfile(deleteUserProfileRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteUserProfileRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTimeBasedAutoScalingResult> describeTimeBasedAutoScalingAsync(final DescribeTimeBasedAutoScalingRequest describeTimeBasedAutoScalingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTimeBasedAutoScalingResult>(){

            @Override
            public DescribeTimeBasedAutoScalingResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeTimeBasedAutoScaling(describeTimeBasedAutoScalingRequest);
            }
        });
    }

    @Override
    public Future<DescribeTimeBasedAutoScalingResult> describeTimeBasedAutoScalingAsync(final DescribeTimeBasedAutoScalingRequest describeTimeBasedAutoScalingRequest, final AsyncHandler<DescribeTimeBasedAutoScalingRequest, DescribeTimeBasedAutoScalingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTimeBasedAutoScalingResult>(){

            @Override
            public DescribeTimeBasedAutoScalingResult call() throws Exception {
                DescribeTimeBasedAutoScalingResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeTimeBasedAutoScaling(describeTimeBasedAutoScalingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTimeBasedAutoScalingRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserProfilesResult> describeUserProfilesAsync(final DescribeUserProfilesRequest describeUserProfilesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeUserProfilesResult>(){

            @Override
            public DescribeUserProfilesResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeUserProfiles(describeUserProfilesRequest);
            }
        });
    }

    @Override
    public Future<DescribeUserProfilesResult> describeUserProfilesAsync(final DescribeUserProfilesRequest describeUserProfilesRequest, final AsyncHandler<DescribeUserProfilesRequest, DescribeUserProfilesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeUserProfilesResult>(){

            @Override
            public DescribeUserProfilesResult call() throws Exception {
                DescribeUserProfilesResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeUserProfiles(describeUserProfilesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeUserProfilesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateInstanceAsync(final UpdateInstanceRequest updateInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.updateInstance(updateInstanceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateInstanceAsync(final UpdateInstanceRequest updateInstanceRequest, final AsyncHandler<UpdateInstanceRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.updateInstance(updateInstanceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateInstanceRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeDeploymentsResult> describeDeploymentsAsync(final DescribeDeploymentsRequest describeDeploymentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeploymentsResult>(){

            @Override
            public DescribeDeploymentsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeDeployments(describeDeploymentsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDeploymentsResult> describeDeploymentsAsync(final DescribeDeploymentsRequest describeDeploymentsRequest, final AsyncHandler<DescribeDeploymentsRequest, DescribeDeploymentsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeploymentsResult>(){

            @Override
            public DescribeDeploymentsResult call() throws Exception {
                DescribeDeploymentsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeDeployments(describeDeploymentsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDeploymentsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RegisterElasticIpResult> registerElasticIpAsync(final RegisterElasticIpRequest registerElasticIpRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterElasticIpResult>(){

            @Override
            public RegisterElasticIpResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.registerElasticIp(registerElasticIpRequest);
            }
        });
    }

    @Override
    public Future<RegisterElasticIpResult> registerElasticIpAsync(final RegisterElasticIpRequest registerElasticIpRequest, final AsyncHandler<RegisterElasticIpRequest, RegisterElasticIpResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterElasticIpResult>(){

            @Override
            public RegisterElasticIpResult call() throws Exception {
                RegisterElasticIpResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.registerElasticIp(registerElasticIpRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerElasticIpRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeElasticIpsResult> describeElasticIpsAsync(final DescribeElasticIpsRequest describeElasticIpsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeElasticIpsResult>(){

            @Override
            public DescribeElasticIpsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeElasticIps(describeElasticIpsRequest);
            }
        });
    }

    @Override
    public Future<DescribeElasticIpsResult> describeElasticIpsAsync(final DescribeElasticIpsRequest describeElasticIpsRequest, final AsyncHandler<DescribeElasticIpsRequest, DescribeElasticIpsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeElasticIpsResult>(){

            @Override
            public DescribeElasticIpsResult call() throws Exception {
                DescribeElasticIpsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeElasticIps(describeElasticIpsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeElasticIpsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest describeStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeStacks(describeStacksRequest);
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest describeStacksRequest, final AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                DescribeStacksResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeStacks(describeStacksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStacksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAppsResult> describeAppsAsync(final DescribeAppsRequest describeAppsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAppsResult>(){

            @Override
            public DescribeAppsResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeApps(describeAppsRequest);
            }
        });
    }

    @Override
    public Future<DescribeAppsResult> describeAppsAsync(final DescribeAppsRequest describeAppsRequest, final AsyncHandler<DescribeAppsRequest, DescribeAppsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAppsResult>(){

            @Override
            public DescribeAppsResult call() throws Exception {
                DescribeAppsResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeApps(describeAppsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeAppsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackSummaryResult> describeStackSummaryAsync(final DescribeStackSummaryRequest describeStackSummaryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackSummaryResult>(){

            @Override
            public DescribeStackSummaryResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.describeStackSummary(describeStackSummaryRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackSummaryResult> describeStackSummaryAsync(final DescribeStackSummaryRequest describeStackSummaryRequest, final AsyncHandler<DescribeStackSummaryRequest, DescribeStackSummaryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackSummaryResult>(){

            @Override
            public DescribeStackSummaryResult call() throws Exception {
                DescribeStackSummaryResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.describeStackSummary(describeStackSummaryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStackSummaryRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> stopStackAsync(final StopStackRequest stopStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSOpsWorksAsyncClient.this.stopStack(stopStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopStackAsync(final StopStackRequest stopStackRequest, final AsyncHandler<StopStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSOpsWorksAsyncClient.this.stopStack(stopStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)stopStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(final CreateDeploymentRequest createDeploymentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDeploymentResult>(){

            @Override
            public CreateDeploymentResult call() throws Exception {
                return AWSOpsWorksAsyncClient.this.createDeployment(createDeploymentRequest);
            }
        });
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(final CreateDeploymentRequest createDeploymentRequest, final AsyncHandler<CreateDeploymentRequest, CreateDeploymentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDeploymentResult>(){

            @Override
            public CreateDeploymentResult call() throws Exception {
                CreateDeploymentResult result;
                try {
                    result = AWSOpsWorksAsyncClient.this.createDeployment(createDeploymentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDeploymentRequest, (Object)result);
                return result;
            }
        });
    }
}

