/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMSerializableImpl;
import org.apache.axiom.om.impl.llom.OMStAXWrapper;
import org.apache.axiom.om.util.OMXMLStreamReaderValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OMContainerHelper {
    private static final Log log = LogFactory.getLog(OMContainerHelper.class);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();

    private OMContainerHelper() {
    }

    public static XMLStreamReader getXMLStreamReader(OMContainer container, boolean cache) {
        OMXMLParserWrapper builder = ((OMSerializableImpl)container).builder;
        if (builder != null && builder instanceof StAXOMBuilder && !container.isComplete() && ((StAXOMBuilder)builder).isLookahead()) {
            container.buildNext();
        }
        OMStAXWrapper reader = null;
        boolean done = ((OMSerializableImpl)container).done;
        if (builder == null && done) {
            reader = new OMStAXWrapper(null, container, false);
        } else {
            if (builder == null && !cache) {
                throw new UnsupportedOperationException("This element was not created in a manner to be switched");
            }
            if (builder != null && builder.isCompleted() && !cache && !done) {
                throw new UnsupportedOperationException("The parser is already consumed!");
            }
            reader = new OMStAXWrapper(builder, container, cache);
        }
        if (DEBUG_ENABLED) {
            reader = new OMXMLStreamReaderValidator((OMXMLStreamReader)reader, false);
        }
        return reader;
    }
}

