/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.util;

import java.util.List;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentType;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;

public class ExperimentModelUtil {
    public static ExperimentModel createSimpleExperiment(String gatewayId, String projectID, String userName, String experimentName, String expDescription, String applicationId, List<InputDataObjectType> experimentInputList) {
        ExperimentModel experiment = new ExperimentModel();
        experiment.setGatewayId(gatewayId);
        experiment.setProjectId(projectID);
        experiment.setExperimentType(ExperimentType.SINGLE_APPLICATION);
        experiment.setUserName(userName);
        experiment.setExperimentName(experimentName);
        experiment.setDescription(expDescription);
        experiment.setExecutionId(applicationId);
        experiment.setExperimentInputs(experimentInputList);
        return experiment;
    }

    public static ComputationalResourceSchedulingModel createComputationResourceScheduling(String resourceHostId, int cpuCount, int nodeCount, int numberOfThreads, String queueName, int wallTimeLimit, int totalPhysicalMemory) {
        ComputationalResourceSchedulingModel cmRS = new ComputationalResourceSchedulingModel();
        cmRS.setResourceHostId(resourceHostId);
        cmRS.setTotalCPUCount(cpuCount);
        cmRS.setNodeCount(nodeCount);
        cmRS.setNumberOfThreads(numberOfThreads);
        cmRS.setQueueName(queueName);
        cmRS.setWallTimeLimit(wallTimeLimit);
        cmRS.setTotalPhysicalMemory(totalPhysicalMemory);
        return cmRS;
    }

    public static ProcessModel cloneProcessFromExperiment(ExperimentModel experiment) {
        UserConfigurationDataModel configData;
        List experimentOutputs;
        List experimentInputs;
        ProcessModel processModel = new ProcessModel();
        processModel.setCreationTime(experiment.getCreationTime());
        processModel.setExperimentId(experiment.getExperimentId());
        processModel.setApplicationInterfaceId(experiment.getExecutionId());
        processModel.setEnableEmailNotification(experiment.isEnableEmailNotification());
        List emailAddresses = experiment.getEmailAddresses();
        if (emailAddresses != null && !emailAddresses.isEmpty()) {
            processModel.setEmailAddresses(emailAddresses);
        }
        if ((experimentInputs = experiment.getExperimentInputs()) != null) {
            processModel.setProcessInputs(experimentInputs);
        }
        if ((experimentOutputs = experiment.getExperimentOutputs()) != null) {
            processModel.setProcessOutputs(experimentOutputs);
        }
        if ((configData = experiment.getUserConfigurationData()) != null) {
            processModel.setStorageResourceId(configData.getStorageId());
            processModel.setExperimentDataDir(configData.getExperimentDataDir());
            processModel.setGenerateCert(configData.isGenerateCert());
            processModel.setUserDn(configData.getUserDN());
            ComputationalResourceSchedulingModel scheduling = configData.getComputationalResourceScheduling();
            if (scheduling != null) {
                processModel.setProcessResourceSchedule(scheduling);
                processModel.setComputeResourceId(scheduling.getResourceHostId());
            }
            processModel.setUseUserCRPref(configData.isUseUserCRPref());
        }
        processModel.setUserName(experiment.getUserName());
        return processModel;
    }
}

