/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.ClearBackupOperation;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.util.Map;

public class ClearOperation
extends QueueBackupAwareOperation
implements Notifier {
    private transient Map<Long, Data> dataMap;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void run() {
        this.dataMap = this.getOrCreateContainer().clear();
        this.response = true;
    }

    @Override
    public void afterRun() throws Exception {
        this.getQueueService().getLocalQueueStatsImpl(this.name).incrementOtherOperations();
        for (Data data : this.dataMap.values()) {
            this.publishEvent(ItemEventType.REMOVED, data);
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.name, this.dataMap.keySet());
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(!this.dataMap.isEmpty());
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(!this.dataMap.isEmpty());
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getOrCreateContainer().getOfferWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 8;
    }
}

