/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.List;

public class IndexOfOperation
extends CollectionKeyBasedOperation {
    Data value;
    boolean last;

    public IndexOfOperation() {
    }

    public IndexOfOperation(CollectionProxyId proxyId, Data dataKey, Data value, boolean last) {
        super(proxyId, dataKey);
        this.value = value;
        this.last = last;
    }

    @Override
    public void run() throws Exception {
        CollectionWrapper wrapper = this.getCollectionWrapper();
        if (wrapper != null) {
            List list = (List)wrapper.getCollection();
            CollectionRecord record = new CollectionRecord(this.isBinary() ? this.value : this.toObject(this.value));
            this.response = this.last ? list.lastIndexOf(record) : list.indexOf(record);
        } else {
            this.response = -1;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.last);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.last = in.readBoolean();
        this.value = IOUtil.readData(in);
    }

    @Override
    public int getId() {
        return 13;
    }
}

