/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.rsync;

import eu.unicore.uftp.rsync.Checksum;
import eu.unicore.uftp.rsync.ChecksumHolder;
import eu.unicore.uftp.rsync.MasterChannel;
import eu.unicore.uftp.rsync.RollingChecksum;
import eu.unicore.uftp.rsync.RsyncStats;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class Master
implements Callable<RsyncStats> {
    private final RandomAccessFile file;
    private final MasterChannel channel;
    private final RsyncStats stats;
    private int blockSize;
    private List<Long> weakChecksums;
    private List<byte[]> strongChecksums;

    public Master(File file, MasterChannel channel, String fileName) throws IOException {
        this(new RandomAccessFile(file, "r"), channel, fileName);
    }

    public Master(RandomAccessFile file, MasterChannel channel, String fileName) {
        this.file = file;
        this.channel = channel;
        this.stats = new RsyncStats(fileName);
    }

    @Override
    public RsyncStats call() throws Exception {
        long start = System.currentTimeMillis();
        ChecksumHolder checksums = this.channel.receiveChecksums();
        this.stats.blocksize = this.blockSize = checksums.blocksize;
        this.weakChecksums = checksums.weakChecksums;
        this.strongChecksums = checksums.strongChecksums;
        this.findMatches();
        this.stats.duration = System.currentTimeMillis() - start;
        return this.stats;
    }

    protected void findMatches() throws IOException {
        RollingChecksum rollingChecksum = new RollingChecksum();
        long indexOfLastMatch = 0L;
        long total = this.file.length();
        long k = 0L;
        long l = this.blockSize - 1;
        this.stats.matches = 0;
        this.stats.weakMatches = 0;
        byte[] block = new byte[this.blockSize];
        int read = this.file.read(block);
        if (total < (long)this.blockSize || read < this.blockSize) {
            throw new IOException("File too short!");
        }
        long checkSum = rollingChecksum.init(block);
        while (l <= total) {
            boolean foundMatch = false;
            int index = this.weakCheck(checkSum);
            if (index >= 0) {
                ++this.stats.weakMatches;
                byte[] strong = Checksum.md5(block);
                if (Arrays.equals(strong, this.strongChecksums.get(index))) {
                    foundMatch = true;
                }
            }
            if (foundMatch) {
                ++this.stats.matches;
                long numBytes = k - indexOfLastMatch;
                this.file.seek(indexOfLastMatch);
                this.channel.sendData(numBytes, this.file.getChannel(), index);
                this.stats.transferred += numBytes;
                indexOfLastMatch = k += (long)this.blockSize;
                this.file.seek(k);
                if ((l += (long)this.blockSize) > total) continue;
                this.file.read(block);
                checkSum = rollingChecksum.reset(block, k, l);
                continue;
            }
            this.file.seek(++k);
            this.file.read(block);
            checkSum = rollingChecksum.update(k, ++l, block[0], block[this.blockSize - 1]);
        }
        if (indexOfLastMatch < total) {
            long numBytes = total - indexOfLastMatch;
            this.file.seek(indexOfLastMatch);
            this.channel.sendData(numBytes, this.file.getChannel(), -1);
            this.stats.transferred += numBytes;
        }
        this.channel.shutdown();
    }

    private int weakCheck(long checkSum) {
        int index = 0;
        for (Long c : this.weakChecksums) {
            if (checkSum == c) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

