/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.commons.utils;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import org.apache.airavata.service.profile.commons.utils.Committer;
import org.apache.airavata.service.profile.commons.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAUtils {
    private static final Logger logger = LoggerFactory.getLogger(JPAUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "profile_service";
    @PersistenceUnit(unitName="profile_service")
    private static EntityManagerFactory factory;

    private static EntityManager getEntityManager() {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + Utils.getJDBCDriver() + ",Url=" + Utils.getJDBCURL() + "?autoReconnect=true,Username=" + Utils.getJDBCUser() + ",Password=" + Utils.getJDBCPassword() + ",validationQuery=select 1";
            logger.info(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "warn");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        EntityManager entityManager = factory.createEntityManager();
        return entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R execute(Committer<EntityManager, R> committer) {
        EntityManager entityManager = JPAUtils.getEntityManager();
        try {
            entityManager.getTransaction().begin();
            R r = committer.commit(entityManager);
            entityManager.getTransaction().commit();
            R r2 = r;
            return r2;
        }
        finally {
            if (entityManager != null && entityManager.isOpen()) {
                if (entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().rollback();
                }
                entityManager.close();
            }
        }
    }
}

