/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class SimpleRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log log = LogFactory.getLog(SimpleRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        RealmConfiguration realmConfig;
        try {
            realmConfig = bootStrapConfig.cloneRealmConfigurationWithoutSecondary();
            realmConfig.setAdminUserName(persistedConfig.getAdminUserName());
            realmConfig.setAdminPassword(persistedConfig.getAdminPassword());
            realmConfig.setAdminRoleName(persistedConfig.getAdminRoleName());
            realmConfig.setEveryOneRoleName(persistedConfig.getEveryOneRoleName());
            realmConfig.setSecondaryRealmConfig(persistedConfig.getSecondaryRealmConfig());
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configurationwhen creating tenant's realm.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return realmConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration realmConfig = bootStrapConfig.cloneRealmConfigurationWithoutSecondary();
            this.removePropertiesFromTenantRealmConfig(realmConfig);
            realmConfig.setAdminUserName(UserCoreUtil.removeDomainFromName(tenantInfo.getAdminName()));
            realmConfig.setAdminPassword(UserCoreUtil.getDummyPassword());
            realmConfig.setTenantId(tenantId);
            realmConfig.setEveryOneRoleName(UserCoreUtil.removeDomainFromName(realmConfig.getEveryOneRoleName()));
            return realmConfig;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void removePropertiesFromTenantRealmConfig(RealmConfiguration tenantRealmConfiguration) {
        tenantRealmConfiguration.getRealmProperties().clear();
        String tenantManagerKey = "TenantManager";
        String tenantManagerValue = tenantRealmConfiguration.getUserStoreProperty(tenantManagerKey);
        tenantRealmConfiguration.getUserStoreProperties().put(tenantManagerKey, tenantManagerValue);
        tenantRealmConfiguration.getAuthzProperties().clear();
    }
}

