/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class RealmConfigXMLProcessor {
    private static final Log log = LogFactory.getLog(RealmConfigXMLProcessor.class);
    public static final String REALM_CONFIG_FILE = "user-mgt.xml";
    private SecretResolver secretResolver;
    private static BundleContext bundleContext;
    InputStream inStream = null;

    public static void setBundleContext(BundleContext bundleContext) {
        RealmConfigXMLProcessor.bundleContext = bundleContext;
    }

    public RealmConfiguration buildRealmConfigurationFromFile() throws UserStoreException {
        try {
            OMElement realmElement = this.getRealmElement();
            RealmConfiguration realmConfig = this.buildRealmConfiguration(realmElement);
            if (this.inStream != null) {
                this.inStream.close();
            }
            return realmConfig;
        }
        catch (Exception e) {
            String message = "Error while reading realm configuration from file";
            log.error((Object)message, (Throwable)e);
            throw new UserStoreException(message, e);
        }
    }

    public RealmConfiguration buildRealmConfiguration(InputStream inStream) throws UserStoreException {
        try {
            inStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)inStream);
            StAXOMBuilder builder = new StAXOMBuilder(inStream);
            OMElement documentElement = builder.getDocumentElement();
            OMElement realmElement = documentElement.getFirstChildWithName(new QName("Realm"));
            RealmConfiguration realmConfig = this.buildRealmConfiguration(realmElement);
            if (inStream != null) {
                inStream.close();
            }
            return realmConfig;
        }
        catch (RuntimeException e) {
            String message = "An unexpected error occurred while building the realm configuration.";
            log.error((Object)message, (Throwable)e);
            throw new UserStoreException(message, e);
        }
        catch (Exception e) {
            String message = "Error while reading realm configuration from file";
            log.error((Object)message, (Throwable)e);
            throw new UserStoreException(message, e);
        }
    }

    public RealmConfiguration buildRealmConfiguration(OMElement realmElem) throws UserStoreException {
        RealmConfiguration realmConfig = null;
        String userStoreClass = null;
        String authorizationManagerClass = null;
        String addAdmin = null;
        String adminRoleName = null;
        String adminUserName = null;
        String adminPassword = null;
        String everyOneRoleName = null;
        String realmClass = null;
        String description = null;
        Map<String, String> userStoreProperties = null;
        Map<String, String> authzProperties = null;
        Map<String, String> realmProperties = null;
        boolean passwordsExternallyManaged = false;
        realmClass = realmElem.getAttributeValue(new QName("class"));
        OMElement mainConfig = realmElem.getFirstChildWithName(new QName("Configuration"));
        realmProperties = this.getChildPropertyElements(mainConfig, this.secretResolver);
        String dbUrl = this.constructDatabaseURL(realmProperties.get("url"));
        realmProperties.put("url", dbUrl);
        if (mainConfig.getFirstChildWithName(new QName("AddAdmin")) == null || mainConfig.getFirstChildWithName(new QName("AddAdmin")).getText().trim().equals("")) {
            log.error((Object)"AddAdmin configuration not found or invalid in user-mgt.xml. Cannot start server!");
            throw new UserStoreException("AddAdmin configuration not found or invalid user-mgt.xml. Cannot start server!");
        }
        addAdmin = mainConfig.getFirstChildWithName(new QName("AddAdmin")).getText().trim();
        OMElement reservedRolesElm = mainConfig.getFirstChildWithName(new QName("ReservedRoleNames"));
        String[] reservedRoles = new String[]{};
        if (reservedRolesElm != null && !reservedRolesElm.getText().trim().equals("")) {
            String rolesStr = reservedRolesElm.getText().trim();
            reservedRoles = rolesStr.contains(",") ? rolesStr.split(",") : rolesStr.split(";");
        }
        OMElement restrictedDomainsElm = mainConfig.getFirstChildWithName(new QName("RestrictedDomainsForSelfSignUp"));
        String[] restrictedDomains = new String[]{};
        if (restrictedDomainsElm != null && !restrictedDomainsElm.getText().trim().equals("")) {
            String domain = restrictedDomainsElm.getText().trim();
            restrictedDomains = domain.contains(",") ? domain.split(",") : domain.split(";");
        }
        OMElement adminUser = mainConfig.getFirstChildWithName(new QName("AdminUser"));
        adminUserName = adminUser.getFirstChildWithName(new QName("UserName")).getText().trim();
        adminPassword = adminUser.getFirstChildWithName(new QName("Password")).getText().trim();
        if (this.secretResolver != null && this.secretResolver.isInitialized() && this.secretResolver.isTokenProtected("UserManager.AdminUser.Password")) {
            adminPassword = this.secretResolver.resolve("UserManager.AdminUser.Password");
        }
        adminRoleName = mainConfig.getFirstChildWithName(new QName("AdminRole")).getText().trim();
        everyOneRoleName = mainConfig.getFirstChildWithName(new QName("EveryOneRoleName")).getText().trim();
        OMElement authzConfig = realmElem.getFirstChildWithName(new QName("AuthorizationManager"));
        authorizationManagerClass = authzConfig.getAttributeValue(new QName("class")).trim();
        authzProperties = this.getChildPropertyElements(authzConfig, null);
        Iterator iterator = realmElem.getChildrenWithName(new QName("UserStoreManager"));
        RealmConfiguration primaryConfig = null;
        RealmConfiguration tmpConfig = null;
        while (iterator.hasNext()) {
            String domain;
            OMElement usaConfig = (OMElement)iterator.next();
            userStoreClass = usaConfig.getAttributeValue(new QName("class"));
            if (usaConfig.getFirstChildWithName(new QName("Description")) != null) {
                description = usaConfig.getFirstChildWithName(new QName("Description")).getText().trim();
            }
            userStoreProperties = this.getChildPropertyElements(usaConfig, this.secretResolver);
            String sIsPasswordExternallyManaged = userStoreProperties.get("PasswordsExternallyManaged");
            Map<String, String> multipleCredentialsProperties = this.getMultipleCredentialsProperties(usaConfig);
            if (null != sIsPasswordExternallyManaged && !sIsPasswordExternallyManaged.trim().equals("")) {
                passwordsExternallyManaged = Boolean.parseBoolean(sIsPasswordExternallyManaged);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"External password management is disabled.");
            }
            realmConfig = new RealmConfiguration();
            realmConfig.setRealmClassName(realmClass);
            realmConfig.setUserStoreClass(userStoreClass);
            realmConfig.setDescription(description);
            realmConfig.setAuthorizationManagerClass(authorizationManagerClass);
            if (primaryConfig == null) {
                int i;
                realmConfig.setPrimary(true);
                realmConfig.setAddAdmin(addAdmin);
                realmConfig.setAdminPassword(adminPassword);
                domain = userStoreProperties.get("DomainName");
                if (domain == null) {
                    userStoreProperties.put("DomainName", "PRIMARY");
                }
                for (i = 0; i < reservedRoles.length; ++i) {
                    realmConfig.addReservedRoleName(reservedRoles[i].trim().toUpperCase());
                }
                for (i = 0; i < restrictedDomains.length; ++i) {
                    realmConfig.addRestrictedDomainForSelfSignUp(restrictedDomains[i].trim().toUpperCase());
                }
                if (userStoreProperties.get("TenantManager") == null) {
                    log.error((Object)"Required property 'TenantManager' not found for the primary UserStoreManager in user_mgt.xml. Cannot start server!");
                    throw new UserStoreException("Required property 'TenantManager' not found for the primary UserStoreManager in user_mgt.xml. Cannot start server!");
                }
            }
            if ((domain = userStoreProperties.get("DomainName")) == null) {
                log.warn((Object)"Required property DomainName missing in secondary user store. Skip adding the user store.");
                continue;
            }
            userStoreProperties.put("StaticUserStore", "true");
            realmConfig.setEveryOneRoleName("Internal/" + everyOneRoleName);
            realmConfig.setAdminRoleName(adminRoleName);
            realmConfig.setAdminUserName(adminUserName);
            realmConfig.setUserStoreProperties(userStoreProperties);
            realmConfig.setAuthzProperties(authzProperties);
            realmConfig.setRealmProperties(realmProperties);
            realmConfig.setPasswordsExternallyManaged(passwordsExternallyManaged);
            realmConfig.addMultipleCredentialProperties(userStoreClass, multipleCredentialsProperties);
            if (realmConfig.getUserStoreProperty("MaxUserNameListLength") == null) {
                realmConfig.getUserStoreProperties().put("MaxUserNameListLength", "100");
            }
            if (realmConfig.getUserStoreProperty("ReadOnly") == null) {
                realmConfig.getUserStoreProperties().put("ReadOnly", "false");
            }
            if (primaryConfig == null) {
                primaryConfig = realmConfig;
            } else {
                tmpConfig.setSecondaryRealmConfig(realmConfig);
            }
            tmpConfig = realmConfig;
        }
        if (primaryConfig != null && primaryConfig.isPrimary()) {
            String primaryDomainName = primaryConfig.getUserStoreProperty("DomainName");
            String readOnly = primaryConfig.getUserStoreProperty("ReadOnly");
            Boolean isReadOnly = false;
            if (readOnly != null) {
                isReadOnly = Boolean.parseBoolean(readOnly);
            }
            if (primaryDomainName != null && primaryDomainName.trim().length() > 0) {
                String adminRoleDomain;
                if (adminUserName.indexOf("/") > 0) {
                    String adminUserDomain = adminUserName.substring(0, adminUserName.indexOf("/"));
                    if (!primaryDomainName.equalsIgnoreCase(adminUserDomain)) {
                        throw new UserStoreException("Admin User domain does not match primary user store domain.");
                    }
                } else {
                    primaryConfig.setAdminUserName(UserCoreUtil.addDomainToName(adminUserName, primaryDomainName));
                }
                if (adminRoleName.indexOf("/") > 0 && (!primaryDomainName.equalsIgnoreCase(adminRoleDomain = adminRoleName.substring(0, adminRoleName.indexOf("/"))) || isReadOnly.booleanValue() && !primaryDomainName.equalsIgnoreCase("Internal"))) {
                    throw new UserStoreException("Admin Role domain does not match primary user store domain.");
                }
            }
            primaryConfig.setAdminRoleName(UserCoreUtil.addDomainToName(adminRoleName, primaryDomainName));
        }
        return primaryConfig;
    }

    private String constructDatabaseURL(String url) {
        if (url != null && url.contains("${carbon.home}")) {
            File carbonHomeDir = new File(CarbonUtils.getCarbonHome());
            String path = carbonHomeDir.getPath();
            path = path.replaceAll(Pattern.quote("\\"), "/");
            if (carbonHomeDir.exists() && carbonHomeDir.isDirectory()) {
                url = url.replaceAll(Pattern.quote("${carbon.home}"), path);
            } else {
                log.warn((Object)"carbon home invalid");
                String[] tempStrings1 = url.split(Pattern.quote("${carbon.home}"));
                String dbUrl = tempStrings1[1];
                String[] tempStrings2 = dbUrl.split("/");
                for (int i = 0; i < tempStrings2.length - 1; ++i) {
                    url = tempStrings1[0] + tempStrings2[i] + "/";
                }
                url = url + tempStrings2[tempStrings2.length - 1];
            }
        }
        return url;
    }

    private Map<String, String> getChildPropertyElements(OMElement omElement, SecretResolver secretResolver) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator ite = omElement.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            if (secretResolver != null && secretResolver.isInitialized()) {
                if (secretResolver.isTokenProtected("UserManager.Configuration.Property." + propName)) {
                    propValue = secretResolver.resolve("UserManager.Configuration.Property." + propName);
                }
                if (secretResolver.isTokenProtected("UserStoreManager.Property." + propName)) {
                    propValue = secretResolver.resolve("UserStoreManager.Property." + propName);
                }
            }
            map.put(propName.trim(), propValue.trim());
        }
        return map;
    }

    private Map<String, String> getMultipleCredentialsProperties(OMElement omElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        OMElement multipleCredentialsEl = omElement.getFirstChildWithName(new QName("MultipleCredentials"));
        if (multipleCredentialsEl != null) {
            Iterator ite = multipleCredentialsEl.getChildrenWithLocalName("Credential");
            while (ite.hasNext()) {
                Object OMObj = ite.next();
                if (!(OMObj instanceof OMElement)) continue;
                OMElement credsElem = (OMElement)OMObj;
                String credsType = credsElem.getAttributeValue(new QName("type"));
                String credsClassName = credsElem.getText();
                map.put(credsType.trim(), credsClassName.trim());
            }
        }
        return map;
    }

    public static OMElement serialize(RealmConfiguration realmConfig) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement rootElement = factory.createOMElement(new QName("UserManager"));
        OMElement realmElement = factory.createOMElement(new QName("Realm"));
        String realmName = realmConfig.getRealmClassName();
        OMAttribute propAttr = factory.createOMAttribute("name", null, realmName);
        realmElement.addAttribute(propAttr);
        rootElement.addChild((OMNode)realmElement);
        OMElement mainConfig = factory.createOMElement(new QName("Configuration"));
        realmElement.addChild((OMNode)mainConfig);
        OMElement addAdmin = factory.createOMElement(new QName("AddAdmin"));
        OMElement adminUser = factory.createOMElement(new QName("AdminUser"));
        OMElement adminUserNameElem = factory.createOMElement(new QName("UserName"));
        adminUserNameElem.setText(realmConfig.getAdminUserName());
        OMElement adminPasswordElem = factory.createOMElement(new QName("Password"));
        addAdmin.setText(UserCoreUtil.removeDomainFromName(realmConfig.getAddAdmin()));
        adminPasswordElem.setText(realmConfig.getAdminPassword());
        adminUser.addChild((OMNode)adminUserNameElem);
        adminUser.addChild((OMNode)adminPasswordElem);
        mainConfig.addChild((OMNode)addAdmin);
        mainConfig.addChild((OMNode)adminUser);
        OMElement adminRoleNameElem = factory.createOMElement(new QName("AdminRole"));
        adminRoleNameElem.setText(UserCoreUtil.removeDomainFromName(realmConfig.getAdminRoleName()));
        mainConfig.addChild((OMNode)adminRoleNameElem);
        OMElement systemUserNameElem = factory.createOMElement(new QName("SystemUserName"));
        mainConfig.addChild((OMNode)systemUserNameElem);
        OMElement anonymousUserEle = factory.createOMElement(new QName("AnonymousUser"));
        OMElement anonymousUserNameElem = factory.createOMElement(new QName("UserName"));
        OMElement anonymousPasswordElem = factory.createOMElement(new QName("Password"));
        anonymousUserEle.addChild((OMNode)anonymousUserNameElem);
        anonymousUserEle.addChild((OMNode)anonymousPasswordElem);
        mainConfig.addChild((OMNode)anonymousUserEle);
        OMElement everyoneRoleNameElem = factory.createOMElement(new QName("EveryOneRoleName"));
        everyoneRoleNameElem.setText(UserCoreUtil.removeDomainFromName(realmConfig.getEveryOneRoleName()));
        mainConfig.addChild((OMNode)everyoneRoleNameElem);
        RealmConfigXMLProcessor.addPropertyElements(factory, mainConfig, null, realmConfig.getDescription(), realmConfig.getRealmProperties());
        OMElement userStoreManagerElement = factory.createOMElement(new QName("UserStoreManager"));
        realmElement.addChild((OMNode)userStoreManagerElement);
        RealmConfigXMLProcessor.addPropertyElements(factory, userStoreManagerElement, realmConfig.getUserStoreClass(), realmConfig.getDescription(), realmConfig.getUserStoreProperties());
        RealmConfiguration secondaryRealmConfiguration = null;
        for (secondaryRealmConfiguration = realmConfig.getSecondaryRealmConfig(); secondaryRealmConfiguration != null; secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) {
            OMElement secondaryElement = factory.createOMElement(new QName("UserStoreManager"));
            realmElement.addChild((OMNode)secondaryElement);
            RealmConfigXMLProcessor.addPropertyElements(factory, secondaryElement, secondaryRealmConfiguration.getUserStoreClass(), secondaryRealmConfiguration.getDescription(), secondaryRealmConfiguration.getUserStoreProperties());
        }
        OMElement authorizerManagerElement = factory.createOMElement(new QName("AuthorizationManager"));
        realmElement.addChild((OMNode)authorizerManagerElement);
        RealmConfigXMLProcessor.addPropertyElements(factory, authorizerManagerElement, realmConfig.getAuthorizationManagerClass(), realmConfig.getDescription(), realmConfig.getAuthzProperties());
        return rootElement;
    }

    private static void addPropertyElements(OMFactory factory, OMElement parent, String className, String description, Map<String, String> properties) {
        if (className != null) {
            parent.addAttribute("class", className, null);
        }
        if (description != null) {
            parent.addAttribute("Description", description, null);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            OMElement propElem = factory.createOMElement(new QName("Property"));
            OMAttribute propAttr = factory.createOMAttribute("name", null, name);
            propElem.addAttribute(propAttr);
            propElem.setText(value);
            parent.addChild((OMNode)propElem);
        }
    }

    private OMElement getRealmElement() throws XMLStreamException, IOException, UserStoreException {
        String carbonHome = CarbonUtils.getCarbonHome();
        StAXOMBuilder builder = null;
        if (carbonHome != null) {
            File profileConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), REALM_CONFIG_FILE);
            if (profileConfigXml.exists()) {
                this.inStream = new FileInputStream(profileConfigXml);
            }
        } else {
            this.inStream = RealmConfigXMLProcessor.class.getResourceAsStream(REALM_CONFIG_FILE);
        }
        String warningMessage = "";
        if (this.inStream == null) {
            URL url;
            if (bundleContext != null) {
                url = bundleContext.getBundle().getResource(REALM_CONFIG_FILE);
                if (url != null) {
                    this.inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource user-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = ClaimBuilder.class.getResource(REALM_CONFIG_FILE);
                if (url != null) {
                    this.inStream = url.openStream();
                    log.error((Object)"Using the internal realm configuration. Strictly for non-production purposes.");
                } else {
                    warningMessage = "ClaimBuilder could not find resource user-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            }
        }
        if (this.inStream == null) {
            String message = "Profile configuration not found. Cause - " + warningMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new FileNotFoundException(message);
        }
        try {
            this.inStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)this.inStream);
        }
        catch (CarbonException e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        builder = new StAXOMBuilder(this.inStream);
        OMElement documentElement = builder.getDocumentElement();
        this.setSecretResolver(documentElement);
        OMElement realmElement = documentElement.getFirstChildWithName(new QName("Realm"));
        return realmElement;
    }

    public void setSecretResolver(OMElement rootElement) {
        this.secretResolver = SecretResolverFactory.create((OMElement)rootElement, (boolean)true);
    }
}

