/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.Verdict;
import org.databene.stat.LatencyCounter;

public class ReportUtil {
    public static boolean success(LatencyCounter counter, PerformanceRequirement requirement) {
        boolean success = ReportUtil.averageVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.maxVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.throughputVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.totalTimeVerdict(counter, requirement) != Verdict.FAILURE;
        if (requirement != null) {
            PercentileRequirement[] percentileRequirements;
            for (PercentileRequirement percentileRequirement : percentileRequirements = requirement.getPercentileRequirements()) {
                success &= ReportUtil.percentileVerdict(counter, percentileRequirement) != Verdict.FAILURE;
            }
        }
        return success;
    }

    public static Verdict totalTimeVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getTotalTime() < 0) {
            return Verdict.IGNORED;
        }
        return counter.duration() <= (long)requirement.getTotalTime() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict maxVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getMax() < 0) {
            return Verdict.IGNORED;
        }
        return counter.maxLatency() <= (long)requirement.getMax() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict throughputVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getThroughput() < 0) {
            return Verdict.IGNORED;
        }
        return counter.throughput() >= (double)requirement.getThroughput() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict averageVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getAverage() < 0) {
            return Verdict.IGNORED;
        }
        return counter.averageLatency() <= (double)requirement.getAverage() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict percentileVerdict(LatencyCounter counter, PercentileRequirement requirement) {
        if (requirement == null || requirement.getMillis() < 0) {
            return Verdict.IGNORED;
        }
        return ReportUtil.percentileVerdict(counter, requirement.getPercentage(), Long.valueOf(requirement.getMillis()));
    }

    public static Verdict percentileVerdict(LatencyCounter counter, int percentage, Long requiredMillis) {
        if (requiredMillis == null || requiredMillis < 0L) {
            return Verdict.IGNORED;
        }
        return counter.percentileLatency(percentage) <= requiredMillis ? Verdict.SUCCESS : Verdict.FAILURE;
    }
}

