/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.aws;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;

public class AWSBasedMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(AWSBasedMembershipScheme.class);
    private final Map<String, Parameter> parameters;
    private final String primaryDomain;
    private final NetworkConfig nwConfig;
    private HazelcastInstance primaryHazelcastInstance;
    private final List<ClusteringMessage> messageBuffer;
    private HazelcastCarbonClusterImpl carbonCluster;

    public AWSBasedMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, Config config, HazelcastInstance primaryHazelcastInstance, List<ClusteringMessage> messageBuffer) {
        this.parameters = parameters;
        this.primaryDomain = primaryDomain;
        this.primaryHazelcastInstance = primaryHazelcastInstance;
        this.messageBuffer = messageBuffer;
        this.nwConfig = config.getNetworkConfig();
    }

    @Override
    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    @Override
    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    @Override
    public void setLocalMember(Member localMember) {
    }

    public void init() throws ClusteringFault {
        this.nwConfig.getJoin().getMulticastConfig().setEnabled(false);
        this.nwConfig.getJoin().getTcpIpConfig().setEnabled(false);
        AwsConfig awsConfig = this.nwConfig.getJoin().getAwsConfig();
        awsConfig.setEnabled(true);
        Parameter accessKey = this.getParameter("accessKey");
        Parameter secretKey = this.getParameter("secretKey");
        Parameter securityGroup = this.getParameter("securityGroup");
        Parameter connTimeout = this.getParameter("connTimeout");
        Parameter hostHeader = this.getParameter("hostHeader");
        Parameter region = this.getParameter("region");
        Parameter tagKey = this.getParameter("tagKey");
        Parameter tagValue = this.getParameter("tagValue");
        if (accessKey != null) {
            awsConfig.setAccessKey(((String)accessKey.getValue()).trim());
        }
        if (secretKey != null) {
            awsConfig.setSecretKey(((String)secretKey.getValue()).trim());
        }
        if (securityGroup != null) {
            awsConfig.setSecurityGroupName(((String)securityGroup.getValue()).trim());
        }
        if (connTimeout != null) {
            awsConfig.setConnectionTimeoutSeconds(Integer.parseInt(((String)connTimeout.getValue()).trim()));
        }
        if (hostHeader != null) {
            awsConfig.setHostHeader(((String)hostHeader.getValue()).trim());
        }
        if (region != null) {
            awsConfig.setRegion(((String)region.getValue()).trim());
        }
        if (tagKey != null) {
            awsConfig.setTagKey(((String)tagKey.getValue()).trim());
        }
        if (tagValue != null) {
            awsConfig.setTagValue(((String)tagValue.getValue()).trim());
        }
    }

    public void joinGroup() throws ClusteringFault {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new AWSMembershipListener());
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    private class AWSMembershipListener
    implements MembershipListener {
        private AWSMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            AWSBasedMembershipScheme.this.carbonCluster.memberAdded(member);
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HazelcastUtil.sendMessagesToMember(AWSBasedMembershipScheme.this.messageBuffer, member, AWSBasedMembershipScheme.this.carbonCluster);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            AWSBasedMembershipScheme.this.carbonCluster.memberRemoved(member);
            log.info((Object)("Member left [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
        }
    }
}

