/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.spi.TypeConverterRegistry;

public class CachingInjector<T> {
    private final TypeConverterRegistry repository;
    private final Class<T> type;
    private T instance;

    public CachingInjector(TypeConverterRegistry repository, Class<T> type) {
        this.repository = repository;
        this.type = type;
    }

    public synchronized T newInstance() {
        if (this.instance == null) {
            this.instance = this.createInstance(this.type);
        }
        return this.instance;
    }

    protected T createInstance(Class<T> t) {
        return this.repository.getInjector().newInstance(t);
    }
}

