\name{ShrinkImageFilter}
\alias{ShrinkImageFilter}
\title{ShrinkImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Reduce the size of an image by an integer factor in each dimension.
ShrinkImageFilter}
\details{
ShrinkImageFilter reduces the size of an image by an integer factor in each dimension.
The algorithm implemented is a simple subsample. The output image size
in each dimension is given by:
outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );
NOTE: The physical centers of the input and output will be the same.
Because of this, the Origin of the output may not be the same as the
Origin of the input. Since this filter produces an image which is a
different resolution, origin and with different pixel spacing than its
input image, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateInputRequestedRegion() and ProcessObject::GenerateOutputInformation() .
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
Shrink for the procedural interface
itk::ShrinkImageFilter for the Doxygen on the original ITK class.
ShrinkImageFilter}
%C++ includes: sitkShrinkImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetShrinkFactors() const:}{
Get the shrink factors.
}
\item{Self SetShrinkFactor(unsigned int s):}{
Custom public declarations
}
\item{Self SetShrinkFactors(std::vector< unsigned int > ShrinkFactors):}{
Set the shrink factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.
}
\item{ ShrinkImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ShrinkImageFilter():}{
Destructor
}
}
}
