/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.remote_info;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.remote_info.ClusterRemoteInfoVariant;
import org.opensearch.client.opensearch.cluster.remote_info.ClusterRemoteProxyInfo;
import org.opensearch.client.opensearch.cluster.remote_info.ClusterRemoteSniffInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class ClusterRemoteInfo
implements TaggedUnion<Kind, ClusterRemoteInfoVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final ClusterRemoteInfoVariant _value;
    public static final JsonpDeserializer<ClusterRemoteInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteInfo::setupClusterRemoteInfoDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final ClusterRemoteInfoVariant _get() {
        return this._value;
    }

    public ClusterRemoteInfo(ClusterRemoteInfoVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._clusterRemoteInfoKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private ClusterRemoteInfo(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ClusterRemoteInfo of(Function<Builder, ObjectBuilder<ClusterRemoteInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isProxy() {
        return this._kind == Kind.Proxy;
    }

    public ClusterRemoteProxyInfo proxy() {
        return (ClusterRemoteProxyInfo)TaggedUnionUtils.get(this, Kind.Proxy);
    }

    public boolean isSniff() {
        return this._kind == Kind.Sniff;
    }

    public ClusterRemoteSniffInfo sniff() {
        return (ClusterRemoteSniffInfo)TaggedUnionUtils.get(this, Kind.Sniff);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterRemoteInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::proxy, ClusterRemoteProxyInfo._DESERIALIZER, "proxy");
        op.add(Builder::sniff, ClusterRemoteSniffInfo._DESERIALIZER, "sniff");
        op.setTypeProperty("mode", null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRemoteInfo other = (ClusterRemoteInfo)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterRemoteInfo> {
        private Kind _kind;
        private ClusterRemoteInfoVariant _value;

        public Builder() {
        }

        private Builder(ClusterRemoteInfo o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<ClusterRemoteInfo> proxy(ClusterRemoteProxyInfo v) {
            this._kind = Kind.Proxy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ClusterRemoteInfo> proxy(Function<ClusterRemoteProxyInfo.Builder, ObjectBuilder<ClusterRemoteProxyInfo>> fn) {
            return this.proxy(fn.apply(new ClusterRemoteProxyInfo.Builder()).build());
        }

        public ObjectBuilder<ClusterRemoteInfo> sniff(ClusterRemoteSniffInfo v) {
            this._kind = Kind.Sniff;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ClusterRemoteInfo> sniff(Function<ClusterRemoteSniffInfo.Builder, ObjectBuilder<ClusterRemoteSniffInfo>> fn) {
            return this.sniff(fn.apply(new ClusterRemoteSniffInfo.Builder()).build());
        }

        @Override
        public ClusterRemoteInfo build() {
            this._checkSingleUse();
            return new ClusterRemoteInfo(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Proxy("proxy"),
        Sniff("sniff");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

