/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.io.IOException;
import java.util.List;
import java.util.function.IntConsumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.search.SearchContextId;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.SearchRequest;
import org.opensearch.protobufs.SuggestMode;
import org.opensearch.protobufs.TrackHits;
import org.opensearch.search.Scroll;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.suggest.SuggestBuilder;
import org.opensearch.search.suggest.SuggestBuilders;
import org.opensearch.search.suggest.SuggestionBuilder;
import org.opensearch.search.suggest.term.TermSuggestionBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.IndicesOptionsProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.ProtoActionsProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SearchSourceBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SearchTypeProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.StoredFieldsContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.AbstractQueryBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.suggest.TermSuggestionBuilderProtoUtils;

public class SearchRequestProtoUtils {
    private SearchRequestProtoUtils() {
    }

    public static org.opensearch.action.search.SearchRequest prepareRequest(SearchRequest request, Client client, AbstractQueryBuilderProtoUtils queryUtils) throws IOException {
        org.opensearch.action.search.SearchRequest searchRequest = new org.opensearch.action.search.SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        SearchRequestProtoUtils.parseSearchRequest(searchRequest, request, ((NodeClient)client).getNamedWriteableRegistry(), setSize, queryUtils);
        return searchRequest;
    }

    protected static void parseSearchRequest(org.opensearch.action.search.SearchRequest searchRequest, SearchRequest request, NamedWriteableRegistry namedWriteableRegistry, IntConsumer setSize, AbstractQueryBuilderProtoUtils queryUtils) throws IOException {
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        String[] indexArr = new String[request.getIndexCount()];
        for (int i = 0; i < request.getIndexCount(); ++i) {
            indexArr[i] = request.getIndex(i);
        }
        searchRequest.indices(indexArr);
        SearchSourceBuilderProtoUtils.parseProto(searchRequest.source(), request.getRequestBody(), queryUtils);
        int batchedReduceSize = request.hasBatchedReduceSize() ? request.getBatchedReduceSize() : searchRequest.getBatchedReduceSize();
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        if (request.hasPreFilterShardSize()) {
            searchRequest.setPreFilterShardSize(request.getPreFilterShardSize());
        }
        if (request.hasMaxConcurrentShardRequests()) {
            searchRequest.setMaxConcurrentShardRequests(request.getMaxConcurrentShardRequests());
        }
        if (request.hasAllowPartialSearchResults()) {
            searchRequest.allowPartialSearchResults(request.getAllowPartialSearchResults());
        }
        if (request.hasPhaseTook()) {
            searchRequest.setPhaseTook(Boolean.valueOf(request.getPhaseTook()));
        }
        if (request.hasSearchType()) {
            searchRequest.searchType(SearchTypeProtoUtils.fromProto(request));
        }
        SearchRequestProtoUtils.parseSearchSource(searchRequest.source(), request, setSize);
        if (request.hasRequestCache()) {
            searchRequest.requestCache(Boolean.valueOf(request.getRequestCache()));
        }
        if (request.hasScroll()) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)request.getScroll(), null, (String)"scroll")));
        }
        if (request.getRoutingCount() > 0) {
            searchRequest.routing((String[])request.getRoutingList().toArray((Object[])new String[0]));
        } else {
            searchRequest.routing((String)null);
        }
        searchRequest.preference(request.hasPreference() ? request.getPreference() : null);
        searchRequest.indicesOptions(IndicesOptionsProtoUtils.fromRequest(request, searchRequest.indicesOptions()));
        searchRequest.pipeline(request.hasSearchPipeline() ? request.getSearchPipeline() : searchRequest.source().pipeline());
        SearchRequestProtoUtils.checkProtoTotalHits(request, searchRequest);
        if (searchRequest.pointInTimeBuilder() != null) {
            SearchRequestProtoUtils.preparePointInTime(searchRequest, request, namedWriteableRegistry);
        } else {
            searchRequest.setCcsMinimizeRoundtrips(request.hasCcsMinimizeRoundtrips() ? request.getCcsMinimizeRoundtrips() : searchRequest.isCcsMinimizeRoundtrips());
        }
        searchRequest.setCancelAfterTimeInterval(request.hasCancelAfterTimeInterval() ? TimeValue.parseTimeValue((String)request.getCancelAfterTimeInterval(), null, (String)"cancel_after_time_interval") : null);
    }

    protected static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, SearchRequest request, IntConsumer setSize) {
        FetchSourceContext fetchSourceContext;
        StoredFieldsContext storedFieldsContext;
        QueryBuilder queryBuilder = ProtoActionsProtoUtils.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if (request.hasFrom()) {
            searchSourceBuilder.from(request.getFrom());
        }
        if (request.hasSize()) {
            setSize.accept(request.getSize());
        }
        if (request.hasExplain()) {
            searchSourceBuilder.explain(Boolean.valueOf(request.getExplain()));
        }
        if (request.hasVersion()) {
            searchSourceBuilder.version(Boolean.valueOf(request.getVersion()));
        }
        if (request.hasSeqNoPrimaryTerm()) {
            searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(request.getSeqNoPrimaryTerm()));
        }
        if (request.hasTimeout()) {
            searchSourceBuilder.timeout(TimeValue.parseTimeValue((String)request.getTimeout(), null, (String)"timeout"));
        }
        if (request.hasVerbosePipeline()) {
            searchSourceBuilder.verbosePipeline(Boolean.valueOf(request.getVerbosePipeline()));
        }
        if (request.hasTerminateAfter()) {
            int terminateAfter = request.getTerminateAfter();
            if (terminateAfter < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if ((storedFieldsContext = StoredFieldsContextProtoUtils.fromProtoRequest(request)) != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if (request.getDocvalueFieldsCount() > 0) {
            for (String field : request.getDocvalueFieldsList()) {
                searchSourceBuilder.docValueField(field, null);
            }
        }
        if ((fetchSourceContext = FetchSourceContextProtoUtils.parseFromProtoRequest(request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasTrackScores()) {
            searchSourceBuilder.trackScores(request.getTrackScores());
        }
        if (request.hasIncludeNamedQueriesScore()) {
            searchSourceBuilder.includeNamedQueriesScores(request.getIncludeNamedQueriesScore());
        }
        if (request.hasTrackTotalHits()) {
            if (request.getTrackTotalHits().getTrackHitsCase() == TrackHits.TrackHitsCase.ENABLED) {
                searchSourceBuilder.trackTotalHits(request.getTrackTotalHits().getEnabled());
            } else if (request.getTrackTotalHits().getTrackHitsCase() == TrackHits.TrackHitsCase.COUNT) {
                searchSourceBuilder.trackTotalHitsUpTo(request.getTrackTotalHits().getCount());
            }
        }
        if (request.getStatsCount() > 0) {
            searchSourceBuilder.stats((List)request.getStatsList());
        }
        if (request.hasSuggestField()) {
            String suggestField = request.getSuggestField();
            String suggestText = request.hasSuggestText() ? request.getSuggestText() : request.getQ();
            int suggestSize = request.hasSuggestSize() ? request.getSuggestSize() : 5;
            SuggestMode suggestMode = request.getSuggestMode();
            searchSourceBuilder.suggest(new SuggestBuilder().addSuggestion(suggestField, (SuggestionBuilder)((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion((String)suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilderProtoUtils.resolve(suggestMode))));
        }
    }

    private static void preparePointInTime(org.opensearch.action.search.SearchRequest request, SearchRequest protoRequest, NamedWriteableRegistry namedWriteableRegistry) {
        assert (request.pointInTimeBuilder() != null);
        ActionRequestValidationException validationException = null;
        if (request.indices().length > 0) {
            validationException = ValidateActions.addValidationError((String)"[indices] cannot be used with point in time", validationException);
        }
        if (request.indicesOptions() != org.opensearch.action.search.SearchRequest.DEFAULT_INDICES_OPTIONS) {
            validationException = ValidateActions.addValidationError((String)"[indicesOptions] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (request.routing() != null) {
            validationException = ValidateActions.addValidationError((String)"[routing] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (request.preference() != null) {
            validationException = ValidateActions.addValidationError((String)"[preference] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (protoRequest.hasCcsMinimizeRoundtrips() && protoRequest.getCcsMinimizeRoundtrips()) {
            validationException = ValidateActions.addValidationError((String)"[ccs_minimize_roundtrips] cannot be used with point in time", (ActionRequestValidationException)validationException);
            request.setCcsMinimizeRoundtrips(false);
        }
        ExceptionsHelper.reThrowIfNotNull((Throwable)validationException);
        IndicesOptions indicesOptions = request.indicesOptions();
        IndicesOptions stricterIndicesOptions = IndicesOptions.fromOptions((boolean)indicesOptions.ignoreUnavailable(), (boolean)indicesOptions.allowNoIndices(), (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)indicesOptions.ignoreThrottled());
        request.indicesOptions(stricterIndicesOptions);
        SearchContextId searchContextId = SearchContextId.decode((NamedWriteableRegistry)namedWriteableRegistry, (String)request.pointInTimeBuilder().getId());
        request.indices(searchContextId.getActualIndices());
    }

    protected static void checkProtoTotalHits(SearchRequest protoRequest, org.opensearch.action.search.SearchRequest searchRequest) {
        Integer trackTotalHitsUpTo;
        boolean totalHitsAsInt;
        boolean bl = totalHitsAsInt = protoRequest.hasRestTotalHitsAsInt() ? protoRequest.getRestTotalHitsAsInt() : false;
        if (!totalHitsAsInt) {
            return;
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) == null) {
            searchRequest.source().trackTotalHits(true);
        } else if (trackTotalHitsUpTo != Integer.MAX_VALUE && trackTotalHitsUpTo != -1) {
            throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + trackTotalHitsUpTo);
        }
    }
}

