# Matches {#matchable} {Mdm::Service} or {Mdm::Vuln} to a {#module_detail Metasploit Module} that can exploit it.
class MetasploitDataModels::AutomaticExploitation::Match < ApplicationRecord
  #
  # Associations
  #

  # A (polymorphic) "matchable" entity like a {Mdm::Vuln} or {Mdm::Service}
  #
  # @return [Mdm::Service, Mdm::Vuln]
  belongs_to :matchable, polymorphic: true

  # The {MatchSet} this match is part of
  has_many :match_results,
           class_name: 'MetasploitDataModels::AutomaticExploitation::MatchResult',
           inverse_of: :match

  # The {MatchSet} this match is part of
  belongs_to :match_set,
             class_name: 'MetasploitDataModels::AutomaticExploitation::MatchSet',
             optional: true,
             inverse_of: :matches

  # The Metasploit Module that this match connects to
  belongs_to :module_detail,
             class_name: 'Mdm::Module::Detail',
             foreign_key: :module_fullname,
             primary_key: :fullname

  # Scope a match to a MetasploitDataModels::AutomaticExploitation::Run
  scope :by_run_and_vuln,
        ->(run,vuln){
          joins(
            MetasploitDataModels::AutomaticExploitation::Match.join_association(:match_set),
            MetasploitDataModels::AutomaticExploitation::MatchSet.join_association(:runs)
          ).where(
            MetasploitDataModels::AutomaticExploitation::Run[:id].eq(run.id)
          ).where(
            MetasploitDataModels::AutomaticExploitation::Match[:matchable_id].eq(vuln.id),
            MetasploitDataModels::AutomaticExploitation::Match[:matchable_type].eq("Mdm::Vuln")
          )
        }

  Metasploit::Concern.run(self)
end
