/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene912;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.lucene912.ForUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.packed.PackedInts;

final class PForUtil {
    private static final int MAX_EXCEPTIONS = 7;
    private final ForUtil forUtil = new ForUtil();

    PForUtil() {
    }

    static boolean allEqual(long[] l) {
        for (int i = 1; i < 128; ++i) {
            if (l[i] == l[0]) continue;
            return false;
        }
        return true;
    }

    void encode(long[] longs, DataOutput out) throws IOException {
        LongHeap top = new LongHeap(8);
        for (int i = 0; i <= 7; ++i) {
            top.push(longs[i]);
        }
        long topValue = top.top();
        for (int i = 8; i < 128; ++i) {
            if (longs[i] <= topValue) continue;
            topValue = top.updateTop(longs[i]);
        }
        long max = 0L;
        for (int i = 1; i <= top.size(); ++i) {
            max = Math.max(max, top.get(i));
        }
        int maxBitsRequired = PackedInts.bitsRequired((long)max);
        int patchedBitsRequired = Math.max(PackedInts.bitsRequired((long)topValue), maxBitsRequired - 8);
        int numExceptions = 0;
        long maxUnpatchedValue = (1L << patchedBitsRequired) - 1L;
        for (int i = 2; i <= top.size(); ++i) {
            if (top.get(i) <= maxUnpatchedValue) continue;
            ++numExceptions;
        }
        byte[] exceptions = new byte[numExceptions * 2];
        if (numExceptions > 0) {
            int exceptionCount = 0;
            for (int i = 0; i < 128; ++i) {
                if (longs[i] <= maxUnpatchedValue) continue;
                exceptions[exceptionCount * 2] = (byte)i;
                exceptions[exceptionCount * 2 + 1] = (byte)(longs[i] >>> patchedBitsRequired);
                int n = i;
                longs[n] = longs[n] & maxUnpatchedValue;
                ++exceptionCount;
            }
            assert (exceptionCount == numExceptions) : exceptionCount + " " + numExceptions;
        }
        if (PForUtil.allEqual(longs) && maxBitsRequired <= 8) {
            for (int i = 0; i < numExceptions; ++i) {
                exceptions[2 * i + 1] = (byte)(Byte.toUnsignedLong(exceptions[2 * i + 1]) << patchedBitsRequired);
            }
            out.writeByte((byte)(numExceptions << 5));
            out.writeVLong(longs[0]);
        } else {
            int token = numExceptions << 5 | patchedBitsRequired;
            out.writeByte((byte)token);
            this.forUtil.encode(longs, patchedBitsRequired, out);
        }
        out.writeBytes(exceptions, exceptions.length);
    }

    void decode(IndexInput in, long[] longs) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        if (bitsPerValue == 0) {
            Arrays.fill(longs, 0, 128, in.readVLong());
        } else {
            this.forUtil.decode(bitsPerValue, in, longs);
        }
        int numExceptions = token >>> 5;
        for (int i = 0; i < numExceptions; ++i) {
            int n = Byte.toUnsignedInt(in.readByte());
            longs[n] = longs[n] | Byte.toUnsignedLong(in.readByte()) << bitsPerValue;
        }
    }

    static void skip(DataInput in) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (bitsPerValue == 0) {
            in.readVLong();
            in.skipBytes((long)(numExceptions << 1));
        } else {
            in.skipBytes((long)(ForUtil.numBytes(bitsPerValue) + (numExceptions << 1)));
        }
    }
}

