/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Power Law Adaptive Histogram Equalization.


Histogram equalization modifies the contrast in an image. The AdaptiveHistogramEqualizationImageFilter is a superset of many contrast enhancing filters. By modifying its
parameters (alpha, beta, and window), the AdaptiveHistogramEqualizationImageFilter can produce an adaptively equalized histogram or a version of unsharp
mask (local mean subtraction). Instead of applying a strict histogram
equalization in a window about a pixel, this filter prescribes a
mapping function (power law) controlled by the parameters alpha and
beta.

The parameter alpha controls how much the filter acts like the
classical histogram equalization method (alpha=0) to how much the
filter acts like an unsharp mask (alpha=1).

The parameter beta controls how much the filter acts like an unsharp
mask (beta=0) to much the filter acts like pass through (beta=1, with
alpha=1).

The parameter window controls the size of the region over which local
statistics are calculated. The size of the window is controlled by
SetRadius the default Radius is 5 in all directions.

By altering alpha, beta and window, a host of equalization and unsharp
masking filters is available.

The boundary condition ignores the part of the neighborhood outside
the image, and over-weights the valid part of the neighborhood.

For detail description, reference "Adaptive Image Contrast
Enhancement using Generalizations of Histogram Equalization." J.Alex
Stark. IEEE Transactions on Image Processing, May 2000.
See:
 itk::simple::AdaptiveHistogramEqualization for the procedural interface

 itk::AdaptiveHistogramEqualizationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAdaptiveHistogramEqualizationImageFilter.h
*/
public class AdaptiveHistogramEqualizationImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AdaptiveHistogramEqualizationImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AdaptiveHistogramEqualizationImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AdaptiveHistogramEqualizationImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AdaptiveHistogramEqualizationImageFilter::~AdaptiveHistogramEqualizationImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AdaptiveHistogramEqualizationImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AdaptiveHistogramEqualizationImageFilter::AdaptiveHistogramEqualizationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AdaptiveHistogramEqualizationImageFilter() {
    this(SimpleITKJNI.new_AdaptiveHistogramEqualizationImageFilter(), true);
  }

  /**
Self&amp; itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::AdaptiveHistogramEqualizationImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::AdaptiveHistogramEqualizationImageFilter::SetAlpha(float Alpha)

Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.

*/
public  void setAlpha(float Alpha) {
    SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
float itk::simple::AdaptiveHistogramEqualizationImageFilter::GetAlpha() const

Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.

*/
public  float getAlpha() {
    return SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AdaptiveHistogramEqualizationImageFilter::SetBeta(float Beta)

Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.

*/
public  void setBeta(float Beta) {
    SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_setBeta(swigCPtr, this, Beta);
  }

  /**
float itk::simple::AdaptiveHistogramEqualizationImageFilter::GetBeta() const

Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.

*/
public  float getBeta() {
    return SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_getBeta(swigCPtr, this);
  }

  /**
std::string itk::simple::AdaptiveHistogramEqualizationImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AdaptiveHistogramEqualizationImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AdaptiveHistogramEqualizationImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AdaptiveHistogramEqualizationImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
