﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkSpaces {
namespace Model {

/**
 */
class DeleteConnectClientAddInRequest : public WorkSpacesRequest {
 public:
  AWS_WORKSPACES_API DeleteConnectClientAddInRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteConnectClientAddIn"; }

  AWS_WORKSPACES_API Aws::String SerializePayload() const override;

  AWS_WORKSPACES_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the client add-in to delete.</p>
   */
  inline const Aws::String& GetAddInId() const { return m_addInId; }
  inline bool AddInIdHasBeenSet() const { return m_addInIdHasBeenSet; }
  template <typename AddInIdT = Aws::String>
  void SetAddInId(AddInIdT&& value) {
    m_addInIdHasBeenSet = true;
    m_addInId = std::forward<AddInIdT>(value);
  }
  template <typename AddInIdT = Aws::String>
  DeleteConnectClientAddInRequest& WithAddInId(AddInIdT&& value) {
    SetAddInId(std::forward<AddInIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The directory identifier for which the client add-in is configured.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  DeleteConnectClientAddInRequest& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_addInId;
  bool m_addInIdHasBeenSet = false;

  Aws::String m_resourceId;
  bool m_resourceIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
