/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapURL;
import org.ldaptive.Operation;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class CompareReferralHandler
extends AbstractReferralHandler<CompareRequest, Boolean> {
    public CompareReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public CompareReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public CompareReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public CompareReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private CompareReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected CompareRequest createReferralRequest(CompareRequest request, LdapURL url) {
        CompareRequest referralRequest = new CompareRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new CompareReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setDn(request.getDn());
        }
        referralRequest.setAttribute(request.getAttribute());
        return referralRequest;
    }

    @Override
    protected Operation<CompareRequest, Boolean> createReferralOperation(Connection conn) {
        return new CompareOperation(conn);
    }
}

