/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureETC1.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSWebGLCompressedTextureETC1Prototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureETC1Prototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureETC1Prototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureETC1Prototype>(vm)) JSWebGLCompressedTextureETC1Prototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETC1Prototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureETC1Prototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureETC1Prototype, JSWebGLCompressedTextureETC1Prototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureETC1PrototypeTableValues[] =
{
    { "COMPRESSED_RGB_ETC1_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D64 } },
};

const ClassInfo JSWebGLCompressedTextureETC1Prototype::s_info = { "WebGLCompressedTextureETC1"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC1Prototype) };

void JSWebGLCompressedTextureETC1Prototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureETC1::info(), JSWebGLCompressedTextureETC1PrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLCompressedTextureETC1::s_info = { "WebGLCompressedTextureETC1"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureETC1) };

JSWebGLCompressedTextureETC1::JSWebGLCompressedTextureETC1(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureETC1>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureETC1>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureETC1>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLCompressedTextureETC1::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLCompressedTextureETC1Prototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLCompressedTextureETC1Prototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLCompressedTextureETC1::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureETC1>(vm, globalObject);
}

void JSWebGLCompressedTextureETC1::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureETC1* thisObject = static_cast<JSWebGLCompressedTextureETC1*>(cell);
    thisObject->JSWebGLCompressedTextureETC1::~JSWebGLCompressedTextureETC1();
}

JSC::GCClient::IsoSubspace* JSWebGLCompressedTextureETC1::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLCompressedTextureETC1, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLCompressedTextureETC1.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLCompressedTextureETC1 = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLCompressedTextureETC1.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLCompressedTextureETC1 = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLCompressedTextureETC1::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureETC1*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureETC1Owner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLCompressedTextureETC1 = jsCast<JSWebGLCompressedTextureETC1*>(handle.slot()->asCell());
    auto& owner = jsWebGLCompressedTextureETC1->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLCompressedTextureETC1"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLCompressedTextureETC1Owner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureETC1 = static_cast<JSWebGLCompressedTextureETC1*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLCompressedTextureETC1->protectedWrapped().ptr(), jsWebGLCompressedTextureETC1);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureETC1@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLCompressedTextureETC1E[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLCompressedTextureETC1>, void>> static inline void verifyVTable(WebGLCompressedTextureETC1* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureETC1@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26WebGLCompressedTextureETC1E[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLCompressedTextureETC1 has subclasses. If WebGLCompressedTextureETC1 has subclasses that get passed
        // to toJS() we currently require WebGLCompressedTextureETC1 you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureETC1>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLCompressedTextureETC1>(impl.ptr());
#endif
    return createWrapper<WebGLCompressedTextureETC1>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureETC1& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureETC1* JSWebGLCompressedTextureETC1::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureETC1*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
