/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGUnitTypes.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGUnitTypesConstructor);

class JSSVGUnitTypesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGUnitTypesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGUnitTypesPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGUnitTypesPrototype>(vm)) JSSVGUnitTypesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGUnitTypesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGUnitTypesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGUnitTypesPrototype, JSSVGUnitTypesPrototype::Base);

using JSSVGUnitTypesDOMConstructor = JSDOMConstructorNotConstructable<JSSVGUnitTypes>;

/* Hash table for constructor */

static const HashTableValue JSSVGUnitTypesConstructorTableValues[] =
{
    { "SVG_UNIT_TYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_UNIT_TYPE_USERSPACEONUSE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

static_assert(SVGUnitTypes::SVG_UNIT_TYPE_UNKNOWN == 0, "SVG_UNIT_TYPE_UNKNOWN in SVGUnitTypes does not match value from IDL");
static_assert(SVGUnitTypes::SVG_UNIT_TYPE_USERSPACEONUSE == 1, "SVG_UNIT_TYPE_USERSPACEONUSE in SVGUnitTypes does not match value from IDL");
static_assert(SVGUnitTypes::SVG_UNIT_TYPE_OBJECTBOUNDINGBOX == 2, "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX in SVGUnitTypes does not match value from IDL");

template<> const ClassInfo JSSVGUnitTypesDOMConstructor::s_info = { "SVGUnitTypes"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGUnitTypesDOMConstructor) };

template<> JSValue JSSVGUnitTypesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGUnitTypesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGUnitTypes"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGUnitTypes::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGUnitTypes::info(), JSSVGUnitTypesConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGUnitTypesPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGUnitTypesConstructor, 0 } },
    { "SVG_UNIT_TYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "SVG_UNIT_TYPE_USERSPACEONUSE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "SVG_UNIT_TYPE_OBJECTBOUNDINGBOX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSSVGUnitTypesPrototype::s_info = { "SVGUnitTypes"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGUnitTypesPrototype) };

void JSSVGUnitTypesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGUnitTypes::info(), JSSVGUnitTypesPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGUnitTypes::s_info = { "SVGUnitTypes"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGUnitTypes) };

JSSVGUnitTypes::JSSVGUnitTypes(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGUnitTypes>&& impl)
    : JSDOMWrapper<SVGUnitTypes>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGUnitTypes>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGUnitTypes::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGUnitTypesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGUnitTypesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGUnitTypes::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGUnitTypes>(vm, globalObject);
}

JSValue JSSVGUnitTypes::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGUnitTypesDOMConstructor, DOMConstructorID::SVGUnitTypes>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGUnitTypes::destroy(JSC::JSCell* cell)
{
    JSSVGUnitTypes* thisObject = static_cast<JSSVGUnitTypes*>(cell);
    thisObject->JSSVGUnitTypes::~JSSVGUnitTypes();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGUnitTypesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGUnitTypesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGUnitTypes::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSSVGUnitTypes::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGUnitTypes, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGUnitTypes.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGUnitTypes = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGUnitTypes.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGUnitTypes = std::forward<decltype(space)>(space); }
    );
}

void JSSVGUnitTypes::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGUnitTypes*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGUnitTypesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGUnitTypesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGUnitTypes = static_cast<JSSVGUnitTypes*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGUnitTypes->protectedWrapped().ptr(), jsSVGUnitTypes);
}

SVGUnitTypes* JSSVGUnitTypes::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGUnitTypes*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
