/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPromiseRejectionEvent.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PromiseRejectionEvent::Init>> convertDictionary<PromiseRejectionEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PromiseRejectionEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue promiseValue;
    if (isNullOrUndefined)
        promiseValue = jsUndefined();
    else {
        promiseValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "promise"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (promiseValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "promise"_s, "PromiseRejectionEventInit"_s, "Promise"_s);
        return ConversionResultException { };
    }
    auto promiseConversionResult = convert<IDLPromise<IDLAny>>(lexicalGlobalObject, promiseValue);
    if (UNLIKELY(promiseConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.promise = promiseConversionResult.releaseReturnValue();
    JSValue reasonValue;
    if (isNullOrUndefined)
        reasonValue = jsUndefined();
    else {
        reasonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "reason"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto reasonConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, reasonValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (UNLIKELY(reasonConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.reason = reasonConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPromiseRejectionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPromiseRejectionEvent_promise);
static JSC_DECLARE_CUSTOM_GETTER(jsPromiseRejectionEvent_reason);

class JSPromiseRejectionEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPromiseRejectionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPromiseRejectionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPromiseRejectionEventPrototype>(vm)) JSPromiseRejectionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPromiseRejectionEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPromiseRejectionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPromiseRejectionEventPrototype, JSPromiseRejectionEventPrototype::Base);

using JSPromiseRejectionEventDOMConstructor = JSDOMConstructor<JSPromiseRejectionEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPromiseRejectionEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPromiseRejectionEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<PromiseRejectionEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = PromiseRejectionEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PromiseRejectionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PromiseRejectionEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPromiseRejectionEventDOMConstructorConstruct, JSPromiseRejectionEventDOMConstructor::construct);

template<> const ClassInfo JSPromiseRejectionEventDOMConstructor::s_info = { "PromiseRejectionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPromiseRejectionEventDOMConstructor) };

template<> JSValue JSPromiseRejectionEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSPromiseRejectionEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PromiseRejectionEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPromiseRejectionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPromiseRejectionEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPromiseRejectionEventConstructor, 0 } },
    { "promise"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsPromiseRejectionEvent_promise, 0 } },
    { "reason"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPromiseRejectionEvent_reason, 0 } },
};

const ClassInfo JSPromiseRejectionEventPrototype::s_info = { "PromiseRejectionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPromiseRejectionEventPrototype) };

void JSPromiseRejectionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPromiseRejectionEvent::info(), JSPromiseRejectionEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPromiseRejectionEvent::s_info = { "PromiseRejectionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPromiseRejectionEvent) };

JSPromiseRejectionEvent::JSPromiseRejectionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PromiseRejectionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<PromiseRejectionEvent> JSPromiseRejectionEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, PromiseRejectionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPromiseRejectionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPromiseRejectionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPromiseRejectionEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPromiseRejectionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPromiseRejectionEvent>(vm, globalObject);
}

JSValue JSPromiseRejectionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPromiseRejectionEventDOMConstructor, DOMConstructorID::PromiseRejectionEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPromiseRejectionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPromiseRejectionEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPromiseRejectionEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPromiseRejectionEvent_promiseGetter(JSGlobalObject& lexicalGlobalObject, JSPromiseRejectionEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLAny>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.promise(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsPromiseRejectionEvent_promise, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPromiseRejectionEvent>::get<jsPromiseRejectionEvent_promiseGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPromiseRejectionEvent_reasonGetter(JSGlobalObject& lexicalGlobalObject, JSPromiseRejectionEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.reason())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPromiseRejectionEvent_reason, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPromiseRejectionEvent>::get<jsPromiseRejectionEvent_reasonGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPromiseRejectionEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPromiseRejectionEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPromiseRejectionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPromiseRejectionEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPromiseRejectionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPromiseRejectionEvent = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSPromiseRejectionEvent::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPromiseRejectionEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSPromiseRejectionEvent);

template<typename Visitor>
void JSPromiseRejectionEvent::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPromiseRejectionEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSPromiseRejectionEvent::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSPromiseRejectionEvent::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSPromiseRejectionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPromiseRejectionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PromiseRejectionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21PromiseRejectionEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, PromiseRejectionEvent>, void>> static inline void verifyVTable(PromiseRejectionEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PromiseRejectionEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21PromiseRejectionEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PromiseRejectionEvent has subclasses. If PromiseRejectionEvent has subclasses that get passed
        // to toJS() we currently require PromiseRejectionEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PromiseRejectionEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PromiseRejectionEvent>(impl.ptr());
#endif
    return createWrapper<PromiseRejectionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PromiseRejectionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
