/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureHalfFloatLinear.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSOESTextureHalfFloatLinearPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureHalfFloatLinearPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureHalfFloatLinearPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureHalfFloatLinearPrototype>(vm)) JSOESTextureHalfFloatLinearPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureHalfFloatLinearPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureHalfFloatLinearPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureHalfFloatLinearPrototype, JSOESTextureHalfFloatLinearPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESTextureHalfFloatLinearPrototype::s_info = { "OESTextureHalfFloatLinear"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloatLinearPrototype) };

void JSOESTextureHalfFloatLinearPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESTextureHalfFloatLinear::s_info = { "OESTextureHalfFloatLinear"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloatLinear) };

JSOESTextureHalfFloatLinear::JSOESTextureHalfFloatLinear(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureHalfFloatLinear>&& impl)
    : JSDOMWrapper<OESTextureHalfFloatLinear>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESTextureHalfFloatLinear>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESTextureHalfFloatLinear::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESTextureHalfFloatLinearPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESTextureHalfFloatLinearPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESTextureHalfFloatLinear::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureHalfFloatLinear>(vm, globalObject);
}

void JSOESTextureHalfFloatLinear::destroy(JSC::JSCell* cell)
{
    JSOESTextureHalfFloatLinear* thisObject = static_cast<JSOESTextureHalfFloatLinear*>(cell);
    thisObject->JSOESTextureHalfFloatLinear::~JSOESTextureHalfFloatLinear();
}

JSC::GCClient::IsoSubspace* JSOESTextureHalfFloatLinear::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESTextureHalfFloatLinear, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESTextureHalfFloatLinear.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESTextureHalfFloatLinear = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESTextureHalfFloatLinear.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESTextureHalfFloatLinear = std::forward<decltype(space)>(space); }
    );
}

void JSOESTextureHalfFloatLinear::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureHalfFloatLinear*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureHalfFloatLinearOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESTextureHalfFloatLinear = jsCast<JSOESTextureHalfFloatLinear*>(handle.slot()->asCell());
    auto& owner = jsOESTextureHalfFloatLinear->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESTextureHalfFloatLinear"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESTextureHalfFloatLinearOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureHalfFloatLinear = static_cast<JSOESTextureHalfFloatLinear*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESTextureHalfFloatLinear->protectedWrapped().ptr(), jsOESTextureHalfFloatLinear);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureHalfFloatLinear@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25OESTextureHalfFloatLinearE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, OESTextureHalfFloatLinear>, void>> static inline void verifyVTable(OESTextureHalfFloatLinear* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESTextureHalfFloatLinear@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25OESTextureHalfFloatLinearE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESTextureHalfFloatLinear has subclasses. If OESTextureHalfFloatLinear has subclasses that get passed
        // to toJS() we currently require OESTextureHalfFloatLinear you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureHalfFloatLinear>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESTextureHalfFloatLinear>(impl.ptr());
#endif
    return createWrapper<OESTextureHalfFloatLinear>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureHalfFloatLinear& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureHalfFloatLinear* JSOESTextureHalfFloatLinear::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureHalfFloatLinear*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
