/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEvent.h"
#include "NavigateEvent.h"

namespace WebCore {

class JSNavigateEvent : public JSEvent {
public:
    using Base = JSEvent;
    using DOMWrapped = NavigateEvent;
    static JSNavigateEvent* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<NavigateEvent>&& impl)
    {
        auto& vm = globalObject->vm();
        JSNavigateEvent* ptr = new (NotNull, JSC::allocateCell<JSNavigateEvent>(vm)) JSNavigateEvent(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSEventType), StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;
    template<typename Visitor> void visitAdditionalChildren(Visitor&);

    template<typename Visitor> static void visitOutputConstraints(JSCell*, Visitor&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    NavigateEvent& wrapped() const
    {
        return static_cast<NavigateEvent&>(Base::wrapped());
    }

    Ref<NavigateEvent> protectedWrapped() const;

protected:
    JSNavigateEvent(JSC::Structure*, JSDOMGlobalObject&, Ref<NavigateEvent>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, NavigateEvent&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigateEvent* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<NavigateEvent>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<NavigateEvent>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<NavigateEvent> {
    using WrapperClass = JSNavigateEvent;
    using ToWrappedReturnType = NavigateEvent*;
};
String convertEnumerationToString(NavigateEvent::NavigationFocusReset);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, NavigateEvent::NavigationFocusReset);

template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumerationFromString<NavigateEvent::NavigationFocusReset>(const String&);
template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumeration<NavigateEvent::NavigationFocusReset>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<NavigateEvent::NavigationFocusReset>();

String convertEnumerationToString(NavigateEvent::NavigationScrollBehavior);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, NavigateEvent::NavigationScrollBehavior);

template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumerationFromString<NavigateEvent::NavigationScrollBehavior>(const String&);
template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumeration<NavigateEvent::NavigationScrollBehavior>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<NavigateEvent::NavigationScrollBehavior>();

template<> ConversionResult<IDLDictionary<NavigateEvent::Init>> convertDictionary<NavigateEvent::Init>(JSC::JSGlobalObject&, JSC::JSValue);

template<> ConversionResult<IDLDictionary<NavigateEvent::NavigationInterceptOptions>> convertDictionary<NavigateEvent::NavigationInterceptOptions>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore
