/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPipelineDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUAutoLayoutMode.h"
#include "JSGPUDepthStencilState.h"
#include "JSGPUFragmentState.h"
#include "JSGPUMultisampleState.h"
#include "JSGPUPipelineLayout.h"
#include "JSGPUPrimitiveState.h"
#include "JSGPUVertexState.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURenderPipelineDescriptor>> convertDictionary<GPURenderPipelineDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURenderPipelineDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (UNLIKELY(labelConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (layoutValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "layout"_s, "GPURenderPipelineDescriptor"_s, "(GPUPipelineLayout or GPUAutoLayoutMode)"_s);
        return ConversionResultException { };
    }
    auto layoutConversionResult = convert<IDLUnion<IDLInterface<GPUPipelineLayout>, IDLEnumeration<GPUAutoLayoutMode>>>(lexicalGlobalObject, layoutValue);
    if (UNLIKELY(layoutConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.layout = layoutConversionResult.releaseReturnValue();
    JSValue depthStencilValue;
    if (isNullOrUndefined)
        depthStencilValue = jsUndefined();
    else {
        depthStencilValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStencil"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthStencilValue.isUndefined()) {
        auto depthStencilConversionResult = convert<IDLDictionary<GPUDepthStencilState>>(lexicalGlobalObject, depthStencilValue);
        if (UNLIKELY(depthStencilConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.depthStencil = depthStencilConversionResult.releaseReturnValue();
    }
    JSValue fragmentValue;
    if (isNullOrUndefined)
        fragmentValue = jsUndefined();
    else {
        fragmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fragment"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fragmentValue.isUndefined()) {
        auto fragmentConversionResult = convert<IDLDictionary<GPUFragmentState>>(lexicalGlobalObject, fragmentValue);
        if (UNLIKELY(fragmentConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.fragment = fragmentConversionResult.releaseReturnValue();
    }
    JSValue multisampleValue;
    if (isNullOrUndefined)
        multisampleValue = jsUndefined();
    else {
        multisampleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "multisample"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!multisampleValue.isUndefined()) {
        auto multisampleConversionResult = convert<IDLDictionary<GPUMultisampleState>>(lexicalGlobalObject, multisampleValue);
        if (UNLIKELY(multisampleConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.multisample = multisampleConversionResult.releaseReturnValue();
    }
    JSValue primitiveValue;
    if (isNullOrUndefined)
        primitiveValue = jsUndefined();
    else {
        primitiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "primitive"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!primitiveValue.isUndefined()) {
        auto primitiveConversionResult = convert<IDLDictionary<GPUPrimitiveState>>(lexicalGlobalObject, primitiveValue);
        if (UNLIKELY(primitiveConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.primitive = primitiveConversionResult.releaseReturnValue();
    }
    JSValue vertexValue;
    if (isNullOrUndefined)
        vertexValue = jsUndefined();
    else {
        vertexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "vertex"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (vertexValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "vertex"_s, "GPURenderPipelineDescriptor"_s, "GPUVertexState"_s);
        return ConversionResultException { };
    }
    auto vertexConversionResult = convert<IDLDictionary<GPUVertexState>>(lexicalGlobalObject, vertexValue);
    if (UNLIKELY(vertexConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.vertex = vertexConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
