/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUOutOfMemoryError.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUOutOfMemoryErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUOutOfMemoryError_message);

class JSGPUOutOfMemoryErrorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUOutOfMemoryErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUOutOfMemoryErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUOutOfMemoryErrorPrototype>(vm)) JSGPUOutOfMemoryErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUOutOfMemoryErrorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUOutOfMemoryErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUOutOfMemoryErrorPrototype, JSGPUOutOfMemoryErrorPrototype::Base);

using JSGPUOutOfMemoryErrorDOMConstructor = JSDOMConstructor<JSGPUOutOfMemoryError>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSGPUOutOfMemoryErrorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSGPUOutOfMemoryErrorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto messageConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(messageConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = GPUOutOfMemoryError::create(messageConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<GPUOutOfMemoryError>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<GPUOutOfMemoryError>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSGPUOutOfMemoryErrorDOMConstructorConstruct, JSGPUOutOfMemoryErrorDOMConstructor::construct);

template<> const ClassInfo JSGPUOutOfMemoryErrorDOMConstructor::s_info = { "GPUOutOfMemoryError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryErrorDOMConstructor) };

template<> JSValue JSGPUOutOfMemoryErrorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUOutOfMemoryErrorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUOutOfMemoryError"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUOutOfMemoryError::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUOutOfMemoryErrorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUOutOfMemoryErrorConstructor, 0 } },
    { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUOutOfMemoryError_message, 0 } },
};

const ClassInfo JSGPUOutOfMemoryErrorPrototype::s_info = { "GPUOutOfMemoryError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryErrorPrototype) };

void JSGPUOutOfMemoryErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUOutOfMemoryError::info(), JSGPUOutOfMemoryErrorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUOutOfMemoryError::s_info = { "GPUOutOfMemoryError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryError) };

JSGPUOutOfMemoryError::JSGPUOutOfMemoryError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUOutOfMemoryError>&& impl)
    : JSDOMWrapper<GPUOutOfMemoryError>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUOutOfMemoryError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUOutOfMemoryError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUOutOfMemoryErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUOutOfMemoryErrorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUOutOfMemoryError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUOutOfMemoryError>(vm, globalObject);
}

JSValue JSGPUOutOfMemoryError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUOutOfMemoryErrorDOMConstructor, DOMConstructorID::GPUOutOfMemoryError>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUOutOfMemoryError::destroy(JSC::JSCell* cell)
{
    JSGPUOutOfMemoryError* thisObject = static_cast<JSGPUOutOfMemoryError*>(cell);
    thisObject->JSGPUOutOfMemoryError::~JSGPUOutOfMemoryError();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUOutOfMemoryErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUOutOfMemoryErrorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUOutOfMemoryError::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUOutOfMemoryError_messageGetter(JSGlobalObject& lexicalGlobalObject, JSGPUOutOfMemoryError& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUOutOfMemoryError_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUOutOfMemoryError>::get<jsGPUOutOfMemoryError_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUOutOfMemoryError::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUOutOfMemoryError, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUOutOfMemoryError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUOutOfMemoryError = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUOutOfMemoryError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUOutOfMemoryError = std::forward<decltype(space)>(space); }
    );
}

void JSGPUOutOfMemoryError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUOutOfMemoryError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUOutOfMemoryErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUOutOfMemoryErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUOutOfMemoryError = static_cast<JSGPUOutOfMemoryError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUOutOfMemoryError->protectedWrapped().ptr(), jsGPUOutOfMemoryError);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUOutOfMemoryError@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19GPUOutOfMemoryErrorE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUOutOfMemoryError>, void>> static inline void verifyVTable(GPUOutOfMemoryError* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUOutOfMemoryError@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19GPUOutOfMemoryErrorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUOutOfMemoryError has subclasses. If GPUOutOfMemoryError has subclasses that get passed
        // to toJS() we currently require GPUOutOfMemoryError you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUOutOfMemoryError>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUOutOfMemoryError>(impl.ptr());
#endif
    return createWrapper<GPUOutOfMemoryError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUOutOfMemoryError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUOutOfMemoryError* JSGPUOutOfMemoryError::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUOutOfMemoryError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
