/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUAddressMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUAddressMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("clamp-to-edge"),
        MAKE_STATIC_STRING_IMPL("repeat"),
        MAKE_STATIC_STRING_IMPL("mirror-repeat"),
    };
    static_assert(static_cast<size_t>(GPUAddressMode::ClampToEdge) == 0, "GPUAddressMode::ClampToEdge is not 0 as expected");
    static_assert(static_cast<size_t>(GPUAddressMode::Repeat) == 1, "GPUAddressMode::Repeat is not 1 as expected");
    static_assert(static_cast<size_t>(GPUAddressMode::MirrorRepeat) == 2, "GPUAddressMode::MirrorRepeat is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUAddressMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUAddressMode> parseEnumerationFromString<GPUAddressMode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUAddressMode> mappings[] = {
        { "clamp-to-edge", GPUAddressMode::ClampToEdge },
        { "mirror-repeat", GPUAddressMode::MirrorRepeat },
        { "repeat", GPUAddressMode::Repeat },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUAddressMode> parseEnumeration<GPUAddressMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUAddressMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUAddressMode>()
{
    return "\"clamp-to-edge\", \"repeat\", \"mirror-repeat\""_s;
}

} // namespace WebCore
