/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEffectTiming.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<EffectTiming>> convertDictionary<EffectTiming>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    EffectTiming result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto delayConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, delayValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(delayConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.delay = delayConversionResult.releaseReturnValue();
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto directionConversionResult = convertOptionalWithDefault<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue, [&]() -> ConversionResult<IDLEnumeration<PlaybackDirection>> { return Converter<IDLEnumeration<PlaybackDirection>>::ReturnType { PlaybackDirection::Normal }; });
    if (UNLIKELY(directionConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.direction = directionConversionResult.releaseReturnValue();
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto durationConversionResult = convertOptionalWithDefault<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, durationValue, [&]() -> ConversionResult<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>> { return Converter<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>::ReturnType { "auto"_s }; });
    if (UNLIKELY(durationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.duration = durationConversionResult.releaseReturnValue();
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto easingConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, easingValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "linear"_s }; });
    if (UNLIKELY(easingConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.easing = easingConversionResult.releaseReturnValue();
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto endDelayConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, endDelayValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(endDelayConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.endDelay = endDelayConversionResult.releaseReturnValue();
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto fillConversionResult = convertOptionalWithDefault<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue, [&]() -> ConversionResult<IDLEnumeration<FillMode>> { return Converter<IDLEnumeration<FillMode>>::ReturnType { FillMode::Auto }; });
    if (UNLIKELY(fillConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.fill = fillConversionResult.releaseReturnValue();
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto iterationStartConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, iterationStartValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (UNLIKELY(iterationStartConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.iterationStart = iterationStartConversionResult.releaseReturnValue();
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto iterationsConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1.0 }; });
    if (UNLIKELY(iterationsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.iterations = iterationsConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const EffectTiming& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto delayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.delay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "delay"_s), delayValue);
    auto directionValue = toJS<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, throwScope, dictionary.direction);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "direction"_s), directionValue);
    auto durationValue = toJS<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, dictionary.duration);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "duration"_s), durationValue);
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.easing);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"_s), easingValue);
    auto endDelayValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.endDelay);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "endDelay"_s), endDelayValue);
    auto fillValue = toJS<IDLEnumeration<FillMode>>(lexicalGlobalObject, throwScope, dictionary.fill);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "fill"_s), fillValue);
    auto iterationStartValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, dictionary.iterationStart);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterationStart"_s), iterationStartValue);
    auto iterationsValue = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, dictionary.iterations);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iterations"_s), iterationsValue);
    return result;
}

} // namespace WebCore
