/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMRGBColor.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_red);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_green);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_blue);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_alpha);

class JSDeprecatedCSSOMRGBColorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMRGBColorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMRGBColorPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMRGBColorPrototype>(vm)) JSDeprecatedCSSOMRGBColorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRGBColorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMRGBColorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRGBColorPrototype, JSDeprecatedCSSOMRGBColorPrototype::Base);

using JSDeprecatedCSSOMRGBColorDOMConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMRGBColor>;

template<> const ClassInfo JSDeprecatedCSSOMRGBColorDOMConstructor::s_info = { "RGBColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColorDOMConstructor) };

template<> JSValue JSDeprecatedCSSOMRGBColorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMRGBColorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "RGBColor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMRGBColor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMRGBColorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRGBColorConstructor, 0 } },
    { "red"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRGBColor_red, 0 } },
    { "green"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRGBColor_green, 0 } },
    { "blue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRGBColor_blue, 0 } },
    { "alpha"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMRGBColor_alpha, 0 } },
};

const ClassInfo JSDeprecatedCSSOMRGBColorPrototype::s_info = { "RGBColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColorPrototype) };

void JSDeprecatedCSSOMRGBColorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMRGBColor::info(), JSDeprecatedCSSOMRGBColorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDeprecatedCSSOMRGBColor::s_info = { "RGBColor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColor) };

JSDeprecatedCSSOMRGBColor::JSDeprecatedCSSOMRGBColor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMRGBColor>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMRGBColor>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMRGBColor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDeprecatedCSSOMRGBColor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDeprecatedCSSOMRGBColorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDeprecatedCSSOMRGBColorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDeprecatedCSSOMRGBColor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMRGBColor>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMRGBColor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMRGBColorDOMConstructor, DOMConstructorID::DeprecatedCSSOMRGBColor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMRGBColor::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMRGBColor* thisObject = static_cast<JSDeprecatedCSSOMRGBColor*>(cell);
    thisObject->JSDeprecatedCSSOMRGBColor::~JSDeprecatedCSSOMRGBColor();
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRGBColorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMRGBColor::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDeprecatedCSSOMRGBColor_redGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.red())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_red, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColor_redGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRGBColor_greenGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.green())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_green, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColor_greenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRGBColor_blueGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.blue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_blue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColor_blueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMRGBColor_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMRGBColor_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColor_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDeprecatedCSSOMRGBColor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDeprecatedCSSOMRGBColor, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDeprecatedCSSOMRGBColor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDeprecatedCSSOMRGBColor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDeprecatedCSSOMRGBColor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDeprecatedCSSOMRGBColor = std::forward<decltype(space)>(space); }
    );
}

void JSDeprecatedCSSOMRGBColor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMRGBColor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDeprecatedCSSOMRGBColorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDeprecatedCSSOMRGBColorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMRGBColor = static_cast<JSDeprecatedCSSOMRGBColor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDeprecatedCSSOMRGBColor->protectedWrapped().ptr(), jsDeprecatedCSSOMRGBColor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DeprecatedCSSOMRGBColor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23DeprecatedCSSOMRGBColorE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, DeprecatedCSSOMRGBColor>, void>> static inline void verifyVTable(DeprecatedCSSOMRGBColor* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DeprecatedCSSOMRGBColor@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23DeprecatedCSSOMRGBColorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DeprecatedCSSOMRGBColor has subclasses. If DeprecatedCSSOMRGBColor has subclasses that get passed
        // to toJS() we currently require DeprecatedCSSOMRGBColor you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DeprecatedCSSOMRGBColor>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DeprecatedCSSOMRGBColor>(impl.ptr());
#endif
    return createWrapper<DeprecatedCSSOMRGBColor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DeprecatedCSSOMRGBColor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DeprecatedCSSOMRGBColor* JSDeprecatedCSSOMRGBColor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMRGBColor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
