/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSKeywordValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSKeywordValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSKeywordValue_value);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSKeywordValue_value);

class JSCSSKeywordValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSKeywordValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSKeywordValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSKeywordValuePrototype>(vm)) JSCSSKeywordValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSKeywordValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSKeywordValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSKeywordValuePrototype, JSCSSKeywordValuePrototype::Base);

using JSCSSKeywordValueDOMConstructor = JSDOMConstructor<JSCSSKeywordValue>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSKeywordValueDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSKeywordValueDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSKeywordValue::create(valueConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSKeywordValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSKeywordValue>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSKeywordValueDOMConstructorConstruct, JSCSSKeywordValueDOMConstructor::construct);

template<> const ClassInfo JSCSSKeywordValueDOMConstructor::s_info = { "CSSKeywordValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSKeywordValueDOMConstructor) };

template<> JSValue JSCSSKeywordValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSKeywordValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSKeywordValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSKeywordValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSKeywordValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSKeywordValueConstructor, 0 } },
    { "value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSKeywordValue_value, setJSCSSKeywordValue_value } },
};

const ClassInfo JSCSSKeywordValuePrototype::s_info = { "CSSKeywordValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSKeywordValuePrototype) };

void JSCSSKeywordValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSKeywordValue::info(), JSCSSKeywordValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSKeywordValue::s_info = { "CSSKeywordValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSKeywordValue) };

JSCSSKeywordValue::JSCSSKeywordValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSKeywordValue>&& impl)
    : JSCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSKeywordValue> JSCSSKeywordValue::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSKeywordValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSKeywordValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSKeywordValuePrototype::createStructure(vm, &globalObject, JSCSSStyleValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSKeywordValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSKeywordValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSKeywordValue>(vm, globalObject);
}

JSValue JSCSSKeywordValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSKeywordValueDOMConstructor, DOMConstructorID::CSSKeywordValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSKeywordValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSKeywordValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSKeywordValue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSKeywordValue_valueGetter(JSGlobalObject& lexicalGlobalObject, JSCSSKeywordValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.value())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSKeywordValue_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSKeywordValue>::get<jsCSSKeywordValue_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSKeywordValue_valueSetter(JSGlobalObject& lexicalGlobalObject, JSCSSKeywordValue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValue(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSKeywordValue_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSKeywordValue>::set<setJSCSSKeywordValue_valueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSKeywordValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSKeywordValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSKeywordValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSKeywordValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSKeywordValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSKeywordValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSKeywordValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSKeywordValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSKeywordValue@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15CSSKeywordValueE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSKeywordValue>, void>> static inline void verifyVTable(CSSKeywordValue* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSKeywordValue@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15CSSKeywordValueE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSKeywordValue has subclasses. If CSSKeywordValue has subclasses that get passed
        // to toJS() we currently require CSSKeywordValue you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSKeywordValue>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSKeywordValue>(impl.ptr());
#endif
    return createWrapper<CSSKeywordValue>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSKeywordValue& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSKeywordValue* JSCSSKeywordValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSKeywordValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
