/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBlobPropertyBag.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSEndingType.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<BlobPropertyBag>> convertDictionary<BlobPropertyBag>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    BlobPropertyBag result;
    JSValue endingsValue;
    if (isNullOrUndefined)
        endingsValue = jsUndefined();
    else {
        endingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endings"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto endingsConversionResult = convertOptionalWithDefault<IDLEnumeration<EndingType>>(lexicalGlobalObject, endingsValue, [&]() -> ConversionResult<IDLEnumeration<EndingType>> { return Converter<IDLEnumeration<EndingType>>::ReturnType { EndingType::Transparent }; });
    if (UNLIKELY(endingsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.endings = endingsConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
