/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "HTMLElementFactory.h"

#include "HTMLNames.h"

#include "HTMLAnchorElement.h"
#include "HTMLElement.h"
#include "HTMLUnknownElement.h"
#include "HTMLAreaElement.h"
#include "HTMLArticleElement.h"
#include "HTMLBaseElement.h"
#include "HTMLBDIElement.h"
#include "HTMLQuoteElement.h"
#include "HTMLBodyElement.h"
#include "HTMLBRElement.h"
#include "HTMLButtonElement.h"
#include "HTMLCanvasElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableColElement.h"
#include "HTMLDataElement.h"
#include "HTMLModElement.h"
#include "HTMLDetailsElement.h"
#include "HTMLDialogElement.h"
#include "HTMLDirectoryElement.h"
#include "HTMLDivElement.h"
#include "HTMLDListElement.h"
#include "HTMLEmbedElement.h"
#include "HTMLFieldSetElement.h"
#include "HTMLFontElement.h"
#include "HTMLFormElement.h"
#include "HTMLFrameElement.h"
#include "HTMLFrameSetElement.h"
#include "HTMLHeadingElement.h"
#include "HTMLHeadElement.h"
#include "HTMLHRElement.h"
#include "HTMLHtmlElement.h"
#include "HTMLIFrameElement.h"
#include "HTMLImageElement.h"
#include "HTMLInputElement.h"
#include "HTMLLabelElement.h"
#include "HTMLLegendElement.h"
#include "HTMLLIElement.h"
#include "HTMLLinkElement.h"
#include "HTMLPreElement.h"
#include "HTMLMapElement.h"
#include "HTMLMarqueeElement.h"
#include "HTMLMenuElement.h"
#include "HTMLMetaElement.h"
#include "HTMLMeterElement.h"
#include "HTMLObjectElement.h"
#include "HTMLOListElement.h"
#include "HTMLOptGroupElement.h"
#include "HTMLOptionElement.h"
#include "HTMLOutputElement.h"
#include "HTMLParagraphElement.h"
#include "HTMLParamElement.h"
#include "HTMLPictureElement.h"
#include "HTMLProgressElement.h"
#include "HTMLScriptElement.h"
#include "HTMLSelectElement.h"
#include "HTMLSlotElement.h"
#include "HTMLSourceElement.h"
#include "HTMLSpanElement.h"
#include "HTMLStyleElement.h"
#include "HTMLSummaryElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "HTMLTableCellElement.h"
#include "HTMLTemplateElement.h"
#include "HTMLTextAreaElement.h"
#include "HTMLTimeElement.h"
#include "HTMLTitleElement.h"
#include "HTMLTableRowElement.h"
#include "HTMLUListElement.h"
#include "HTMLWBRElement.h"
#include "HTMLUnknownElement.h"

#if ENABLE(ATTACHMENT_ELEMENT)
#include "HTMLAttachmentElement.h"
#endif

#if ENABLE(DATALIST_ELEMENT)
#include "HTMLDataListElement.h"
#endif

#if ENABLE(MODEL_ELEMENT)
#include "HTMLModelElement.h"
#endif

#if ENABLE(VIDEO)
#include "HTMLAudioElement.h"
#include "HTMLTrackElement.h"
#include "HTMLVideoElement.h"
#endif

#include "DeprecatedGlobalSettings.h"
#include "Document.h"
#include "NodeName.h"
#include "Settings.h"
#include "TagName.h"

namespace WebCore {

static Ref<HTMLElement> anchorConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAnchorElement::create(tagName, document);
}

static Ref<HTMLElement> Constructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLElement::create(tagName, document);
}

static Ref<HTMLElement> unknownConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUnknownElement::create(tagName, document);
}

static Ref<HTMLElement> areaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAreaElement::create(tagName, document);
}

static Ref<HTMLElement> articleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLArticleElement::create(tagName, document);
}

#if ENABLE(ATTACHMENT_ELEMENT)
static Ref<HTMLElement> attachmentConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!DeprecatedGlobalSettings::attachmentElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLAttachmentElement::create(tagName, document);
}
#endif

#if ENABLE(VIDEO)
static Ref<HTMLElement> audioConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);

    return HTMLAudioElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> baseConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBaseElement::create(tagName, document);
}

static Ref<HTMLElement> bdiConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBDIElement::create(tagName, document);
}

static Ref<HTMLElement> quoteConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLQuoteElement::create(tagName, document);
}

static Ref<HTMLElement> bodyConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBodyElement::create(tagName, document);
}

static Ref<HTMLElement> brConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBRElement::create(tagName, document);
}

static Ref<HTMLElement> buttonConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLButtonElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> canvasConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLCanvasElement::create(tagName, document);
}

static Ref<HTMLElement> tablecaptionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableCaptionElement::create(tagName, document);
}

static Ref<HTMLElement> tablecolConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableColElement::create(tagName, document);
}

static Ref<HTMLElement> dataConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDataElement::create(tagName, document);
}

#if ENABLE(DATALIST_ELEMENT)
static Ref<HTMLElement> datalistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!document.settings().dataListElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLDataListElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> modConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLModElement::create(tagName, document);
}

static Ref<HTMLElement> detailsConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDetailsElement::create(tagName, document);
}

static Ref<HTMLElement> dialogConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDialogElement::create(tagName, document);
}

static Ref<HTMLElement> directoryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDirectoryElement::create(tagName, document);
}

static Ref<HTMLElement> divConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDivElement::create(tagName, document);
}

static Ref<HTMLElement> dlistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDListElement::create(tagName, document);
}

static Ref<HTMLElement> embedConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!document.settings().embedElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLEmbedElement::create(tagName, document);
}

static Ref<HTMLElement> fieldsetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLFieldSetElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> fontConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFontElement::create(tagName, document);
}

static Ref<HTMLElement> formConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFormElement::create(tagName, document);
}

static Ref<HTMLElement> frameConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameElement::create(tagName, document);
}

static Ref<HTMLElement> framesetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameSetElement::create(tagName, document);
}

static Ref<HTMLElement> headingConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadingElement::create(tagName, document);
}

static Ref<HTMLElement> headConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadElement::create(tagName, document);
}

static Ref<HTMLElement> hrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHRElement::create(tagName, document);
}

static Ref<HTMLElement> htmlConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHtmlElement::create(tagName, document);
}

static Ref<HTMLElement> iframeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLIFrameElement::create(tagName, document);
}

static Ref<HTMLElement> imageConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLImageElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> inputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return HTMLInputElement::create(tagName, document, formElement, createdByParser);
}

static Ref<HTMLElement> labelConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLabelElement::create(tagName, document);
}

static Ref<HTMLElement> legendConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLegendElement::create(tagName, document);
}

static Ref<HTMLElement> liConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLIElement::create(tagName, document);
}

static Ref<HTMLElement> linkConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLLinkElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> preConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPreElement::create(tagName, document);
}

static Ref<HTMLElement> mapConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMapElement::create(tagName, document);
}

static Ref<HTMLElement> marqueeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMarqueeElement::create(tagName, document);
}

static Ref<HTMLElement> menuConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMenuElement::create(tagName, document);
}

static Ref<HTMLElement> metaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMetaElement::create(tagName, document);
}

static Ref<HTMLElement> meterConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMeterElement::create(tagName, document);
}

#if ENABLE(MODEL_ELEMENT)
static Ref<HTMLElement> modelConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!document.settings().modelElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLModelElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> objectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLObjectElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> olistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOListElement::create(tagName, document);
}

static Ref<HTMLElement> optgroupConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptGroupElement::create(tagName, document);
}

static Ref<HTMLElement> optionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptionElement::create(tagName, document);
}

static Ref<HTMLElement> outputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLOutputElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> paragraphConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParagraphElement::create(tagName, document);
}

static Ref<HTMLElement> paramConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParamElement::create(tagName, document);
}

static Ref<HTMLElement> pictureConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPictureElement::create(tagName, document);
}

static Ref<HTMLElement> progressConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLProgressElement::create(tagName, document);
}

static Ref<HTMLElement> scriptConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLScriptElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> selectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLSelectElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> slotConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSlotElement::create(tagName, document);
}

static Ref<HTMLElement> sourceConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSourceElement::create(tagName, document);
}

static Ref<HTMLElement> spanConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSpanElement::create(tagName, document);
}

static Ref<HTMLElement> styleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLStyleElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> summaryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSummaryElement::create(tagName, document);
}

static Ref<HTMLElement> tableConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableElement::create(tagName, document);
}

static Ref<HTMLElement> tablesectionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableSectionElement::create(tagName, document);
}

static Ref<HTMLElement> tablecellConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableCellElement::create(tagName, document);
}

static Ref<HTMLElement> templateConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTemplateElement::create(tagName, document);
}

static Ref<HTMLElement> textareaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLTextAreaElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> timeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTimeElement::create(tagName, document);
}

static Ref<HTMLElement> titleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTitleElement::create(tagName, document);
}

static Ref<HTMLElement> tablerowConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableRowElement::create(tagName, document);
}

#if ENABLE(VIDEO)
static Ref<HTMLElement> trackConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);

    return HTMLTrackElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> ulistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUListElement::create(tagName, document);
}

#if ENABLE(VIDEO)
static Ref<HTMLElement> videoConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);

    return HTMLVideoElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> wbrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLWBRElement::create(tagName, document);
}


RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(TagName tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    switch (tagName) {
    case TagName::a:
        return anchorConstructor(HTMLNames::aTag, document, formElement, createdByParser);
    case TagName::abbr:
        return Constructor(HTMLNames::abbrTag, document, formElement, createdByParser);
    case TagName::acronym:
        return Constructor(HTMLNames::acronymTag, document, formElement, createdByParser);
    case TagName::address:
        return Constructor(HTMLNames::addressTag, document, formElement, createdByParser);
    case TagName::annotation_xml:
        return unknownConstructor(HTMLNames::annotation_xmlTag, document, formElement, createdByParser);
    case TagName::applet:
        return unknownConstructor(HTMLNames::appletTag, document, formElement, createdByParser);
    case TagName::area:
        return areaConstructor(HTMLNames::areaTag, document, formElement, createdByParser);
    case TagName::article:
        return articleConstructor(HTMLNames::articleTag, document, formElement, createdByParser);
    case TagName::aside:
        return Constructor(HTMLNames::asideTag, document, formElement, createdByParser);
#if ENABLE(ATTACHMENT_ELEMENT)
    case TagName::attachment:
        return attachmentConstructor(HTMLNames::attachmentTag, document, formElement, createdByParser);
#endif
#if ENABLE(VIDEO)
    case TagName::audio:
        return audioConstructor(HTMLNames::audioTag, document, formElement, createdByParser);
#endif
    case TagName::b:
        return Constructor(HTMLNames::bTag, document, formElement, createdByParser);
    case TagName::base:
        return baseConstructor(HTMLNames::baseTag, document, formElement, createdByParser);
    case TagName::basefont:
        return Constructor(HTMLNames::basefontTag, document, formElement, createdByParser);
    case TagName::bdi:
        return bdiConstructor(HTMLNames::bdiTag, document, formElement, createdByParser);
    case TagName::bdo:
        return Constructor(HTMLNames::bdoTag, document, formElement, createdByParser);
    case TagName::bgsound:
        return unknownConstructor(HTMLNames::bgsoundTag, document, formElement, createdByParser);
    case TagName::big:
        return Constructor(HTMLNames::bigTag, document, formElement, createdByParser);
    case TagName::blockquote:
        return quoteConstructor(HTMLNames::blockquoteTag, document, formElement, createdByParser);
    case TagName::body:
        return bodyConstructor(HTMLNames::bodyTag, document, formElement, createdByParser);
    case TagName::br:
        return brConstructor(HTMLNames::brTag, document, formElement, createdByParser);
    case TagName::button:
        return buttonConstructor(HTMLNames::buttonTag, document, formElement, createdByParser);
    case TagName::canvas:
        return canvasConstructor(HTMLNames::canvasTag, document, formElement, createdByParser);
    case TagName::caption:
        return tablecaptionConstructor(HTMLNames::captionTag, document, formElement, createdByParser);
    case TagName::center:
        return Constructor(HTMLNames::centerTag, document, formElement, createdByParser);
    case TagName::cite:
        return Constructor(HTMLNames::citeTag, document, formElement, createdByParser);
    case TagName::code:
        return Constructor(HTMLNames::codeTag, document, formElement, createdByParser);
    case TagName::col:
        return tablecolConstructor(HTMLNames::colTag, document, formElement, createdByParser);
    case TagName::colgroup:
        return tablecolConstructor(HTMLNames::colgroupTag, document, formElement, createdByParser);
    case TagName::color_profile:
        return unknownConstructor(HTMLNames::color_profileTag, document, formElement, createdByParser);
    case TagName::data:
        return dataConstructor(HTMLNames::dataTag, document, formElement, createdByParser);
#if ENABLE(DATALIST_ELEMENT)
    case TagName::datalist:
        return datalistConstructor(HTMLNames::datalistTag, document, formElement, createdByParser);
#endif
    case TagName::dd:
        return Constructor(HTMLNames::ddTag, document, formElement, createdByParser);
    case TagName::del:
        return modConstructor(HTMLNames::delTag, document, formElement, createdByParser);
    case TagName::details:
        return detailsConstructor(HTMLNames::detailsTag, document, formElement, createdByParser);
    case TagName::dfn:
        return Constructor(HTMLNames::dfnTag, document, formElement, createdByParser);
    case TagName::dialog:
        return dialogConstructor(HTMLNames::dialogTag, document, formElement, createdByParser);
    case TagName::dir:
        return directoryConstructor(HTMLNames::dirTag, document, formElement, createdByParser);
    case TagName::div:
        return divConstructor(HTMLNames::divTag, document, formElement, createdByParser);
    case TagName::dl:
        return dlistConstructor(HTMLNames::dlTag, document, formElement, createdByParser);
    case TagName::dt:
        return Constructor(HTMLNames::dtTag, document, formElement, createdByParser);
    case TagName::em:
        return Constructor(HTMLNames::emTag, document, formElement, createdByParser);
    case TagName::embed:
        return embedConstructor(HTMLNames::embedTag, document, formElement, createdByParser);
    case TagName::fieldset:
        return fieldsetConstructor(HTMLNames::fieldsetTag, document, formElement, createdByParser);
    case TagName::figcaption:
        return Constructor(HTMLNames::figcaptionTag, document, formElement, createdByParser);
    case TagName::figure:
        return Constructor(HTMLNames::figureTag, document, formElement, createdByParser);
    case TagName::font:
        return fontConstructor(HTMLNames::fontTag, document, formElement, createdByParser);
    case TagName::font_face:
        return unknownConstructor(HTMLNames::font_faceTag, document, formElement, createdByParser);
    case TagName::font_face_format:
        return unknownConstructor(HTMLNames::font_face_formatTag, document, formElement, createdByParser);
    case TagName::font_face_name:
        return unknownConstructor(HTMLNames::font_face_nameTag, document, formElement, createdByParser);
    case TagName::font_face_src:
        return unknownConstructor(HTMLNames::font_face_srcTag, document, formElement, createdByParser);
    case TagName::font_face_uri:
        return unknownConstructor(HTMLNames::font_face_uriTag, document, formElement, createdByParser);
    case TagName::footer:
        return Constructor(HTMLNames::footerTag, document, formElement, createdByParser);
    case TagName::form:
        return formConstructor(HTMLNames::formTag, document, formElement, createdByParser);
    case TagName::frame:
        return frameConstructor(HTMLNames::frameTag, document, formElement, createdByParser);
    case TagName::frameset:
        return framesetConstructor(HTMLNames::framesetTag, document, formElement, createdByParser);
    case TagName::h1:
        return headingConstructor(HTMLNames::h1Tag, document, formElement, createdByParser);
    case TagName::h2:
        return headingConstructor(HTMLNames::h2Tag, document, formElement, createdByParser);
    case TagName::h3:
        return headingConstructor(HTMLNames::h3Tag, document, formElement, createdByParser);
    case TagName::h4:
        return headingConstructor(HTMLNames::h4Tag, document, formElement, createdByParser);
    case TagName::h5:
        return headingConstructor(HTMLNames::h5Tag, document, formElement, createdByParser);
    case TagName::h6:
        return headingConstructor(HTMLNames::h6Tag, document, formElement, createdByParser);
    case TagName::head:
        return headConstructor(HTMLNames::headTag, document, formElement, createdByParser);
    case TagName::header:
        return Constructor(HTMLNames::headerTag, document, formElement, createdByParser);
    case TagName::hgroup:
        return Constructor(HTMLNames::hgroupTag, document, formElement, createdByParser);
    case TagName::hr:
        return hrConstructor(HTMLNames::hrTag, document, formElement, createdByParser);
    case TagName::html:
        return htmlConstructor(HTMLNames::htmlTag, document, formElement, createdByParser);
    case TagName::i:
        return Constructor(HTMLNames::iTag, document, formElement, createdByParser);
    case TagName::iframe:
        return iframeConstructor(HTMLNames::iframeTag, document, formElement, createdByParser);
    case TagName::image:
        return unknownConstructor(HTMLNames::imageTag, document, formElement, createdByParser);
    case TagName::img:
        return imageConstructor(HTMLNames::imgTag, document, formElement, createdByParser);
    case TagName::input:
        return inputConstructor(HTMLNames::inputTag, document, formElement, createdByParser);
    case TagName::ins:
        return modConstructor(HTMLNames::insTag, document, formElement, createdByParser);
    case TagName::kbd:
        return Constructor(HTMLNames::kbdTag, document, formElement, createdByParser);
    case TagName::keygen:
        return unknownConstructor(HTMLNames::keygenTag, document, formElement, createdByParser);
    case TagName::label:
        return labelConstructor(HTMLNames::labelTag, document, formElement, createdByParser);
    case TagName::legend:
        return legendConstructor(HTMLNames::legendTag, document, formElement, createdByParser);
    case TagName::li:
        return liConstructor(HTMLNames::liTag, document, formElement, createdByParser);
    case TagName::link:
        return linkConstructor(HTMLNames::linkTag, document, formElement, createdByParser);
    case TagName::listing:
        return preConstructor(HTMLNames::listingTag, document, formElement, createdByParser);
    case TagName::main:
        return Constructor(HTMLNames::mainTag, document, formElement, createdByParser);
    case TagName::map:
        return mapConstructor(HTMLNames::mapTag, document, formElement, createdByParser);
    case TagName::mark:
        return Constructor(HTMLNames::markTag, document, formElement, createdByParser);
    case TagName::marquee:
        return marqueeConstructor(HTMLNames::marqueeTag, document, formElement, createdByParser);
    case TagName::menu:
        return menuConstructor(HTMLNames::menuTag, document, formElement, createdByParser);
    case TagName::meta:
        return metaConstructor(HTMLNames::metaTag, document, formElement, createdByParser);
    case TagName::meter:
        return meterConstructor(HTMLNames::meterTag, document, formElement, createdByParser);
    case TagName::missing_glyph:
        return unknownConstructor(HTMLNames::missing_glyphTag, document, formElement, createdByParser);
#if ENABLE(MODEL_ELEMENT)
    case TagName::model:
        return modelConstructor(HTMLNames::modelTag, document, formElement, createdByParser);
#endif
    case TagName::nav:
        return Constructor(HTMLNames::navTag, document, formElement, createdByParser);
    case TagName::nobr:
        return Constructor(HTMLNames::nobrTag, document, formElement, createdByParser);
    case TagName::noembed:
        return Constructor(HTMLNames::noembedTag, document, formElement, createdByParser);
    case TagName::noframes:
        return Constructor(HTMLNames::noframesTag, document, formElement, createdByParser);
    case TagName::noscript:
        return Constructor(HTMLNames::noscriptTag, document, formElement, createdByParser);
    case TagName::object:
        return objectConstructor(HTMLNames::objectTag, document, formElement, createdByParser);
    case TagName::ol:
        return olistConstructor(HTMLNames::olTag, document, formElement, createdByParser);
    case TagName::optgroup:
        return optgroupConstructor(HTMLNames::optgroupTag, document, formElement, createdByParser);
    case TagName::option:
        return optionConstructor(HTMLNames::optionTag, document, formElement, createdByParser);
    case TagName::output:
        return outputConstructor(HTMLNames::outputTag, document, formElement, createdByParser);
    case TagName::p:
        return paragraphConstructor(HTMLNames::pTag, document, formElement, createdByParser);
    case TagName::param:
        return paramConstructor(HTMLNames::paramTag, document, formElement, createdByParser);
    case TagName::picture:
        return pictureConstructor(HTMLNames::pictureTag, document, formElement, createdByParser);
    case TagName::plaintext:
        return Constructor(HTMLNames::plaintextTag, document, formElement, createdByParser);
    case TagName::pre:
        return preConstructor(HTMLNames::preTag, document, formElement, createdByParser);
    case TagName::progress:
        return progressConstructor(HTMLNames::progressTag, document, formElement, createdByParser);
    case TagName::q:
        return quoteConstructor(HTMLNames::qTag, document, formElement, createdByParser);
    case TagName::rb:
        return Constructor(HTMLNames::rbTag, document, formElement, createdByParser);
    case TagName::rp:
        return Constructor(HTMLNames::rpTag, document, formElement, createdByParser);
    case TagName::rt:
        return Constructor(HTMLNames::rtTag, document, formElement, createdByParser);
    case TagName::rtc:
        return Constructor(HTMLNames::rtcTag, document, formElement, createdByParser);
    case TagName::ruby:
        return Constructor(HTMLNames::rubyTag, document, formElement, createdByParser);
    case TagName::s:
        return Constructor(HTMLNames::sTag, document, formElement, createdByParser);
    case TagName::samp:
        return Constructor(HTMLNames::sampTag, document, formElement, createdByParser);
    case TagName::script:
        return scriptConstructor(HTMLNames::scriptTag, document, formElement, createdByParser);
    case TagName::search:
        return Constructor(HTMLNames::searchTag, document, formElement, createdByParser);
    case TagName::section:
        return Constructor(HTMLNames::sectionTag, document, formElement, createdByParser);
    case TagName::select:
        return selectConstructor(HTMLNames::selectTag, document, formElement, createdByParser);
    case TagName::slot:
        return slotConstructor(HTMLNames::slotTag, document, formElement, createdByParser);
    case TagName::small_:
        return Constructor(HTMLNames::smallTag, document, formElement, createdByParser);
    case TagName::source:
        return sourceConstructor(HTMLNames::sourceTag, document, formElement, createdByParser);
    case TagName::span:
        return spanConstructor(HTMLNames::spanTag, document, formElement, createdByParser);
    case TagName::strike:
        return Constructor(HTMLNames::strikeTag, document, formElement, createdByParser);
    case TagName::strong:
        return Constructor(HTMLNames::strongTag, document, formElement, createdByParser);
    case TagName::style:
        return styleConstructor(HTMLNames::styleTag, document, formElement, createdByParser);
    case TagName::sub:
        return Constructor(HTMLNames::subTag, document, formElement, createdByParser);
    case TagName::summary:
        return summaryConstructor(HTMLNames::summaryTag, document, formElement, createdByParser);
    case TagName::sup:
        return Constructor(HTMLNames::supTag, document, formElement, createdByParser);
    case TagName::table:
        return tableConstructor(HTMLNames::tableTag, document, formElement, createdByParser);
    case TagName::tbody:
        return tablesectionConstructor(HTMLNames::tbodyTag, document, formElement, createdByParser);
    case TagName::td:
        return tablecellConstructor(HTMLNames::tdTag, document, formElement, createdByParser);
    case TagName::template_:
        return templateConstructor(HTMLNames::templateTag, document, formElement, createdByParser);
    case TagName::textarea:
        return textareaConstructor(HTMLNames::textareaTag, document, formElement, createdByParser);
    case TagName::tfoot:
        return tablesectionConstructor(HTMLNames::tfootTag, document, formElement, createdByParser);
    case TagName::th:
        return tablecellConstructor(HTMLNames::thTag, document, formElement, createdByParser);
    case TagName::thead:
        return tablesectionConstructor(HTMLNames::theadTag, document, formElement, createdByParser);
    case TagName::time:
        return timeConstructor(HTMLNames::timeTag, document, formElement, createdByParser);
    case TagName::title:
        return titleConstructor(HTMLNames::titleTag, document, formElement, createdByParser);
    case TagName::tr:
        return tablerowConstructor(HTMLNames::trTag, document, formElement, createdByParser);
#if ENABLE(VIDEO)
    case TagName::track:
        return trackConstructor(HTMLNames::trackTag, document, formElement, createdByParser);
#endif
    case TagName::tt:
        return Constructor(HTMLNames::ttTag, document, formElement, createdByParser);
    case TagName::u:
        return Constructor(HTMLNames::uTag, document, formElement, createdByParser);
    case TagName::ul:
        return ulistConstructor(HTMLNames::ulTag, document, formElement, createdByParser);
    case TagName::var:
        return Constructor(HTMLNames::varTag, document, formElement, createdByParser);
#if ENABLE(VIDEO)
    case TagName::video:
        return videoConstructor(HTMLNames::videoTag, document, formElement, createdByParser);
#endif
    case TagName::wbr:
        return wbrConstructor(HTMLNames::wbrTag, document, formElement, createdByParser);
    case TagName::xmp:
        return preConstructor(HTMLNames::xmpTag, document, formElement, createdByParser);
    default:
        return nullptr;
    }
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElementWithName(TagName tagName, const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    switch (tagName) {
    case TagName::a:
        return anchorConstructor(name, document, formElement, createdByParser);
    case TagName::abbr:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::acronym:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::address:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::annotation_xml:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::applet:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::area:
        return areaConstructor(name, document, formElement, createdByParser);
    case TagName::article:
        return articleConstructor(name, document, formElement, createdByParser);
    case TagName::aside:
        return Constructor(name, document, formElement, createdByParser);
#if ENABLE(ATTACHMENT_ELEMENT)
    case TagName::attachment:
        return attachmentConstructor(name, document, formElement, createdByParser);
#endif
#if ENABLE(VIDEO)
    case TagName::audio:
        return audioConstructor(name, document, formElement, createdByParser);
#endif
    case TagName::b:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::base:
        return baseConstructor(name, document, formElement, createdByParser);
    case TagName::basefont:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::bdi:
        return bdiConstructor(name, document, formElement, createdByParser);
    case TagName::bdo:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::bgsound:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::big:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::blockquote:
        return quoteConstructor(name, document, formElement, createdByParser);
    case TagName::body:
        return bodyConstructor(name, document, formElement, createdByParser);
    case TagName::br:
        return brConstructor(name, document, formElement, createdByParser);
    case TagName::button:
        return buttonConstructor(name, document, formElement, createdByParser);
    case TagName::canvas:
        return canvasConstructor(name, document, formElement, createdByParser);
    case TagName::caption:
        return tablecaptionConstructor(name, document, formElement, createdByParser);
    case TagName::center:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::cite:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::code:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::col:
        return tablecolConstructor(name, document, formElement, createdByParser);
    case TagName::colgroup:
        return tablecolConstructor(name, document, formElement, createdByParser);
    case TagName::color_profile:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::data:
        return dataConstructor(name, document, formElement, createdByParser);
#if ENABLE(DATALIST_ELEMENT)
    case TagName::datalist:
        return datalistConstructor(name, document, formElement, createdByParser);
#endif
    case TagName::dd:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::del:
        return modConstructor(name, document, formElement, createdByParser);
    case TagName::details:
        return detailsConstructor(name, document, formElement, createdByParser);
    case TagName::dfn:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::dialog:
        return dialogConstructor(name, document, formElement, createdByParser);
    case TagName::dir:
        return directoryConstructor(name, document, formElement, createdByParser);
    case TagName::div:
        return divConstructor(name, document, formElement, createdByParser);
    case TagName::dl:
        return dlistConstructor(name, document, formElement, createdByParser);
    case TagName::dt:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::em:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::embed:
        return embedConstructor(name, document, formElement, createdByParser);
    case TagName::fieldset:
        return fieldsetConstructor(name, document, formElement, createdByParser);
    case TagName::figcaption:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::figure:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::font:
        return fontConstructor(name, document, formElement, createdByParser);
    case TagName::font_face:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::font_face_format:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::font_face_name:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::font_face_src:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::font_face_uri:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::footer:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::form:
        return formConstructor(name, document, formElement, createdByParser);
    case TagName::frame:
        return frameConstructor(name, document, formElement, createdByParser);
    case TagName::frameset:
        return framesetConstructor(name, document, formElement, createdByParser);
    case TagName::h1:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::h2:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::h3:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::h4:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::h5:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::h6:
        return headingConstructor(name, document, formElement, createdByParser);
    case TagName::head:
        return headConstructor(name, document, formElement, createdByParser);
    case TagName::header:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::hgroup:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::hr:
        return hrConstructor(name, document, formElement, createdByParser);
    case TagName::html:
        return htmlConstructor(name, document, formElement, createdByParser);
    case TagName::i:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::iframe:
        return iframeConstructor(name, document, formElement, createdByParser);
    case TagName::image:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::img:
        return imageConstructor(name, document, formElement, createdByParser);
    case TagName::input:
        return inputConstructor(name, document, formElement, createdByParser);
    case TagName::ins:
        return modConstructor(name, document, formElement, createdByParser);
    case TagName::kbd:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::keygen:
        return unknownConstructor(name, document, formElement, createdByParser);
    case TagName::label:
        return labelConstructor(name, document, formElement, createdByParser);
    case TagName::legend:
        return legendConstructor(name, document, formElement, createdByParser);
    case TagName::li:
        return liConstructor(name, document, formElement, createdByParser);
    case TagName::link:
        return linkConstructor(name, document, formElement, createdByParser);
    case TagName::listing:
        return preConstructor(name, document, formElement, createdByParser);
    case TagName::main:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::map:
        return mapConstructor(name, document, formElement, createdByParser);
    case TagName::mark:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::marquee:
        return marqueeConstructor(name, document, formElement, createdByParser);
    case TagName::menu:
        return menuConstructor(name, document, formElement, createdByParser);
    case TagName::meta:
        return metaConstructor(name, document, formElement, createdByParser);
    case TagName::meter:
        return meterConstructor(name, document, formElement, createdByParser);
    case TagName::missing_glyph:
        return unknownConstructor(name, document, formElement, createdByParser);
#if ENABLE(MODEL_ELEMENT)
    case TagName::model:
        return modelConstructor(name, document, formElement, createdByParser);
#endif
    case TagName::nav:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::nobr:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::noembed:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::noframes:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::noscript:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::object:
        return objectConstructor(name, document, formElement, createdByParser);
    case TagName::ol:
        return olistConstructor(name, document, formElement, createdByParser);
    case TagName::optgroup:
        return optgroupConstructor(name, document, formElement, createdByParser);
    case TagName::option:
        return optionConstructor(name, document, formElement, createdByParser);
    case TagName::output:
        return outputConstructor(name, document, formElement, createdByParser);
    case TagName::p:
        return paragraphConstructor(name, document, formElement, createdByParser);
    case TagName::param:
        return paramConstructor(name, document, formElement, createdByParser);
    case TagName::picture:
        return pictureConstructor(name, document, formElement, createdByParser);
    case TagName::plaintext:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::pre:
        return preConstructor(name, document, formElement, createdByParser);
    case TagName::progress:
        return progressConstructor(name, document, formElement, createdByParser);
    case TagName::q:
        return quoteConstructor(name, document, formElement, createdByParser);
    case TagName::rb:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::rp:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::rt:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::rtc:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::ruby:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::s:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::samp:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::script:
        return scriptConstructor(name, document, formElement, createdByParser);
    case TagName::search:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::section:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::select:
        return selectConstructor(name, document, formElement, createdByParser);
    case TagName::slot:
        return slotConstructor(name, document, formElement, createdByParser);
    case TagName::small_:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::source:
        return sourceConstructor(name, document, formElement, createdByParser);
    case TagName::span:
        return spanConstructor(name, document, formElement, createdByParser);
    case TagName::strike:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::strong:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::style:
        return styleConstructor(name, document, formElement, createdByParser);
    case TagName::sub:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::summary:
        return summaryConstructor(name, document, formElement, createdByParser);
    case TagName::sup:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::table:
        return tableConstructor(name, document, formElement, createdByParser);
    case TagName::tbody:
        return tablesectionConstructor(name, document, formElement, createdByParser);
    case TagName::td:
        return tablecellConstructor(name, document, formElement, createdByParser);
    case TagName::template_:
        return templateConstructor(name, document, formElement, createdByParser);
    case TagName::textarea:
        return textareaConstructor(name, document, formElement, createdByParser);
    case TagName::tfoot:
        return tablesectionConstructor(name, document, formElement, createdByParser);
    case TagName::th:
        return tablecellConstructor(name, document, formElement, createdByParser);
    case TagName::thead:
        return tablesectionConstructor(name, document, formElement, createdByParser);
    case TagName::time:
        return timeConstructor(name, document, formElement, createdByParser);
    case TagName::title:
        return titleConstructor(name, document, formElement, createdByParser);
    case TagName::tr:
        return tablerowConstructor(name, document, formElement, createdByParser);
#if ENABLE(VIDEO)
    case TagName::track:
        return trackConstructor(name, document, formElement, createdByParser);
#endif
    case TagName::tt:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::u:
        return Constructor(name, document, formElement, createdByParser);
    case TagName::ul:
        return ulistConstructor(name, document, formElement, createdByParser);
    case TagName::var:
        return Constructor(name, document, formElement, createdByParser);
#if ENABLE(VIDEO)
    case TagName::video:
        return videoConstructor(name, document, formElement, createdByParser);
#endif
    case TagName::wbr:
        return wbrConstructor(name, document, formElement, createdByParser);
    case TagName::xmp:
        return preConstructor(name, document, formElement, createdByParser);
    default:
        return nullptr;
    }
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(const AtomString& localName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return createKnownElement(tagNameForElementName(findHTMLElementName(localName)), document, formElement, createdByParser);
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return createKnownElementWithName(tagNameForElementName(name.nodeName()), name, document, formElement, createdByParser);
}

Ref<HTMLElement> HTMLElementFactory::createElement(const AtomString& localName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    auto elementName = findHTMLElementName(localName);
    if (elementName != ElementName::Unknown)
        return createKnownElement(tagNameForElementName(elementName), document, formElement, createdByParser).releaseNonNull();
    return HTMLUnknownElement::create(QualifiedName(nullAtom(), localName, HTMLNames::xhtmlNamespaceURI), document);
}

Ref<HTMLElement> HTMLElementFactory::createElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    auto elementName = name.nodeName();
    if (elementName != ElementName::Unknown) {
        if (auto result = createKnownElementWithName(tagNameForElementName(elementName), name, document, formElement, createdByParser))
            return result.releaseNonNull();
    }
    return HTMLUnknownElement::create(name, document);
}

} // namespace WebCore

