/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushSubscriptionOptions.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionOptionsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionOptions_userVisibleOnly);
static JSC_DECLARE_CUSTOM_GETTER(jsPushSubscriptionOptions_applicationServerKey);

class JSPushSubscriptionOptionsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPushSubscriptionOptionsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPushSubscriptionOptionsPrototype* ptr = new (NotNull, JSC::allocateCell<JSPushSubscriptionOptionsPrototype>(vm)) JSPushSubscriptionOptionsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionOptionsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPushSubscriptionOptionsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushSubscriptionOptionsPrototype, JSPushSubscriptionOptionsPrototype::Base);

using JSPushSubscriptionOptionsDOMConstructor = JSDOMConstructorNotConstructable<JSPushSubscriptionOptions>;

template<> const ClassInfo JSPushSubscriptionOptionsDOMConstructor::s_info = { "PushSubscriptionOptions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionOptionsDOMConstructor) };

template<> JSValue JSPushSubscriptionOptionsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPushSubscriptionOptionsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PushSubscriptionOptions"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPushSubscriptionOptions::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPushSubscriptionOptionsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionOptionsConstructor, 0 } },
    { "userVisibleOnly"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionOptions_userVisibleOnly, 0 } },
    { "applicationServerKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPushSubscriptionOptions_applicationServerKey, 0 } },
};

const ClassInfo JSPushSubscriptionOptionsPrototype::s_info = { "PushSubscriptionOptions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionOptionsPrototype) };

void JSPushSubscriptionOptionsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPushSubscriptionOptions::info(), JSPushSubscriptionOptionsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPushSubscriptionOptions::s_info = { "PushSubscriptionOptions"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushSubscriptionOptions) };

JSPushSubscriptionOptions::JSPushSubscriptionOptions(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PushSubscriptionOptions>&& impl)
    : JSDOMWrapper<PushSubscriptionOptions>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PushSubscriptionOptions>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPushSubscriptionOptions::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPushSubscriptionOptionsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPushSubscriptionOptionsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPushSubscriptionOptions::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPushSubscriptionOptions>(vm, globalObject);
}

JSValue JSPushSubscriptionOptions::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPushSubscriptionOptionsDOMConstructor, DOMConstructorID::PushSubscriptionOptions>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPushSubscriptionOptions::destroy(JSC::JSCell* cell)
{
    JSPushSubscriptionOptions* thisObject = static_cast<JSPushSubscriptionOptions*>(cell);
    thisObject->JSPushSubscriptionOptions::~JSPushSubscriptionOptions();
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionOptionsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPushSubscriptionOptionsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPushSubscriptionOptions::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPushSubscriptionOptions_userVisibleOnlyGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscriptionOptions& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.userVisibleOnly())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionOptions_userVisibleOnly, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscriptionOptions>::get<jsPushSubscriptionOptions_userVisibleOnlyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPushSubscriptionOptions_applicationServerKeyGetter(JSGlobalObject& lexicalGlobalObject, JSPushSubscriptionOptions& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLArrayBuffer>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.applicationServerKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushSubscriptionOptions_applicationServerKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushSubscriptionOptions>::get<jsPushSubscriptionOptions_applicationServerKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPushSubscriptionOptions::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPushSubscriptionOptions, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPushSubscriptionOptions.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPushSubscriptionOptions = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPushSubscriptionOptions.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPushSubscriptionOptions = std::forward<decltype(space)>(space); }
    );
}

void JSPushSubscriptionOptions::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPushSubscriptionOptions*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSPushSubscriptionOptionsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPushSubscriptionOptionsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPushSubscriptionOptions = static_cast<JSPushSubscriptionOptions*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPushSubscriptionOptions->protectedWrapped().ptr(), jsPushSubscriptionOptions);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PushSubscriptionOptions@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23PushSubscriptionOptionsE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, PushSubscriptionOptions>, void>> static inline void verifyVTable(PushSubscriptionOptions* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PushSubscriptionOptions@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23PushSubscriptionOptionsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PushSubscriptionOptions has subclasses. If PushSubscriptionOptions has subclasses that get passed
        // to toJS() we currently require PushSubscriptionOptions you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PushSubscriptionOptions>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PushSubscriptionOptions>(impl.ptr());
#endif
    return createWrapper<PushSubscriptionOptions>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PushSubscriptionOptions& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PushSubscriptionOptions* JSPushSubscriptionOptions::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPushSubscriptionOptions*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
