/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMJITAbstractHeapRepository.h"
#include "DOMJITIDLConvert.h"
#include "DOMJITIDLType.h"
#include "DOMJITIDLTypeFilter.h"
#include "DOMPromiseProxy.h"
#include "DocumentInlines.h"
#include "DocumentSVG.h"
#include "DocumentStorageAccess.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSComment.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMConvertXPathNSResolver.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMImplementation.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMSelection.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSDocumentTimeline.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSFontFaceSet.h"
#include "JSFragmentDirective.h"
#include "JSGPUCanvasContext.h"
#include "JSHTMLAllCollection.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSLocation.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSSVGSVGElement.h"
#include "JSStartViewTransitionOptions.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSTrustedHTML.h"
#include "JSUndoManager.h"
#include "JSViewTransition.h"
#include "JSViewTransitionUpdateCallback.h"
#include "JSVisibilityState.h"
#include "JSWebAnimation.h"
#include "JSWebGL2RenderingContext.h"
#include "JSWebGLRenderingContext.h"
#include "JSWindowProxy.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "LocalDOMWindow.h"
#include "Quirks.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FrameTracers.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>

#if ENABLE(FULLSCREEN_API)
#include "DocumentFullscreen.h"
#include "DocumentOrShadowRootFullscreen.h"
#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "DocumentPictureInPicture.h"
#endif

#if ENABLE(TOUCH_EVENTS)
#include "DocumentTouch.h"
#include "JSEventTarget.h"
#include "JSTouch.h"
#include "JSTouchList.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(Document::ReadyState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("interactive"),
        MAKE_STATIC_STRING_IMPL("complete"),
    };
    static_assert(static_cast<size_t>(Document::ReadyState::Loading) == 0, "Document::ReadyState::Loading is not 0 as expected");
    static_assert(static_cast<size_t>(Document::ReadyState::Interactive) == 1, "Document::ReadyState::Interactive is not 1 as expected");
    static_assert(static_cast<size_t>(Document::ReadyState::Complete) == 2, "Document::ReadyState::Complete is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, Document::ReadyState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<Document::ReadyState> parseEnumerationFromString<Document::ReadyState>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, Document::ReadyState> mappings[] = {
        { "complete", Document::ReadyState::Complete },
        { "interactive", Document::ReadyState::Interactive },
        { "loading", Document::ReadyState::Loading },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<Document::ReadyState> parseEnumeration<Document::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<Document::ReadyState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<Document::ReadyState>()
{
    return "\"loading\", \"interactive\", \"complete\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDocumentConstructorFunction_parseHTMLUnsafe);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByTagName);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByTagNameNS);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByClassName);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createElement);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createElementNS);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createDocumentFragment);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTextNode);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createCDATASection);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createComment);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createProcessingInstruction);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_importNode);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_adoptNode);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createAttribute);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createAttributeNS);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createEvent);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createRange);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createNodeIterator);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTreeWalker);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_caretRangeFromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getCSSCanvasContext);
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitPictureInPicture);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitFullscreen);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_webkitExitFullscreen);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_webkitCancelFullScreen);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByName);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_open);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_write);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_writeln);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_hasFocus);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_execCommand);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandEnabled);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandIndeterm);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandState);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandSupported);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandValue);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_clear);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_captureEvents);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_releaseEvents);
#if ENABLE(POINTER_LOCK)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitPointerLock);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getSelection);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_hasStorageAccess);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_requestStorageAccess);
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTouch);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTouchList);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_startViewTransition);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_elementFromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_elementsFromPoint);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getAnimations);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementById);
extern "C" { static JSC_DECLARE_JIT_OPERATION_WITHOUT_WTF_INTERNAL(jsDocumentPrototypeFunction_getElementByIdWithoutTypeCheck, JSC::EncodedJSValue, (JSC::JSGlobalObject*, JSDocument*, DOMJIT::IDLJSArgumentType<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>)); }static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_prepend);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_append);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_replaceChildren);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_querySelector);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_querySelectorAll);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createExpression);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_createNSResolver);
static JSC_DECLARE_HOST_FUNCTION(jsDocumentPrototypeFunction_evaluate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDocumentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fragmentDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_implementation);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_URL);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_documentURI);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_compatMode);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_characterSet);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_charset);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_inputEncoding);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_contentType);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_doctype);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_documentElement);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_xmlEncoding);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_xmlVersion);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_xmlVersion);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_xmlStandalone);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_xmlStandalone);
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_pictureInPictureEnabled);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_timeline);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fonts);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_scrollingElement);
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fullscreenEnabled);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_fullscreenEnabled);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fullscreen);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_fullscreen);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onfullscreenchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onfullscreenchange);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onfullscreenerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onfullscreenerror);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_webkitFullscreenEnabled);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_webkitFullscreenElement);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitfullscreenchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitfullscreenchange);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitfullscreenerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitfullscreenerror);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_webkitIsFullScreen);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_webkitFullScreenKeyboardInputAllowed);
#endif
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_webkitCurrentFullScreenElement);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_location);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_location);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_domain);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_domain);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_referrer);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_cookie);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_cookie);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_lastModified);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_title);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_title);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_dir);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_dir);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_body);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_body);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_head);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_images);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_embeds);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_plugins);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_links);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_forms);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_scripts);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_currentScript);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_defaultView);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_designMode);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_designMode);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onreadystatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onreadystatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fgColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_fgColor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_linkColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_linkColor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_vlinkColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_vlinkColor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_alinkColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_alinkColor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_bgColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_bgColor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_anchors);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_applets);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_all);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_hidden);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_visibilityState);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onvisibilitychange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onvisibilitychange);
#if ENABLE(POINTER_LOCK)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerlockchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerlockchange);
#endif
#if ENABLE(POINTER_LOCK)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerlockerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerlockerror);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_undoManager);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onbeforecopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onbeforecopy);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onbeforecut);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onbeforecut);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onbeforeinput);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onbeforeinput);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onbeforepaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onbeforepaste);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_activeElement);
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_pictureInPictureElement);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_styleSheets);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_adoptedStyleSheets);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_adoptedStyleSheets);
#if ENABLE(FULLSCREEN_API)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_fullscreenElement);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_fullscreenElement);
#endif
#if ENABLE(POINTER_LOCK)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_pointerLockElement);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onauxclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onauxclick);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onbeforetoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onbeforetoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncanplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncanplay);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncanplaythrough);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncanplaythrough);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onchange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onclick);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onclose);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncontextmenu);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncontextmenu);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncopy);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncuechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncuechange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oncut);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oncut);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondblclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondblclick);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondrag);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondrag);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondragend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondragend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondragenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondragenter);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondragleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondragleave);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondragover);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondragover);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondragstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondragstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondrop);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondrop);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ondurationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ondurationchange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onemptied);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onemptied);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onended);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onformdata);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onformdata);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oninput);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oninput);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_oninvalid);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_oninvalid);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onkeydown);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onkeydown);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onkeypress);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onkeypress);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onkeyup);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onkeyup);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onloadeddata);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onloadeddata);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onloadedmetadata);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onloadedmetadata);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onloadstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onloadstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmousedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmousedown);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmouseenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmouseenter);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmouseleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmouseleave);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmousemove);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmousemove);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmouseout);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmouseout);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmouseover);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmouseover);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmouseup);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmouseup);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpaste);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpause);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpause);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onplay);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onplaying);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onplaying);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onprogress);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onratechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onratechange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onreset);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onreset);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onseeked);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onseeked);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onseeking);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onseeking);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onselect);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onselect);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onslotchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onslotchange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onstalled);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onstalled);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onsubmit);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onsubmit);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onsuspend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onsuspend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontimeupdate);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontimeupdate);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onvolumechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onvolumechange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwaiting);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwaiting);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwheel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onmousewheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onmousewheel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onsearch);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onsearch);
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontouchcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontouchcancel);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontouchend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontouchend);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontouchmove);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontouchmove);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontouchstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontouchstart);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontouchforcechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontouchforcechange);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onanimationcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onanimationcancel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontransitionrun);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontransitionrun);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontransitionstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontransitionstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ontransitioncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ontransitioncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_ongotpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_ongotpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onlostpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onlostpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerdown);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerdown);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointermove);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointermove);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerup);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerup);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointercancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointercancel);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerover);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerover);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerout);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerout);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerenter);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onpointerleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onpointerleave);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onselectstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onselectstart);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_onselectionchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSDocument_onselectionchange);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_children);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_firstElementChild);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_lastElementChild);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_childElementCount);
static JSC_DECLARE_CUSTOM_GETTER(jsDocument_rootElement);

static const JSC::DOMJIT::Signature DOMJITSignatureForDocumentGetElementById(jsDocumentPrototypeFunction_getElementByIdWithoutTypeCheck, JSDocument::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Element>>>::value, DOMJIT::IDLArgumentTypeFilter<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>::value);

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForDocumentDocumentElement {
    jsDocument_documentElement,
#if ENABLE(JIT)
    &compileDocumentDocumentElementAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Element>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForDocumentBody {
    jsDocument_body,
#if ENABLE(JIT)
    &compileDocumentBodyAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<HTMLElement>>>::value
};

class JSDocumentPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDocumentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentPrototype>(vm)) JSDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentPrototype, JSDocumentPrototype::Base);

using JSDocumentDOMConstructor = JSDOMConstructor<JSDocument>;

/* Hash table */

static const struct CompactHashIndex JSDocumentTableIndex[2] = {
    { 0, -1 },
    { -1, -1 },
};


static const HashTableValue JSDocumentTableValues[] =
{
    { "location"_s, JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_location, setJSDocument_location } },
};

static const HashTable JSDocumentTable = { 1, 1, static_cast<uint8_t>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute | JSC::PropertyAttribute::DontDelete), JSDocument::info(), JSDocumentTableValues, JSDocumentTableIndex };
/* Hash table for constructor */

static const HashTableValue JSDocumentConstructorTableValues[] =
{
    { "parseHTMLUnsafe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentConstructorFunction_parseHTMLUnsafe, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDocumentDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDocumentDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Document"_s);
    auto& document = downcast<Document>(*context);
    auto object = Document::create(document);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<Document>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDocumentDOMConstructorConstruct, JSDocumentDOMConstructor::construct);

template<> const ClassInfo JSDocumentDOMConstructor::s_info = { "Document"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentDOMConstructor) };

template<> JSValue JSDocumentDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Document"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDocument::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDocument::info(), JSDocumentConstructorTableValues, *this);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settingsValues().declarativeShadowRootsParserAPIsEnabled) {
        auto propertyName = Identifier::fromString(vm, "parseHTMLUnsafe"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentConstructor, 0 } },
    { "fragmentDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fragmentDirective, 0 } },
    { "implementation"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_implementation, 0 } },
    { "URL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_URL, 0 } },
    { "documentURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_documentURI, 0 } },
    { "compatMode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_compatMode, 0 } },
    { "characterSet"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_characterSet, 0 } },
    { "charset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_charset, 0 } },
    { "inputEncoding"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_inputEncoding, 0 } },
    { "contentType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_contentType, 0 } },
    { "doctype"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_doctype, 0 } },
    { "documentElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForDocumentDocumentElement, 0 } },
    { "xmlEncoding"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_xmlEncoding, 0 } },
    { "xmlVersion"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_xmlVersion, setJSDocument_xmlVersion } },
    { "xmlStandalone"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_xmlStandalone, setJSDocument_xmlStandalone } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureEnabled"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_pictureInPictureEnabled, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "timeline"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_timeline, 0 } },
    { "fonts"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fonts, 0 } },
    { "scrollingElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_scrollingElement, 0 } },
#if ENABLE(FULLSCREEN_API)
    { "fullscreenEnabled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fullscreenEnabled, setJSDocument_fullscreenEnabled } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "fullscreen"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fullscreen, setJSDocument_fullscreen } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onfullscreenchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onfullscreenchange, setJSDocument_onfullscreenchange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onfullscreenerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onfullscreenerror, setJSDocument_onfullscreenerror } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitFullscreenEnabled"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_webkitFullscreenEnabled, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitFullscreenElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_webkitFullscreenElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitfullscreenchange, setJSDocument_onwebkitfullscreenchange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitfullscreenerror, setJSDocument_onwebkitfullscreenerror } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitIsFullScreen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_webkitIsFullScreen, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitFullScreenKeyboardInputAllowed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_webkitFullScreenKeyboardInputAllowed, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitCurrentFullScreenElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_webkitCurrentFullScreenElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "domain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_domain, setJSDocument_domain } },
    { "referrer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_referrer, 0 } },
    { "cookie"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_cookie, setJSDocument_cookie } },
    { "lastModified"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_lastModified, 0 } },
    { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_readyState, 0 } },
    { "title"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_title, setJSDocument_title } },
    { "dir"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_dir, setJSDocument_dir } },
    { "body"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForDocumentBody, setJSDocument_body } },
    { "head"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_head, 0 } },
    { "images"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_images, 0 } },
    { "embeds"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_embeds, 0 } },
    { "plugins"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_plugins, 0 } },
    { "links"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_links, 0 } },
    { "forms"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_forms, 0 } },
    { "scripts"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_scripts, 0 } },
    { "currentScript"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_currentScript, 0 } },
    { "defaultView"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_defaultView, 0 } },
    { "designMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_designMode, setJSDocument_designMode } },
    { "onreadystatechange"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onreadystatechange, setJSDocument_onreadystatechange } },
    { "fgColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fgColor, setJSDocument_fgColor } },
    { "linkColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_linkColor, setJSDocument_linkColor } },
    { "vlinkColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_vlinkColor, setJSDocument_vlinkColor } },
    { "alinkColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_alinkColor, setJSDocument_alinkColor } },
    { "bgColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_bgColor, setJSDocument_bgColor } },
    { "anchors"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_anchors, 0 } },
    { "applets"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_applets, 0 } },
    { "all"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_all, 0 } },
    { "hidden"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_hidden, 0 } },
    { "visibilityState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_visibilityState, 0 } },
    { "onvisibilitychange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onvisibilitychange, setJSDocument_onvisibilitychange } },
#if ENABLE(POINTER_LOCK)
    { "onpointerlockchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerlockchange, setJSDocument_onpointerlockchange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(POINTER_LOCK)
    { "onpointerlockerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerlockerror, setJSDocument_onpointerlockerror } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "undoManager"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_undoManager, 0 } },
    { "onbeforecopy"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onbeforecopy, setJSDocument_onbeforecopy } },
    { "onbeforecut"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onbeforecut, setJSDocument_onbeforecut } },
    { "onbeforeinput"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onbeforeinput, setJSDocument_onbeforeinput } },
    { "onbeforepaste"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onbeforepaste, setJSDocument_onbeforepaste } },
    { "activeElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_activeElement, 0 } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_pictureInPictureElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "styleSheets"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_styleSheets, 0 } },
    { "adoptedStyleSheets"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_adoptedStyleSheets, setJSDocument_adoptedStyleSheets } },
#if ENABLE(FULLSCREEN_API)
    { "fullscreenElement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_fullscreenElement, setJSDocument_fullscreenElement } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(POINTER_LOCK)
    { "pointerLockElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_pointerLockElement, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onabort, setJSDocument_onabort } },
    { "onauxclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onauxclick, setJSDocument_onauxclick } },
    { "onbeforetoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onbeforetoggle, setJSDocument_onbeforetoggle } },
    { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onblur, setJSDocument_onblur } },
    { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncancel, setJSDocument_oncancel } },
    { "oncanplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncanplay, setJSDocument_oncanplay } },
    { "oncanplaythrough"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncanplaythrough, setJSDocument_oncanplaythrough } },
    { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onchange, setJSDocument_onchange } },
    { "onclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onclick, setJSDocument_onclick } },
    { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onclose, setJSDocument_onclose } },
    { "oncontentvisibilityautostatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncontentvisibilityautostatechange, setJSDocument_oncontentvisibilityautostatechange } },
    { "oncontextmenu"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncontextmenu, setJSDocument_oncontextmenu } },
    { "oncopy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncopy, setJSDocument_oncopy } },
    { "oncuechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncuechange, setJSDocument_oncuechange } },
    { "oncut"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oncut, setJSDocument_oncut } },
    { "ondblclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondblclick, setJSDocument_ondblclick } },
    { "ondrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondrag, setJSDocument_ondrag } },
    { "ondragend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondragend, setJSDocument_ondragend } },
    { "ondragenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondragenter, setJSDocument_ondragenter } },
    { "ondragleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondragleave, setJSDocument_ondragleave } },
    { "ondragover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondragover, setJSDocument_ondragover } },
    { "ondragstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondragstart, setJSDocument_ondragstart } },
    { "ondrop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondrop, setJSDocument_ondrop } },
    { "ondurationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ondurationchange, setJSDocument_ondurationchange } },
    { "onemptied"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onemptied, setJSDocument_onemptied } },
    { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onended, setJSDocument_onended } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onerror, setJSDocument_onerror } },
    { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onfocus, setJSDocument_onfocus } },
    { "onformdata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onformdata, setJSDocument_onformdata } },
    { "oninput"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oninput, setJSDocument_oninput } },
    { "oninvalid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_oninvalid, setJSDocument_oninvalid } },
    { "onkeydown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onkeydown, setJSDocument_onkeydown } },
    { "onkeypress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onkeypress, setJSDocument_onkeypress } },
    { "onkeyup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onkeyup, setJSDocument_onkeyup } },
    { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onload, setJSDocument_onload } },
    { "onloadeddata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onloadeddata, setJSDocument_onloadeddata } },
    { "onloadedmetadata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onloadedmetadata, setJSDocument_onloadedmetadata } },
    { "onloadstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onloadstart, setJSDocument_onloadstart } },
    { "onmousedown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmousedown, setJSDocument_onmousedown } },
    { "onmouseenter"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmouseenter, setJSDocument_onmouseenter } },
    { "onmouseleave"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmouseleave, setJSDocument_onmouseleave } },
    { "onmousemove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmousemove, setJSDocument_onmousemove } },
    { "onmouseout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmouseout, setJSDocument_onmouseout } },
    { "onmouseover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmouseover, setJSDocument_onmouseover } },
    { "onmouseup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmouseup, setJSDocument_onmouseup } },
    { "onpaste"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpaste, setJSDocument_onpaste } },
    { "onpause"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpause, setJSDocument_onpause } },
    { "onplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onplay, setJSDocument_onplay } },
    { "onplaying"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onplaying, setJSDocument_onplaying } },
    { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onprogress, setJSDocument_onprogress } },
    { "onratechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onratechange, setJSDocument_onratechange } },
    { "onreset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onreset, setJSDocument_onreset } },
    { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onresize, setJSDocument_onresize } },
    { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onscroll, setJSDocument_onscroll } },
    { "onsecuritypolicyviolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onsecuritypolicyviolation, setJSDocument_onsecuritypolicyviolation } },
    { "onseeked"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onseeked, setJSDocument_onseeked } },
    { "onseeking"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onseeking, setJSDocument_onseeking } },
    { "onselect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onselect, setJSDocument_onselect } },
    { "onslotchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onslotchange, setJSDocument_onslotchange } },
    { "onstalled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onstalled, setJSDocument_onstalled } },
    { "onsubmit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onsubmit, setJSDocument_onsubmit } },
    { "onsuspend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onsuspend, setJSDocument_onsuspend } },
    { "ontimeupdate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontimeupdate, setJSDocument_ontimeupdate } },
    { "ontoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontoggle, setJSDocument_ontoggle } },
    { "onvolumechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onvolumechange, setJSDocument_onvolumechange } },
    { "onwaiting"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwaiting, setJSDocument_onwaiting } },
    { "onwebkitanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitanimationend, setJSDocument_onwebkitanimationend } },
    { "onwebkitanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitanimationiteration, setJSDocument_onwebkitanimationiteration } },
    { "onwebkitanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitanimationstart, setJSDocument_onwebkitanimationstart } },
    { "onwebkittransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkittransitionend, setJSDocument_onwebkittransitionend } },
    { "onwheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwheel, setJSDocument_onwheel } },
    { "onmousewheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onmousewheel, setJSDocument_onmousewheel } },
    { "onsearch"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onsearch, setJSDocument_onsearch } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontouchcancel, setJSDocument_ontouchcancel } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontouchend, setJSDocument_ontouchend } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontouchmove, setJSDocument_ontouchmove } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontouchstart, setJSDocument_ontouchstart } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchforcechange"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontouchforcechange, setJSDocument_ontouchforcechange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "onwebkitmouseforcechanged"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitmouseforcechanged, setJSDocument_onwebkitmouseforcechanged } },
    { "onwebkitmouseforcedown"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitmouseforcedown, setJSDocument_onwebkitmouseforcedown } },
    { "onwebkitmouseforcewillbegin"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitmouseforcewillbegin, setJSDocument_onwebkitmouseforcewillbegin } },
    { "onwebkitmouseforceup"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onwebkitmouseforceup, setJSDocument_onwebkitmouseforceup } },
    { "onanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onanimationstart, setJSDocument_onanimationstart } },
    { "onanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onanimationiteration, setJSDocument_onanimationiteration } },
    { "onanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onanimationend, setJSDocument_onanimationend } },
    { "onanimationcancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onanimationcancel, setJSDocument_onanimationcancel } },
    { "ontransitionrun"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontransitionrun, setJSDocument_ontransitionrun } },
    { "ontransitionstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontransitionstart, setJSDocument_ontransitionstart } },
    { "ontransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontransitionend, setJSDocument_ontransitionend } },
    { "ontransitioncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ontransitioncancel, setJSDocument_ontransitioncancel } },
    { "ongotpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_ongotpointercapture, setJSDocument_ongotpointercapture } },
    { "onlostpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onlostpointercapture, setJSDocument_onlostpointercapture } },
    { "onpointerdown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerdown, setJSDocument_onpointerdown } },
    { "onpointermove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointermove, setJSDocument_onpointermove } },
    { "onpointerup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerup, setJSDocument_onpointerup } },
    { "onpointercancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointercancel, setJSDocument_onpointercancel } },
    { "onpointerover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerover, setJSDocument_onpointerover } },
    { "onpointerout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerout, setJSDocument_onpointerout } },
    { "onpointerenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerenter, setJSDocument_onpointerenter } },
    { "onpointerleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onpointerleave, setJSDocument_onpointerleave } },
    { "onselectstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onselectstart, setJSDocument_onselectstart } },
    { "onselectionchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_onselectionchange, setJSDocument_onselectionchange } },
    { "children"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_children, 0 } },
    { "firstElementChild"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_firstElementChild, 0 } },
    { "lastElementChild"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_lastElementChild, 0 } },
    { "childElementCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_childElementCount, 0 } },
    { "rootElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocument_rootElement, 0 } },
    { "getElementsByTagName"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getElementsByTagName, 1 } },
    { "getElementsByTagNameNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getElementsByTagNameNS, 2 } },
    { "getElementsByClassName"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getElementsByClassName, 1 } },
    { "createElement"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createElement, 1 } },
    { "createElementNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createElementNS, 2 } },
    { "createDocumentFragment"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createDocumentFragment, 0 } },
    { "createTextNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createTextNode, 1 } },
    { "createCDATASection"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createCDATASection, 1 } },
    { "createComment"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createComment, 1 } },
    { "createProcessingInstruction"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createProcessingInstruction, 2 } },
    { "importNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_importNode, 1 } },
    { "adoptNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_adoptNode, 1 } },
    { "createAttribute"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createAttribute, 1 } },
    { "createAttributeNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createAttributeNS, 2 } },
    { "createEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createEvent, 1 } },
    { "createRange"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createRange, 0 } },
    { "createNodeIterator"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createNodeIterator, 1 } },
    { "createTreeWalker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createTreeWalker, 1 } },
    { "caretRangeFromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_caretRangeFromPoint, 0 } },
    { "getCSSCanvasContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getCSSCanvasContext, 4 } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "exitPictureInPicture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_exitPictureInPicture, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "exitFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_exitFullscreen, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitExitFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_webkitExitFullscreen, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitCancelFullScreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_webkitCancelFullScreen, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "getElementsByName"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getElementsByName, 1 } },
    { "open"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_open, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_close, 0 } },
    { "write"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_write, 0 } },
    { "writeln"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_writeln, 0 } },
    { "hasFocus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_hasFocus, 0 } },
    { "execCommand"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_execCommand, 1 } },
    { "queryCommandEnabled"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_queryCommandEnabled, 1 } },
    { "queryCommandIndeterm"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_queryCommandIndeterm, 1 } },
    { "queryCommandState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_queryCommandState, 1 } },
    { "queryCommandSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_queryCommandSupported, 1 } },
    { "queryCommandValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_queryCommandValue, 1 } },
    { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_clear, 0 } },
    { "captureEvents"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_captureEvents, 0 } },
    { "releaseEvents"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_releaseEvents, 0 } },
#if ENABLE(POINTER_LOCK)
    { "exitPointerLock"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_exitPointerLock, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "getSelection"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getSelection, 0 } },
    { "hasStorageAccess"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_hasStorageAccess, 0 } },
    { "requestStorageAccess"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_requestStorageAccess, 0 } },
#if ENABLE(TOUCH_EVENTS)
    { "createTouch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createTouch, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "createTouchList"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createTouchList, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "startViewTransition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_startViewTransition, 0 } },
    { "elementFromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_elementFromPoint, 2 } },
    { "elementsFromPoint"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_elementsFromPoint, 2 } },
    { "getAnimations"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_getAnimations, 0 } },
    { "getElementById"_s, JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction, NoIntrinsic, { HashTableValue::DOMJITFunctionType, jsDocumentPrototypeFunction_getElementById, &DOMJITSignatureForDocumentGetElementById } },
    { "prepend"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_prepend, 0 } },
    { "append"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_append, 0 } },
    { "replaceChildren"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_replaceChildren, 0 } },
    { "querySelector"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_querySelector, 1 } },
    { "querySelectorAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_querySelectorAll, 1 } },
    { "createExpression"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createExpression, 1 } },
    { "createNSResolver"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_createNSResolver, 1 } },
    { "evaluate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentPrototypeFunction_evaluate, 2 } },
};

const ClassInfo JSDocumentPrototype::s_info = { "Document"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentPrototype) };

void JSDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocument::info(), JSDocumentPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "exitPictureInPicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "exitFullscreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitExitFullscreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitCancelFullScreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "startViewTransition"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollToTextFragmentFeatureDetectionEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fragmentDirective"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pictureInPictureEnabled"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fullscreenEnabled"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fullscreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onfullscreenchange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onfullscreenerror"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitFullscreenEnabled"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitFullscreenElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onwebkitfullscreenchange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onwebkitfullscreenerror"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitIsFullScreen"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitFullScreenKeyboardInputAllowed"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fullScreenEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitCurrentFullScreenElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().undoManagerAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "undoManager"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pictureInPictureElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fullscreenElement"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().searchInputIncrementalAttributeAndSearchEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onsearch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchcancel"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchmove"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchstart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchforcechange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSObject& unscopables = *constructEmptyObject(globalObject()->vm(), globalObject()->nullPrototypeObjectStructure());
    unscopables.putDirect(vm, Identifier::fromString(vm, "prepend"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "append"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "replaceChildren"_s), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "fullscreen"_s), jsBoolean(true));
    putDirectWithoutTransition(vm, vm.propertyNames->unscopablesSymbol, &unscopables, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDocument::s_info = { "Document"_s, &Base::s_info, &JSDocumentTable
#if ENABLE(JIT)
, &checkSubClassSnippetForJSDocument
#else
, nullptr
#endif
, CREATE_METHOD_TABLE(JSDocument) };

JSDocument::JSDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Document>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

Ref<Document> JSDocument::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSDocument::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDocumentPrototype::createStructure(vm, &globalObject, JSNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDocumentPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDocument::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDocument>(vm, globalObject);
}

JSValue JSDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentDOMConstructor, DOMConstructorID::Document>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDocumentPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDocument::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDocument_fragmentDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FragmentDirective>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fragmentDirectiveForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fragmentDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fragmentDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_implementationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMImplementation>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.implementation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_implementation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_implementationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_URLGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_URL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_URLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_documentURIGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_documentURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_documentURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_compatModeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.compatMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_compatMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_compatModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_characterSetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_characterSet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_characterSetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_charsetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_charset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_charsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_inputEncodingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_inputEncoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_inputEncodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_contentTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_contentType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_contentTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_doctypeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DocumentType>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.doctype())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_doctype, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_doctypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_documentElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.documentElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_documentElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_documentElementGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_xmlEncodingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.xmlEncoding())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_xmlEncoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_xmlEncodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_xmlVersionGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.xmlVersion())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_xmlVersion, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_xmlVersionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_xmlVersionSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setXMLVersion(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_xmlVersion, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_xmlVersionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_xmlStandaloneGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.xmlStandalone())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_xmlStandalone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_xmlStandaloneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_xmlStandaloneSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setXMLStandalone(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_xmlStandalone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_xmlStandaloneSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDocument_pictureInPictureEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentPictureInPicture::pictureInPictureEnabled(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_pictureInPictureEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_pictureInPictureEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDocument_timelineGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DocumentTimeline>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.timeline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_timeline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_timelineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_fontsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FontFaceSet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fonts())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fonts, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fontsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_scrollingElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.scrollingElementForAPI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_scrollingElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_scrollingElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_fullscreenEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::fullscreenEnabled(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fullscreenEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fullscreenEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_fullscreenEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(thisObject);
    UNUSED_PARAM(value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_fullscreenEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_fullscreenEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_fullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitIsFullScreen(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fullscreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_fullscreenSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(thisObject);
    UNUSED_PARAM(value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_fullscreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_fullscreenSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_onfullscreenchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().fullscreenchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onfullscreenchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onfullscreenchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_onfullscreenchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().fullscreenchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onfullscreenchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onfullscreenchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_onfullscreenerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().fullscreenerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onfullscreenerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onfullscreenerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_onfullscreenerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().fullscreenerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onfullscreenerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onfullscreenerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_webkitFullscreenEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitFullscreenEnabled(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_webkitFullscreenEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_webkitFullscreenEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_webkitFullscreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentFullscreen::webkitFullscreenElement(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_webkitFullscreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_webkitFullscreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_onwebkitfullscreenchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitfullscreenchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitfullscreenchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitfullscreenchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_onwebkitfullscreenchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitfullscreenchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitfullscreenchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitfullscreenchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_onwebkitfullscreenerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitfullscreenerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitfullscreenerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitfullscreenerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_onwebkitfullscreenerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitfullscreenerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitfullscreenerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitfullscreenerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_webkitIsFullScreenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitIsFullScreen(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_webkitIsFullScreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_webkitIsFullScreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_webkitFullScreenKeyboardInputAllowedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitFullScreenKeyboardInputAllowed(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_webkitFullScreenKeyboardInputAllowed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_webkitFullScreenKeyboardInputAllowedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_webkitCurrentFullScreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentFullscreen::webkitCurrentFullScreenElement(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_webkitCurrentFullScreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_webkitCurrentFullScreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDocument_locationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Location>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_locationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_locationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "location"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "href"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_location, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_locationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_domainGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.domain())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_domain, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_domainGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_domainSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDomain(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_domain, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_domainSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_referrerGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrerForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_referrer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_referrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_cookieGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.cookie())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_cookie, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_cookieGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_cookieSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCookie(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_cookie, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_cookieSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_lastModifiedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lastModified())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_lastModified, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_lastModifiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<Document::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_titleGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.title())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_title, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_titleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_titleSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTitle(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_title, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_titleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_dirGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.dir())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_dir, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_dirGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_dirSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDir(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_dir, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_dirSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_bodyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<HTMLElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bodyOrFrameset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_body, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_bodyGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_bodySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<HTMLElement>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Document"_s, "body"_s, "HTMLElement"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBodyOrFrameset(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_body, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_bodySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_headGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<HTMLHeadElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.head())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_head, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_headGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_imagesGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.images())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_images, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_imagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_embedsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.embeds())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_embeds, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_embedsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_pluginsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.embeds())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_plugins, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_pluginsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_linksGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.links())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_links, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_linksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_formsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.forms())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_forms, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_formsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_scriptsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.scripts())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_scripts, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_scriptsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_currentScriptGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentScript())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_currentScript, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_currentScriptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_defaultViewGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.windowProxy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_defaultView, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_defaultViewGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_designModeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.designMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_designMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_designModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_designModeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDesignMode(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_designMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_designModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onreadystatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().readystatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onreadystatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onreadystatechangeGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onreadystatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().readystatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onreadystatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onreadystatechangeSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_fgColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.fgColor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_fgColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFgColor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_fgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_fgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_linkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.linkColorForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_linkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_linkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_linkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLinkColorForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_linkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_linkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_vlinkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.vlinkColor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_vlinkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_vlinkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_vlinkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setVlinkColor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_vlinkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_vlinkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_alinkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.alinkColor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_alinkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_alinkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_alinkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlinkColor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_alinkColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_alinkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_bgColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.bgColor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_bgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_bgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_bgColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBgColor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_bgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_bgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_anchorsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.anchors())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_anchors, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_anchorsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_appletsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.applets())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_applets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_appletsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_allGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLAllCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.all())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_all, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_allGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_hiddenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hidden())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_hidden, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_hiddenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_visibilityStateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<VisibilityState>>(lexicalGlobalObject, throwScope, impl.visibilityState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_visibilityState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_visibilityStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_onvisibilitychangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().visibilitychangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onvisibilitychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onvisibilitychangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onvisibilitychangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().visibilitychangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onvisibilitychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onvisibilitychangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocument_onpointerlockchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerlockchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerlockchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerlockchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(POINTER_LOCK)
static inline bool setJSDocument_onpointerlockchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerlockchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerlockchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerlockchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocument_onpointerlockerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerlockerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerlockerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerlockerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(POINTER_LOCK)
static inline bool setJSDocument_onpointerlockerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerlockerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerlockerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerlockerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsDocument_undoManagerGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<UndoManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.undoManager())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_undoManager, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_undoManagerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_onbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecopyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforeinputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforepasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_activeElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_activeElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_activeElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDocument_pictureInPictureElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pictureInPictureElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_pictureInPictureElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_pictureInPictureElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDocument_styleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<StyleSheetList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleSheets())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_styleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_styleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_adoptedStyleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_adoptedStyleSheets.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.adoptedStyleSheetWrapper(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)));
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_adoptedStyleSheets.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_adoptedStyleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_adoptedStyleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_adoptedStyleSheetsSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    thisObject.setAdoptedStyleSheets(lexicalGlobalObject, value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_adoptedStyleSheets, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_adoptedStyleSheetsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocument_fullscreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentOrShadowRootFullscreen::fullscreenElement(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_fullscreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_fullscreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocument_fullscreenElementSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(thisObject);
    UNUSED_PARAM(value);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_fullscreenElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_fullscreenElementSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocument_pointerLockElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pointerLockElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_pointerLockElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_pointerLockElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsDocument_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onauxclickGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().auxclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onauxclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onauxclickSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().auxclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onauxclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onbeforetoggleGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onbeforetoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onbeforetoggleSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onbeforetoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplayEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onclickGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onclickSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().clickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncontentvisibilityautostatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncontentvisibilityautostatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncontentvisibilityautostatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncontentvisibilityautostatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contextmenuEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncopyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncopySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().copyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cuechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oncutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oncutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondblclickGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondblclickSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dblclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragoverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragoverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondragstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondragstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondropGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondropSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dropEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondropSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ondurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ondurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ondurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().durationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ondurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().emptiedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onformdataGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().formdataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onformdataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onformdataSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().formdataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onformdataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oninputGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oninputSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().inputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_oninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_oninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_oninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().invalidEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_oninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keydownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keypressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keyupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadeddataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousemoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpasteGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpasteSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpauseGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpauseSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pauseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onplayGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onplaySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onplayingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onplayingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().ratechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onresetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onresetSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resetEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onsecuritypolicyviolationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onsecuritypolicyviolationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onsecuritypolicyviolationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onsecuritypolicyviolationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onseekedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onseekedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onseekingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onseekingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onselectGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onselectSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onslotchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().slotchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onslotchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onslotchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().slotchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onslotchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onstalledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onstalledSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().stalledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().submitEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().suspendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().timeupdateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontoggleGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontoggleSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().toggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().volumechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().waitingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkittransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwheelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwheelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().wheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousewheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onsearchGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onsearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onsearchSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().searchEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onsearch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocument_ontouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocument_ontouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocument_ontouchendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocument_ontouchendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocument_ontouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocument_ontouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchmoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocument_ontouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocument_ontouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocument_ontouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocument_ontouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsDocument_onwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationiterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionrunEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ontransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ontransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ontransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ontransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_ongotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_ongotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_ongotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_ongotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerdownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointermoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointercancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_onselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_onselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDocument_onselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDocument_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::set<setJSDocument_onselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDocument_childrenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.children())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_children, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_childrenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_firstElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.firstElementChild())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_firstElementChild, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_firstElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_lastElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lastElementChild())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_lastElementChild, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_lastElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_childElementCountGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.childElementCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_childElementCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_childElementCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDocument_rootElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SVGSVGElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentSVG::rootElement(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocument_rootElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocument>::get<jsDocument_rootElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDocumentConstructorFunction_parseHTMLUnsafeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto htmlConversionResult = convert<IDLUnion<IDLInterface<TrustedHTML>, IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(htmlConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Document>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, Document::parseHTMLUnsafe(document, htmlConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentConstructorFunction_parseHTMLUnsafe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::callStatic<jsDocumentConstructorFunction_parseHTMLUnsafeBody>(*lexicalGlobalObject, *callFrame, "parseHTMLUnsafe");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getElementsByTagNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto qualifiedNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(qualifiedNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByTagName(qualifiedNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByTagName, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getElementsByTagNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getElementsByTagNameNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURIConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(namespaceURIConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(localNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByTagNameNS(namespaceURIConversionResult.releaseReturnValue(), localNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByTagNameNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getElementsByTagNameNSBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagNameNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getElementsByClassNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto classNamesConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(classNamesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByClassName(classNamesConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByClassName, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getElementsByClassNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByClassName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto localNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(localNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Element>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createElementForBindings(localNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createElement, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createElementBody>(*lexicalGlobalObject, *callFrame, "createElement");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createElementNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURIConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(namespaceURIConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto qualifiedNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(qualifiedNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Element>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createElementNS(namespaceURIConversionResult.releaseReturnValue(), qualifiedNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createElementNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createElementNSBody>(*lexicalGlobalObject, *callFrame, "createElementNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createDocumentFragmentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDocumentFragment())));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createDocumentFragment, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createDocumentFragmentBody>(*lexicalGlobalObject, *callFrame, "createDocumentFragment");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createTextNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Text>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createTextNode(dataConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTextNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createTextNodeBody>(*lexicalGlobalObject, *callFrame, "createTextNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createCDATASectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<CDATASection>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createCDATASection(dataConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createCDATASection, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createCDATASectionBody>(*lexicalGlobalObject, *callFrame, "createCDATASection");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createCommentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Comment>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createComment(dataConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createComment, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createCommentBody>(*lexicalGlobalObject, *callFrame, "createComment");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createProcessingInstructionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<ProcessingInstruction>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createProcessingInstruction(targetConversionResult.releaseReturnValue(), dataConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createProcessingInstruction, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createProcessingInstructionBody>(*lexicalGlobalObject, *callFrame, "createProcessingInstruction");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_importNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Document"_s, "importNode"_s, "Node"_s); });
    if (UNLIKELY(nodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto deepConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(deepConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.importNode(*nodeConversionResult.releaseReturnValue(), deepConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_importNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_importNodeBody>(*lexicalGlobalObject, *callFrame, "importNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_adoptNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node"_s, "Document"_s, "adoptNode"_s, "Node"_s); });
    if (UNLIKELY(nodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.adoptNode(*nodeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_adoptNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_adoptNodeBody>(*lexicalGlobalObject, *callFrame, "adoptNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto localNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(localNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAttribute(localNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createAttribute, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createAttributeBody>(*lexicalGlobalObject, *callFrame, "createAttribute");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURIConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(namespaceURIConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto qualifiedNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(qualifiedNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAttributeNS(namespaceURIConversionResult.releaseReturnValue(), qualifiedNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createAttributeNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createAttributeNSBody>(*lexicalGlobalObject, *callFrame, "createAttributeNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Event>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createEvent(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createEventBody>(*lexicalGlobalObject, *callFrame, "createEvent");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRange())));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createRange, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createRangeBody>(*lexicalGlobalObject, *callFrame, "createRange");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createNodeIteratorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rootConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root"_s, "Document"_s, "createNodeIterator"_s, "Node"_s); });
    if (UNLIKELY(rootConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto whatToShowConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0xFFFFFFFF }; });
    if (UNLIKELY(whatToShowConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto filterConversionResult = convert<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeObjectError(lexicalGlobalObject, scope, 2, "filter"_s, "Document"_s, "createNodeIterator"_s); });
    if (UNLIKELY(filterConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<NodeIterator>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createNodeIterator(*rootConversionResult.releaseReturnValue(), whatToShowConversionResult.releaseReturnValue(), filterConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createNodeIterator, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createNodeIteratorBody>(*lexicalGlobalObject, *callFrame, "createNodeIterator");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createTreeWalkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto rootConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root"_s, "Document"_s, "createTreeWalker"_s, "Node"_s); });
    if (UNLIKELY(rootConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto whatToShowConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0xFFFFFFFF }; });
    if (UNLIKELY(whatToShowConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto filterConversionResult = convert<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeObjectError(lexicalGlobalObject, scope, 2, "filter"_s, "Document"_s, "createTreeWalker"_s); });
    if (UNLIKELY(filterConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<TreeWalker>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createTreeWalker(*rootConversionResult.releaseReturnValue(), whatToShowConversionResult.releaseReturnValue(), filterConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTreeWalker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createTreeWalkerBody>(*lexicalGlobalObject, *callFrame, "createTreeWalker");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_caretRangeFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.caretRangeFromPoint(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_caretRangeFromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_caretRangeFromPointBody>(*lexicalGlobalObject, *callFrame, "caretRangeFromPoint");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getCSSCanvasContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(contextIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto widthConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto heightConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLUnion<IDLInterface<WebGLRenderingContext>, IDLInterface<WebGL2RenderingContext>, IDLInterface<GPUCanvasContext>, IDLInterface<ImageBitmapRenderingContext>, IDLInterface<CanvasRenderingContext2D>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCSSCanvasContext(contextIdConversionResult.releaseReturnValue(), nameConversionResult.releaseReturnValue(), widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getCSSCanvasContext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getCSSCanvasContextBody>(*lexicalGlobalObject, *callFrame, "getCSSCanvasContext");
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_exitPictureInPictureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDocument>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::DocumentPictureInPicture::exitPictureInPicture(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitPictureInPicture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDocument>::call<jsDocumentPrototypeFunction_exitPictureInPictureBody>(*lexicalGlobalObject, *callFrame, "exitPictureInPicture");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_exitFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDocument>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::DocumentFullscreen::exitFullscreen(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDocument>::call<jsDocumentPrototypeFunction_exitFullscreenBody>(*lexicalGlobalObject, *callFrame, "exitFullscreen");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_webkitExitFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return WebCore::DocumentFullscreen::webkitExitFullscreen(impl); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_webkitExitFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_webkitExitFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullscreen");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_webkitCancelFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return WebCore::DocumentFullscreen::webkitCancelFullScreen(impl); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_webkitCancelFullScreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_webkitCancelFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitCancelFullScreen");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getElementsByNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto elementNameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(elementNameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByName(elementNameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementsByName, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getElementsByNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_open1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unused1ConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (UNLIKELY(unused1ConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto unused2ConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (UNLIKELY(unused2ConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openForBindings(firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)).document(), unused1ConversionResult.releaseReturnValue(), unused2ConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_open2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto urlConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(urlConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto nameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto featuresConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(featuresConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openForBindings(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), urlConversionResult.releaseReturnValue(), nameConversionResult.releaseReturnValue(), featuresConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_openOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsDocumentPrototypeFunction_open1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsDocumentPrototypeFunction_open1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsDocumentPrototypeFunction_open1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsDocumentPrototypeFunction_open2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_open, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_openOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.closeForBindings(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_writeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto text = convertVariadicArguments<IDLUnion<IDLInterface<TrustedHTML>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.write(firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)).document(), WTFMove(text)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_write, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_writeBody>(*lexicalGlobalObject, *callFrame, "write");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_writelnBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto text = convertVariadicArguments<IDLUnion<IDLInterface<TrustedHTML>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.writeln(firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)).document(), WTFMove(text)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_writeln, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_writelnBody>(*lexicalGlobalObject, *callFrame, "writeln");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_hasFocusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasFocus())));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_hasFocus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_hasFocusBody>(*lexicalGlobalObject, *callFrame, "hasFocus");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_execCommandBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto showUIConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(showUIConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto valueConversionResult = convertOptionalWithDefault<IDLUnion<IDLDOMString, IDLInterface<TrustedHTML>>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnion<IDLDOMString, IDLInterface<TrustedHTML>>> { return Converter<IDLUnion<IDLDOMString, IDLInterface<TrustedHTML>>>::ReturnType { emptyString() }; });
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.execCommand(commandIdConversionResult.releaseReturnValue(), showUIConversionResult.releaseReturnValue(), valueConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_execCommand, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_execCommandBody>(*lexicalGlobalObject, *callFrame, "execCommand");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_queryCommandEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.queryCommandEnabled(commandIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandEnabled, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_queryCommandEnabledBody>(*lexicalGlobalObject, *callFrame, "queryCommandEnabled");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_queryCommandIndetermBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.queryCommandIndeterm(commandIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandIndeterm, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_queryCommandIndetermBody>(*lexicalGlobalObject, *callFrame, "queryCommandIndeterm");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_queryCommandStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.queryCommandState(commandIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_queryCommandStateBody>(*lexicalGlobalObject, *callFrame, "queryCommandState");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_queryCommandSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.queryCommandSupported(commandIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_queryCommandSupportedBody>(*lexicalGlobalObject, *callFrame, "queryCommandSupported");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_queryCommandValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto commandIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(commandIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.queryCommandValue(commandIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_queryCommandValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_queryCommandValueBody>(*lexicalGlobalObject, *callFrame, "queryCommandValue");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clear(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_captureEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.captureEvents(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_captureEvents, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_captureEventsBody>(*lexicalGlobalObject, *callFrame, "captureEvents");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_releaseEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.releaseEvents(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_releaseEvents, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_releaseEventsBody>(*lexicalGlobalObject, *callFrame, "releaseEvents");
}

#if ENABLE(POINTER_LOCK)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_exitPointerLockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.exitPointerLock(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_exitPointerLock, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_exitPointerLockBody>(*lexicalGlobalObject, *callFrame, "exitPointerLock");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getSelectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<DOMSelection>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSelection())));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getSelection, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getSelectionBody>(*lexicalGlobalObject, *callFrame, "getSelection");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_hasStorageAccessBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDocument>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::DocumentStorageAccess::hasStorageAccess(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_hasStorageAccess, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDocument>::call<jsDocumentPrototypeFunction_hasStorageAccessBody>(*lexicalGlobalObject, *callFrame, "hasStorageAccess");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_requestStorageAccessBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDocument>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::DocumentStorageAccess::requestStorageAccess(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_requestStorageAccess, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSDocument>::call<jsDocumentPrototypeFunction_requestStorageAccessBody>(*lexicalGlobalObject, *callFrame, "requestStorageAccess");
}

#if ENABLE(TOUCH_EVENTS)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createTouchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto windowConversionResult = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "window"_s, "Document"_s, "createTouch"_s, "WindowProxy"_s); });
    if (UNLIKELY(windowConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto targetConversionResult = convert<IDLNullable<IDLInterface<EventTarget>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "target"_s, "Document"_s, "createTouch"_s, "EventTarget"_s); });
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto identifierConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(identifierConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto pageXConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(pageXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto pageYConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(pageYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto screenXConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(screenXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto screenYConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    if (UNLIKELY(screenYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto webkitRadiusXConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    if (UNLIKELY(webkitRadiusXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->argument(8);
    auto webkitRadiusYConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument8.value());
    if (UNLIKELY(webkitRadiusYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument9 = callFrame->argument(9);
    auto webkitRotationAngleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument9.value());
    if (UNLIKELY(webkitRotationAngleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument10 = callFrame->argument(10);
    auto webkitForceConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument10.value());
    if (UNLIKELY(webkitForceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Touch>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WebCore::DocumentTouch::createTouch(impl, windowConversionResult.releaseReturnValue(), targetConversionResult.releaseReturnValue(), identifierConversionResult.releaseReturnValue(), pageXConversionResult.releaseReturnValue(), pageYConversionResult.releaseReturnValue(), screenXConversionResult.releaseReturnValue(), screenYConversionResult.releaseReturnValue(), webkitRadiusXConversionResult.releaseReturnValue(), webkitRadiusYConversionResult.releaseReturnValue(), webkitRotationAngleConversionResult.releaseReturnValue(), webkitForceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTouch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createTouchBody>(*lexicalGlobalObject, *callFrame, "createTouch");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createTouchListBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto touches = convertVariadicArguments<IDLInterface<Touch>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<TouchList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WebCore::DocumentTouch::createTouchList(impl, WTFMove(touches)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createTouchList, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createTouchListBody>(*lexicalGlobalObject, *callFrame, "createTouchList");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_startViewTransitionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto callbackOptionsConversionResult = convert<IDLOptional<IDLUnion<IDLCallbackFunction<JSViewTransitionUpdateCallback>, IDLDictionary<StartViewTransitionOptions>>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(callbackOptionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ViewTransition>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.startViewTransition(callbackOptionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_startViewTransition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_startViewTransitionBody>(*lexicalGlobalObject, *callFrame, "startViewTransition");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_elementFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.elementFromPoint(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_elementFromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_elementFromPointBody>(*lexicalGlobalObject, *callFrame, "elementFromPoint");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_elementsFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.elementsFromPoint(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_elementsFromPoint, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_elementsFromPointBody>(*lexicalGlobalObject, *callFrame, "elementsFromPoint");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<WebAnimation>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAnimations())));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getAnimations, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getAnimationsBody>(*lexicalGlobalObject, *callFrame, "getAnimations");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_getElementByIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto elementIdConversionResult = convert<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(elementIdConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementById(elementIdConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_getElementById, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_getElementByIdBody>(*lexicalGlobalObject, *callFrame, "getElementById");
}

JSC_DEFINE_JIT_OPERATION(jsDocumentPrototypeFunction_getElementByIdWithoutTypeCheck, JSC::EncodedJSValue, (JSC::JSGlobalObject* lexicalGlobalObject, JSDocument* castedThis, DOMJIT::IDLJSArgumentType<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>> encodedElementId))
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto elementId = DOMJIT::DirectConverter<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>::directConvert(*lexicalGlobalObject, encodedElementId);
    OPERATION_RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    OPERATION_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementById(WTFMove(elementId)))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_prependBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.prepend(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_prepend, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_prependBody>(*lexicalGlobalObject, *callFrame, "prepend");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_appendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.append(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_append, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_appendBody>(*lexicalGlobalObject, *callFrame, "append");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_replaceChildrenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceChildren(WTFMove(nodes)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_replaceChildren, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_replaceChildrenBody>(*lexicalGlobalObject, *callFrame, "replaceChildren");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_querySelectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto selectorsConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(selectorsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelector(selectorsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_querySelector, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_querySelectorBody>(*lexicalGlobalObject, *callFrame, "querySelector");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_querySelectorAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto selectorsConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(selectorsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelectorAll(selectorsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_querySelectorAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_querySelectorAllBody>(*lexicalGlobalObject, *callFrame, "querySelectorAll");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createExpressionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto expressionConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(expressionConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto resolverConversionResult = convert<IDLNullable<IDLInterface<XPathNSResolver>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "resolver"_s, "Document"_s, "createExpression"_s, "XPathNSResolver"_s); });
    if (UNLIKELY(resolverConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<XPathExpression>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createExpression(expressionConversionResult.releaseReturnValue(), resolverConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createExpression, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createExpressionBody>(*lexicalGlobalObject, *callFrame, "createExpression");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_createNSResolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nodeResolverConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "nodeResolver"_s, "Document"_s, "createNSResolver"_s, "Node"_s); });
    if (UNLIKELY(nodeResolverConversionResult.hasException(throwScope)))
       return encodedJSValue();
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.createNSResolverForBindings(*nodeResolverConversionResult.releaseReturnValue()); });
    return JSValue::encode(argument0.value());
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_createNSResolver, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_createNSResolverBody>(*lexicalGlobalObject, *callFrame, "createNSResolver");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunction_evaluateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto expressionConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(expressionConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto contextNodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "contextNode"_s, "Document"_s, "evaluate"_s, "Node"_s); });
    if (UNLIKELY(contextNodeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto resolverConversionResult = convert<IDLNullable<IDLInterface<XPathNSResolver>>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "resolver"_s, "Document"_s, "evaluate"_s, "XPathNSResolver"_s); });
    if (UNLIKELY(resolverConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto typeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto inResultConversionResult = convert<IDLNullable<IDLInterface<XPathResult>>>(*lexicalGlobalObject, argument4.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 4, "inResult"_s, "Document"_s, "evaluate"_s, "XPathResult"_s); });
    if (UNLIKELY(inResultConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<XPathResult>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.evaluate(expressionConversionResult.releaseReturnValue(), *contextNodeConversionResult.releaseReturnValue(), resolverConversionResult.releaseReturnValue(), typeConversionResult.releaseReturnValue(), inResultConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentPrototypeFunction_evaluate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunction_evaluateBody>(*lexicalGlobalObject, *callFrame, "evaluate");
}

JSC::GCClient::IsoSubspace* JSDocument::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDocument, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDocument.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDocument = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDocument.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDocument = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSDocument::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.append(thisObject->m_adoptedStyleSheets);
}

DEFINE_VISIT_CHILDREN(JSDocument);

template<typename Visitor>
void JSDocument::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSDocument::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSDocument::visitOutputConstraints(JSCell*, SlotVisitor&);
Document* JSDocument::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDocument*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
